/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.ix;

import com.db4o.MetaIndex;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.ix.IndexTransaction;
import com.db4o.internal.ix.Indexable4;
import com.db4o.internal.ix.IxFileRange;
import com.db4o.internal.ix.IxFileRangeReader;
import com.db4o.internal.ix.IxTree;

public class Index4 {
    public final Indexable4 _handler;
    private static int _version;
    public final MetaIndex _metaIndex;
    private IndexTransaction _globalIndexTransaction;
    private Collection4 _indexTransactions;
    private IxFileRangeReader _fileRangeReader;
    final boolean _nullHandling;

    public Index4(Transaction transaction, Indexable4 indexable4, MetaIndex metaIndex, boolean bl) {
        this._metaIndex = metaIndex;
        this._handler = indexable4;
        this._globalIndexTransaction = new IndexTransaction(transaction, this);
        this._nullHandling = bl;
        this.createGlobalFileRange();
    }

    public IndexTransaction dirtyIndexTransaction(Transaction transaction) {
        IndexTransaction indexTransaction = new IndexTransaction(transaction, this);
        if (this._indexTransactions == null) {
            this._indexTransactions = new Collection4();
        } else {
            IndexTransaction indexTransaction2 = (IndexTransaction)this._indexTransactions.get(indexTransaction);
            if (indexTransaction2 != null) {
                return indexTransaction2;
            }
        }
        transaction.addDirtyFieldIndex(indexTransaction);
        indexTransaction.setRoot(Tree.deepClone(this._globalIndexTransaction.getRoot(), indexTransaction));
        indexTransaction.i_version = ++_version;
        this._indexTransactions.add(indexTransaction);
        return indexTransaction;
    }

    public IndexTransaction globalIndexTransaction() {
        return this._globalIndexTransaction;
    }

    public IndexTransaction indexTransactionFor(Transaction transaction) {
        if (this._indexTransactions != null) {
            IndexTransaction indexTransaction = new IndexTransaction(transaction, this);
            if ((indexTransaction = (IndexTransaction)this._indexTransactions.get(indexTransaction)) != null) {
                return indexTransaction;
            }
        }
        return this._globalIndexTransaction;
    }

    private int[] freeForMetaIndex() {
        return new int[]{this._metaIndex.indexAddress, this._metaIndex.indexLength};
    }

    private void doFree(int[] nArray) {
        LocalObjectContainer localObjectContainer = this.file();
        for (int i = 0; i < nArray.length; i += 2) {
            localObjectContainer.free(nArray[i], nArray[i + 1]);
        }
    }

    public void commitFreeSpace(Index4 index4) {
        int n = this.countEntries();
        int n2 = (n + 4) * this.lengthPerEntry();
        int n3 = this.getSlot(n2);
        int n4 = this.getSlot(n2);
        this.doFree(this.freeForMetaIndex());
        this.doFree(index4.freeForMetaIndex());
        n = this.writeToNewSlot(n3);
        this.metaIndexSetMembers(n, n2, n3);
        this.createGlobalFileRange();
        int n5 = index4.writeToNewSlot(n4);
        index4.metaIndexSetMembers(n, n2, n4);
        index4.createGlobalFileRange();
    }

    private int lengthPerEntry() {
        return this._handler.linkLength() + 4;
    }

    private void metaIndexStore(int n, int n2, int n3) {
        Transaction transaction = this.trans();
        this.metaIndexSetMembers(n, n2, n3);
        transaction.stream().setInternal(transaction, this._metaIndex, 1, false);
    }

    private void metaIndexSetMembers(int n, int n2, int n3) {
        this._metaIndex.indexEntries = n;
        this._metaIndex.indexLength = n2;
        this._metaIndex.indexAddress = n3;
    }

    private int writeToNewSlot(int n) {
        Tree tree = this.getRoot();
        final StatefulBuffer statefulBuffer = new StatefulBuffer(this.trans(), n, this.lengthPerEntry());
        final int[] nArray = new int[]{0};
        if (tree != null) {
            tree.traverse(new Visitor4(){

                public void visit(Object object) {
                    nArray[0] = nArray[0] + ((IxTree)object).write(Index4.this._handler, statefulBuffer);
                }
            });
        }
        return nArray[0];
    }

    void commit(IndexTransaction indexTransaction) {
        this._indexTransactions.remove(indexTransaction);
        this._globalIndexTransaction.merge(indexTransaction);
        boolean bl = true;
        if (bl) {
            int n = this.countEntries();
            int n2 = this.countEntries() * this.lengthPerEntry();
            int n3 = this.getSlot(n2);
            int[] nArray = this.freeForMetaIndex();
            this.metaIndexStore(n, n2, n3);
            this.writeToNewSlot(n3);
            IxFileRange ixFileRange = this.createGlobalFileRange();
            if (this._indexTransactions != null) {
                Iterator4 iterator4 = this._indexTransactions.iterator();
                while (iterator4.moveNext()) {
                    final IndexTransaction indexTransaction2 = (IndexTransaction)iterator4.current();
                    Tree tree = ixFileRange;
                    if (tree != null) {
                        tree = (Tree)((Tree)tree).deepClone(indexTransaction2);
                    }
                    final Tree.ByRef byRef = new Tree.ByRef(tree);
                    indexTransaction2.getRoot().traverseFromLeaves(new Visitor4(){

                        public void visit(Object object) {
                            IxTree ixTree = (IxTree)object;
                            if (ixTree._version == indexTransaction2.i_version && !(ixTree instanceof IxFileRange)) {
                                ixTree.beginMerge();
                                byRef.value = Tree.add(byRef.value, ixTree);
                            }
                        }
                    });
                    indexTransaction2.setRoot(byRef.value);
                }
            }
            this.doFree(nArray);
        } else {
            Iterator4 iterator4 = this._indexTransactions.iterator();
            while (iterator4.moveNext()) {
                ((IndexTransaction)iterator4.current()).merge(indexTransaction);
            }
        }
    }

    private IxFileRange createGlobalFileRange() {
        IxFileRange ixFileRange = null;
        if (this._metaIndex.indexEntries > 0) {
            ixFileRange = new IxFileRange(this._globalIndexTransaction, this._metaIndex.indexAddress, 0, this._metaIndex.indexEntries);
        }
        this._globalIndexTransaction.setRoot(ixFileRange);
        return ixFileRange;
    }

    void rollback(IndexTransaction indexTransaction) {
        this._indexTransactions.remove(indexTransaction);
    }

    IxFileRangeReader fileRangeReader() {
        if (this._fileRangeReader == null) {
            this._fileRangeReader = new IxFileRangeReader(this._handler);
        }
        return this._fileRangeReader;
    }

    public String toString() {
        return super.toString();
    }

    private Transaction trans() {
        return this._globalIndexTransaction.i_trans;
    }

    private LocalObjectContainer file() {
        return this.trans().i_file;
    }

    private int getSlot(int n) {
        return this.file().getSlot(n);
    }

    private Tree getRoot() {
        return this._globalIndexTransaction.getRoot();
    }

    private int countEntries() {
        Tree tree = this.getRoot();
        return tree == null ? 0 : tree.size();
    }
}

