/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.btree;

import com.db4o.foundation.ArgumentNullException;
import com.db4o.internal.Buffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.btree.BTreeNode;

public class BTreePointer {
    private final BTreeNode _node;
    private final int _index;
    private final Transaction _transaction;
    private final Buffer _nodeReader;

    public static BTreePointer max(BTreePointer bTreePointer, BTreePointer bTreePointer2) {
        if (bTreePointer == null) {
            return bTreePointer;
        }
        if (bTreePointer2 == null) {
            return bTreePointer2;
        }
        if (bTreePointer.compareTo(bTreePointer2) > 0) {
            return bTreePointer;
        }
        return bTreePointer2;
    }

    public static BTreePointer min(BTreePointer bTreePointer, BTreePointer bTreePointer2) {
        if (bTreePointer == null) {
            return bTreePointer2;
        }
        if (bTreePointer2 == null) {
            return bTreePointer;
        }
        if (bTreePointer.compareTo(bTreePointer2) < 0) {
            return bTreePointer;
        }
        return bTreePointer2;
    }

    public BTreePointer(Transaction transaction, Buffer buffer, BTreeNode bTreeNode, int n) {
        if (transaction == null || bTreeNode == null) {
            throw new ArgumentNullException();
        }
        this._transaction = transaction;
        this._nodeReader = buffer;
        this._node = bTreeNode;
        this._index = n;
    }

    public final Transaction transaction() {
        return this._transaction;
    }

    public final int index() {
        return this._index;
    }

    public final BTreeNode node() {
        return this._node;
    }

    public final Object key() {
        return this.node().key(this.transaction(), this.nodeReader(), this.index());
    }

    private Buffer nodeReader() {
        return this._nodeReader;
    }

    public BTreePointer next() {
        for (int i = this.index() + 1; i < this.node().count(); ++i) {
            if (!this.node().indexIsValid(this.transaction(), i)) continue;
            return new BTreePointer(this.transaction(), this.nodeReader(), this.node(), i);
        }
        int n = -1;
        BTreeNode bTreeNode = this.node();
        Buffer buffer = null;
        while (n == -1) {
            if ((bTreeNode = bTreeNode.nextNode()) == null) {
                return null;
            }
            buffer = bTreeNode.prepareRead(this.transaction());
            n = bTreeNode.firstKeyIndex(this.transaction());
        }
        return new BTreePointer(this.transaction(), buffer, bTreeNode, n);
    }

    public BTreePointer previous() {
        for (int i = this.index() - 1; i >= 0; --i) {
            if (!this.node().indexIsValid(this.transaction(), i)) continue;
            return new BTreePointer(this.transaction(), this.nodeReader(), this.node(), i);
        }
        int n = -1;
        BTreeNode bTreeNode = this.node();
        Buffer buffer = null;
        while (n == -1) {
            if ((bTreeNode = bTreeNode.previousNode()) == null) {
                return null;
            }
            buffer = bTreeNode.prepareRead(this.transaction());
            n = bTreeNode.lastKeyIndex(this.transaction());
        }
        return new BTreePointer(this.transaction(), buffer, bTreeNode, n);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BTreePointer)) {
            return false;
        }
        BTreePointer bTreePointer = (BTreePointer)object;
        if (this.index() != bTreePointer.index()) {
            return false;
        }
        return this.node().equals(bTreePointer.node());
    }

    public int hashCode() {
        return this.node().hashCode();
    }

    public String toString() {
        return "BTreePointer(index=" + this.index() + ", node=" + this.node() + ")";
    }

    public int compareTo(BTreePointer bTreePointer) {
        if (null == bTreePointer) {
            throw new ArgumentNullException();
        }
        if (this.btree() != bTreePointer.btree()) {
            throw new IllegalArgumentException();
        }
        return this.btree().compareKeys(this.key(), bTreePointer.key());
    }

    private BTree btree() {
        return this.node().btree();
    }

    public static boolean lessThan(BTreePointer bTreePointer, BTreePointer bTreePointer2) {
        return BTreePointer.min(bTreePointer, bTreePointer2) == bTreePointer && !BTreePointer.equals(bTreePointer, bTreePointer2);
    }

    public static boolean equals(BTreePointer bTreePointer, BTreePointer bTreePointer2) {
        if (bTreePointer == null) {
            return bTreePointer2 == null;
        }
        return bTreePointer.equals(bTreePointer2);
    }

    public boolean isValid() {
        return this.node().indexIsValid(this.transaction(), this.index());
    }
}

