/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.CorruptionException;
import com.db4o.foundation.BitMap4;
import com.db4o.internal.Buffer;
import com.db4o.internal.LatinStringIO;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.SlotCopyHandler;
import com.db4o.internal.SlotReader;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.mapping.DefragContext;
import com.db4o.internal.mapping.IDMapping;
import com.db4o.internal.mapping.MappedIDPair;
import com.db4o.internal.mapping.MappingNotFoundException;
import com.db4o.internal.marshall.StringMarshaller;

public final class ReaderPair
implements SlotReader {
    private Buffer _source;
    private Buffer _target;
    private DefragContext _mapping;
    private Transaction _systemTrans;

    public ReaderPair(Buffer buffer, DefragContext defragContext, Transaction transaction) {
        this._source = buffer;
        this._mapping = defragContext;
        this._target = new Buffer(buffer.getLength());
        this._source.copyTo(this._target, 0, 0, this._source.getLength());
        this._systemTrans = transaction;
    }

    public int offset() {
        return this._source.offset();
    }

    public void offset(int n) {
        this._source.offset(n);
        this._target.offset(n);
    }

    public void incrementOffset(int n) {
        this._source.incrementOffset(n);
        this._target.incrementOffset(n);
    }

    public void incrementIntSize() {
        this.incrementOffset(4);
    }

    public int copyUnindexedID() {
        int n = this._source.readInt();
        int n2 = -1;
        try {
            n2 = this._mapping.mappedID(n);
        }
        catch (MappingNotFoundException mappingNotFoundException) {
            n2 = this._mapping.allocateTargetSlot(8);
            this._mapping.mapIDs(n, n2, false);
            this._mapping.registerUnindexed(n);
        }
        this._target.writeInt(n2);
        return n2;
    }

    public int copyID() {
        int n = this._mapping.mappedID(this._source.readInt(), false);
        this._target.writeInt(n);
        return n;
    }

    public int copyID(boolean bl, boolean bl2) {
        int n = this._source.readInt();
        return this.internalCopyID(bl, bl2, n);
    }

    public MappedIDPair copyIDAndRetrieveMapping() {
        int n = this._source.readInt();
        return new MappedIDPair(n, this.internalCopyID(false, false, n));
    }

    private int internalCopyID(boolean bl, boolean bl2, int n) {
        if (bl && n < 0) {
            n = -n;
        }
        int n2 = this._mapping.mappedID(n, bl2);
        if (bl && n < 0) {
            n2 = -n2;
        }
        this._target.writeInt(n2);
        return n2;
    }

    public void readBegin(byte by) {
        this._source.readBegin(by);
        this._target.readBegin(by);
    }

    public byte readByte() {
        byte by = this._source.readByte();
        this._target.incrementOffset(1);
        return by;
    }

    public int readInt() {
        int n = this._source.readInt();
        this._target.incrementOffset(4);
        return n;
    }

    public void writeInt(int n) {
        this._source.incrementOffset(4);
        this._target.writeInt(n);
    }

    public void write(LocalObjectContainer localObjectContainer, int n) {
        localObjectContainer.writeBytes(this._target, n, 0);
    }

    public String readShortString(LatinStringIO latinStringIO) throws CorruptionException {
        String string = StringMarshaller.readShort(latinStringIO, false, this._source);
        StringMarshaller.readShort(latinStringIO, false, this._target);
        return string;
    }

    public Buffer source() {
        return this._source;
    }

    public Buffer target() {
        return this._target;
    }

    public IDMapping mapping() {
        return this._mapping;
    }

    public Transaction systemTrans() {
        return this._systemTrans;
    }

    public DefragContext context() {
        return this._mapping;
    }

    public static void processCopy(DefragContext defragContext, int n, SlotCopyHandler slotCopyHandler) throws CorruptionException {
        ReaderPair.processCopy(defragContext, n, slotCopyHandler, false);
    }

    public static void processCopy(DefragContext defragContext, int n, SlotCopyHandler slotCopyHandler, boolean bl) throws CorruptionException {
        Buffer buffer = bl ? defragContext.sourceWriterByID(n) : defragContext.sourceReaderByID(n);
        int n2 = defragContext.mappedID(n);
        int n3 = buffer.getLength();
        int n4 = defragContext.allocateTargetSlot(n3);
        if (bl) {
            int n5 = ((StatefulBuffer)buffer).getAddress();
            defragContext.mapIDs(n5, n4, false);
        }
        Buffer buffer2 = new Buffer(8);
        buffer2.writeInt(n4);
        buffer2.writeInt(n3);
        defragContext.targetWriteBytes(buffer2, n2);
        ReaderPair readerPair = new ReaderPair(buffer, defragContext, defragContext.systemTrans());
        slotCopyHandler.processCopy(readerPair);
        defragContext.targetWriteBytes(readerPair, n4);
    }

    public void append(byte by) {
        this._source.incrementOffset(1);
        this._target.append(by);
    }

    public long readLong() {
        long l = this._source.readLong();
        this._target.incrementOffset(8);
        return l;
    }

    public void writeLong(long l) {
        this._source.incrementOffset(8);
        this._target.writeLong(l);
    }

    public BitMap4 readBitMap(int n) {
        BitMap4 bitMap4 = this._source.readBitMap(n);
        this._target.incrementOffset(bitMap4.marshalledLength());
        return bitMap4;
    }

    public void copyBytes(byte[] byArray, int n, int n2, int n3) {
        this._source.copyBytes(byArray, n, n2, n3);
    }

    public void readEnd() {
        this._source.readEnd();
        this._target.readEnd();
    }

    public int preparePayloadRead() {
        int n = this.readInt();
        this.readInt();
        int n2 = this.offset();
        this.offset(n);
        return n2;
    }
}

