/*
 * Decompiled with CFR 0.152.
 */
package msearch.filmeSuchen.sender;

import java.text.SimpleDateFormat;
import java.util.Date;
import msearch.daten.DatenFilm;
import msearch.filmeSuchen.MSFilmeSuchen;
import msearch.filmeSuchen.MSGetUrl;
import msearch.filmeSuchen.sender.MediathekReader;
import msearch.filmeSuchen.sender.MediathekZdf;
import msearch.tool.MSConfig;
import msearch.tool.MSLog;
import msearch.tool.MSStringBuilder;

public class MediathekZdfTivi
extends MediathekReader
implements Runnable {
    public static final String SENDERNAME = "ZDF-tivi";
    private final SimpleDateFormat sdfIn = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    private final SimpleDateFormat sdfOut_date = new SimpleDateFormat("dd.MM.yyyy");
    private final SimpleDateFormat sdfOut_time = new SimpleDateFormat("HH:mm:ss");
    private final MediathekReader.LinkedListUrl listeThemen_3 = new MediathekReader.LinkedListUrl();

    public MediathekZdfTivi(MSFilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 2, 500, startPrio);
    }

    @Override
    public synchronized void addToList() {
        this.listeThemen.clear();
        this.meldungStart();
        this.add_1();
        this.add_2();
        this.add_3();
        if (MSConfig.getStop()) {
            this.meldungThreadUndFertig();
        } else if (this.listeThemen.size() == 0 && this.listeThemen_3.size() == 0) {
            this.meldungThreadUndFertig();
        } else {
            this.meldungAddMax(this.listeThemen.size() + this.listeThemen_3.size());
            for (int t = 0; t < this.maxThreadLaufen; ++t) {
                Thread th = new Thread(new ThemaLaden());
                th.setName(SENDERNAME + t);
                th.start();
            }
        }
    }

    private void add_1() {
        String MUSTER_URL = "<ns3:page>/tiviVideos";
        MSStringBuilder seiteTivi_1 = new MSStringBuilder(65536);
        if ((seiteTivi_1 = this.getUrlIo.getUri(SENDERNAME, "http://www.tivi.de/tiviVideos/rueckblick?view=flashXml", "UTF-8", 6, seiteTivi_1, "")).length() == 0) {
            MSLog.fehlerMeldung(732323698, "Leere Seite");
        }
        int pos = 0;
        try {
            while ((pos = seiteTivi_1.indexOf("<ns3:page>/tiviVideos", pos)) != -1) {
                String url = "";
                int pos1 = pos += "<ns3:page>/tiviVideos".length();
                int pos2 = seiteTivi_1.indexOf("<", pos1);
                if (pos2 != -1 && (url = seiteTivi_1.substring(pos1, pos2)).contains("%2F")) {
                    url = url.replace("%2F", "/");
                }
                if (url.equals("")) {
                    MSLog.fehlerMeldung(309075109, "keine URL");
                    continue;
                }
                url = "http://www.tivi.de/tiviVideos" + url;
                this.listeThemen.addUrl(new String[]{url});
            }
        }
        catch (Exception ex) {
            MSLog.fehlerMeldung(302010498, ex);
        }
    }

    private void add_2() {
        String MUSTER_URL = "<ns3:page>/tiviVideos/beitrag";
        MSStringBuilder seiteTivi_1 = new MSStringBuilder(65536);
        if ((seiteTivi_1 = this.getUrlIo.getUri(SENDERNAME, "http://www.tivi.de/tiviVideos/?view=flashXml", "UTF-8", 6, seiteTivi_1, "")).length() == 0) {
            MSLog.fehlerMeldung(645121326, "Leere Seite");
        }
        int pos = 0;
        try {
            while ((pos = seiteTivi_1.indexOf("<ns3:page>/tiviVideos/beitrag", pos)) != -1) {
                String url = "";
                int pos1 = pos += "<ns3:page>/tiviVideos/beitrag".length();
                int pos2 = seiteTivi_1.indexOf("<", pos1);
                if (pos2 != -1 && (url = seiteTivi_1.substring(pos1, pos2)).contains("%2F")) {
                    url = url.replace("%2F", "/");
                }
                if (url.equals("")) {
                    MSLog.fehlerMeldung(915263985, "keine URL");
                    continue;
                }
                url = "http://www.tivi.de/tiviVideos/beitrag" + url;
                this.listeThemen.addUrl(new String[]{url});
            }
        }
        catch (Exception ex) {
            MSLog.fehlerMeldung(730169702, ex);
        }
    }

    private void add_3() {
        String MUSTER_URL = "type=\"broadcast\">";
        MSStringBuilder seiteTivi_1 = new MSStringBuilder(65536);
        if ((seiteTivi_1 = this.getUrlIo.getUri(SENDERNAME, "http://www.tivi.de/tiviVideos/navigation?view=flashXml", "UTF-8", 6, seiteTivi_1, "")).length() == 0) {
            MSLog.fehlerMeldung(195623078, "Leere Seite");
        }
        int pos = 0;
        try {
            while ((pos = seiteTivi_1.indexOf("type=\"broadcast\">", pos)) != -1) {
                String url = "";
                int pos1 = pos += "type=\"broadcast\">".length();
                int pos2 = seiteTivi_1.indexOf("<", pos1);
                if (pos2 != -1 && (url = seiteTivi_1.substring(pos1, pos2)).contains("%2F")) {
                    url = url.replace("%2F", "/");
                }
                if (url.equals("")) {
                    MSLog.fehlerMeldung(152378787, "keine URL");
                    continue;
                }
                url = "http://www.tivi.de" + url;
                this.listeThemen_3.addUrl(new String[]{url});
            }
        }
        catch (Exception ex) {
            MSLog.fehlerMeldung(906037912, ex);
        }
    }

    private class ThemaLaden
    implements Runnable {
        MSGetUrl getUrl;
        MSStringBuilder seite1;
        MSStringBuilder seite2;

        private ThemaLaden() {
            this.getUrl = new MSGetUrl(MediathekZdfTivi.this.wartenSeiteLaden);
            this.seite1 = new MSStringBuilder(65536);
            this.seite2 = new MSStringBuilder(65536);
        }

        @Override
        public void run() {
            try {
                String[] link;
                MediathekZdfTivi.this.meldungAddThread();
                while (!MSConfig.getStop() && (link = MediathekZdfTivi.this.listeThemen.getListeThemen()) != null) {
                    this.addTivi_(link[0]);
                    MediathekZdfTivi.this.meldungProgress(link[0]);
                }
                while (!MSConfig.getStop() && (link = MediathekZdfTivi.this.listeThemen_3.getListeThemen()) != null) {
                    this.add_(link[0]);
                    MediathekZdfTivi.this.meldungProgress(link[0]);
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(731214569, ex);
            }
            MediathekZdfTivi.this.meldungThreadUndFertig();
        }

        private void add_(String url_) {
            String MUSTER_START = "<ns3:video-teaser>";
            this.seite2 = MediathekZdfTivi.this.getUrlIo.getUri(MediathekZdfTivi.SENDERNAME, url_, "UTF-8", 1, this.seite2, "");
            if (this.seite2.length() == 0) {
                MSLog.fehlerMeldung(302010698, "Leere Seite");
            }
            int pos = 0;
            try {
                while (!MSConfig.getStop() && (pos = this.seite2.indexOf("<ns3:video-teaser>", pos)) != -1) {
                    String url = this.seite2.extract("<ns3:page>", "<", pos += "<ns3:video-teaser>".length());
                    if (url.equals("")) {
                        MSLog.fehlerMeldung(732698720, "keine URL");
                        continue;
                    }
                    if (url.contains("%2F")) {
                        url = url.replace("%2F", "/");
                    }
                    url = "http://www.tivi.de" + url;
                    this.addTivi_(url);
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(701212145, ex);
            }
        }

        private void addTivi_(String url) {
            String zeit = "";
            try {
                long dauerL;
                String urlFilm = "";
                MediathekZdfTivi.this.meldung(url);
                this.seite1 = this.getUrl.getUri_Utf(MediathekZdfTivi.SENDERNAME, url, this.seite1, "");
                if (this.seite1.length() == 0) {
                    MSLog.fehlerMeldung(301649897, "Leere Seite Tivi-2: " + url);
                    return;
                }
                String thema = this.seite1.extract("<title>", "<");
                String titel = this.seite1.extract("<subtitle>", "<");
                String text = this.seite1.extract("<text>", "<");
                String bild = this.seite1.extract("<image>", "<");
                if (!bild.isEmpty()) {
                    bild = "http://www.tivi.de" + bild;
                }
                String website = this.seite1.extract("<link>", "<");
                String dauer = this.seite1.extract("<ns3:duration>", "<");
                if (dauer.isEmpty()) {
                    dauer = this.seite1.extract("<duration>", "<");
                }
                try {
                    dauer = dauer.replace("P0Y0M0DT", "");
                    String h = dauer.substring(0, dauer.indexOf("H"));
                    int ih = Integer.parseInt(h);
                    String m = dauer.substring(dauer.indexOf("H") + 1, dauer.indexOf("M"));
                    int im = Integer.parseInt(m);
                    String s = dauer.substring(dauer.indexOf("M") + 1, dauer.indexOf("."));
                    int is = Integer.parseInt(s);
                    dauerL = ih * 60 * 60 + im * 60 + is;
                }
                catch (Exception ex) {
                    dauerL = 0L;
                    MSLog.fehlerMeldung(349761012, ex, "Dauer: " + url);
                }
                zeit = "";
                String datum = this.seite1.extract("<airTime>", "<");
                try {
                    Date filmDate = MediathekZdfTivi.this.sdfIn.parse(datum);
                    datum = MediathekZdfTivi.this.sdfOut_date.format(filmDate);
                    zeit = MediathekZdfTivi.this.sdfOut_time.format(filmDate);
                }
                catch (Exception ex) {
                    MSLog.fehlerMeldung(649600299, ex, "Datum: " + url);
                }
                int pos3 = 0;
                while (!((pos3 = this.seite1.indexOf("<ns4:quality>veryhigh</ns4:quality>", pos3)) == -1 || (urlFilm = this.seite1.extract("<ns4:url>", "<", pos3 += 5)).startsWith("http") && urlFilm.endsWith("mp4") && !urlFilm.contains("metafilegenerator"))) {
                }
                if (urlFilm.isEmpty()) {
                    MSLog.fehlerMeldung(159876234, "kein Film: " + url);
                } else {
                    if (urlFilm.startsWith("http://tvdl.zdf.de")) {
                        urlFilm = urlFilm.replace("http://tvdl.zdf.de", "http://nrodl.zdf.de");
                    }
                    DatenFilm film = new DatenFilm(MediathekZdfTivi.SENDERNAME, thema, website, titel, urlFilm, "", datum, zeit, dauerL, text);
                    MediathekZdf.urlTauschen(film, url, MediathekZdfTivi.this.mSearchFilmeSuchen);
                    MediathekZdfTivi.this.addFilm(film);
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(454123698, ex);
            }
        }
    }
}

