/*
 * Decompiled with CFR 0.152.
 */
package msearch.filmeSuchen;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import msearch.filmeSuchen.MSRunSender;

public class MSListeRunSender
extends LinkedList<MSRunSender> {
    private static final String TRENNER = " | ";
    private static final String SENDER = " Sender ";

    public boolean listeFertig() {
        for (MSRunSender run : this) {
            if (run.fertig) continue;
            return false;
        }
        return true;
    }

    public MSRunSender getSender(String sender) {
        for (MSRunSender run : this) {
            if (!run.sender.equals(sender)) continue;
            return run;
        }
        return null;
    }

    public MSRunSender senderFertig(String sender) {
        for (MSRunSender run : this) {
            if (!run.sender.equals(sender)) continue;
            run.fertig = true;
            run.endZeit = new Date();
            return run;
        }
        return null;
    }

    public String getSenderRun() {
        String ret = "";
        for (MSRunSender run : this) {
            if (run.fertig) continue;
            ret = ret + run.sender + " ";
        }
        return ret;
    }

    public int getAnzSenderRun() {
        int ret = 0;
        for (MSRunSender run : this) {
            if (run.fertig) continue;
            ++ret;
        }
        return ret;
    }

    public int getMax() {
        int ret = 0;
        for (MSRunSender run : this) {
            ret += run.max;
        }
        return ret;
    }

    public int getProgress() {
        int prog = 0;
        int max = 0;
        for (MSRunSender run : this) {
            prog += run.progress;
            max += run.max;
        }
        if (prog >= max && max >= 1) {
            prog = max - 1;
        }
        return prog;
    }

    public void inc(String sender, MSRunSender.Count what) {
        this.inc(sender, what.ordinal(), 1L);
    }

    public void inc(String sender, MSRunSender.Count what, long i) {
        this.inc(sender, what.ordinal(), i);
    }

    public void inc(String sender, int what, long inc) {
        int n = what;
        this.getCounter((String)sender).counter[n] = this.getCounter((String)sender).counter[n] + inc;
    }

    public long get(String sender, MSRunSender.Count what) {
        return this.getCounter((String)sender).counter[what.ordinal()];
    }

    public long get(String sender, int i) {
        return this.getCounter((String)sender).counter[i];
    }

    public long get(MSRunSender.Count what) {
        long ret = 0L;
        for (MSRunSender run : this) {
            ret += run.counter[what.ordinal()];
        }
        return ret;
    }

    public ArrayList<String> getTextCount(ArrayList<String> ret) {
        this.getTextCount_(ret, new MSRunSender.Count[]{MSRunSender.Count.ANZAHL, MSRunSender.Count.FILME, MSRunSender.Count.FEHLER, MSRunSender.Count.FEHLVERSUCHE, MSRunSender.Count.WARTEZEIT_FEHLVERSUCHE, MSRunSender.Count.PROXY, MSRunSender.Count.NO_BUFFER});
        ret.add("");
        ret.add("");
        this.getTextCount_(ret, new MSRunSender.Count[]{MSRunSender.Count.SUM_DATA_BYTE, MSRunSender.Count.SUM_TRAFFIC_BYTE, MSRunSender.Count.SUM_TRAFFIC_LOADART_NIX, MSRunSender.Count.SUM_TRAFFIC_LOADART_DEFLATE, MSRunSender.Count.SUM_TRAFFIC_LOADART_GZIP, MSRunSender.Count.GET_SIZE_SUM, MSRunSender.Count.GET_SIZE_SUM403, MSRunSender.Count.GET_SIZE_PROXY});
        ret.add("");
        ret.add("");
        return ret;
    }

    public void getTextSum(ArrayList<String> retArray) {
        String[] titel1 = new String[]{SENDER, " [min] ", " [kB/s] ", "s/Seite", "Threads", "Wait"};
        String zeile = "";
        String[] names = new String[titel1.length];
        for (int i = 0; i < titel1.length; ++i) {
            names[i] = titel1[i];
            zeile = zeile + this.textLaenge(names[i].length(), names[i]) + TRENNER;
        }
        retArray.add(zeile);
        retArray.add("-------------------------------------------------------");
        for (MSRunSender run : this) {
            int dauerSender = run.getLaufzeitSekunden();
            long groesseByte = this.get(run.sender, MSRunSender.Count.SUM_TRAFFIC_BYTE);
            long anzahlSeiten = this.get(run.sender, MSRunSender.Count.ANZAHL);
            String rate = "";
            if (groesseByte > 0L && dauerSender > 0) {
                double doub = 1.0 * (double)groesseByte / (double)dauerSender / 1000.0;
                rate = doub < 1.0 ? "<1" : String.format("%.1f", doub);
            }
            String dauerProSeite = "";
            if (anzahlSeiten > 0L) {
                dauerProSeite = String.format("%.2f", 1.0 * (double)dauerSender / (double)anzahlSeiten);
            }
            zeile = this.textLaenge(titel1[0].length(), run.sender) + TRENNER;
            zeile = zeile + this.textLaenge(titel1[1].length(), run.getLaufzeitMinuten()) + TRENNER;
            zeile = zeile + this.textLaenge(titel1[2].length(), rate) + TRENNER;
            zeile = zeile + this.textLaenge(titel1[3].length(), dauerProSeite) + TRENNER;
            zeile = zeile + this.textLaenge(titel1[4].length(), run.maxThreads + "") + TRENNER;
            zeile = zeile + this.textLaenge(titel1[5].length(), run.waitOnLoad + "") + TRENNER;
            retArray.add(zeile);
        }
        retArray.add("");
        retArray.add("");
    }

    private MSRunSender getCounter(String sender) {
        for (MSRunSender run : this) {
            if (!run.sender.equals(sender)) continue;
            return run;
        }
        MSRunSender ret = new MSRunSender(sender, 0, 0);
        this.add(ret);
        return ret;
    }

    private ArrayList<String> getTextCount_(ArrayList<String> ret, MSRunSender.Count[] spalten) {
        String[] names = MSRunSender.Count.getNames();
        String zeile = " Sender  | ";
        for (int i = 0; i < names.length; ++i) {
            for (MSRunSender.Count sp : spalten) {
                if (i != sp.ordinal()) continue;
                zeile = zeile + this.textLaenge(names[i].length(), names[i]) + TRENNER;
            }
        }
        ret.add(zeile);
        ret.add("-------------------------------------------------------");
        for (MSRunSender run : this) {
            zeile = this.textLaenge(SENDER.length(), run.sender) + TRENNER;
            for (int i = 0; i < names.length; ++i) {
                for (MSRunSender.Count sp : spalten) {
                    if (i != sp.ordinal()) continue;
                    if (i == MSRunSender.Count.SUM_DATA_BYTE.ordinal() || i == MSRunSender.Count.SUM_TRAFFIC_BYTE.ordinal() || i == MSRunSender.Count.SUM_TRAFFIC_LOADART_DEFLATE.ordinal() || i == MSRunSender.Count.SUM_TRAFFIC_LOADART_GZIP.ordinal() || i == MSRunSender.Count.SUM_TRAFFIC_LOADART_NIX.ordinal()) {
                        zeile = zeile + this.textLaenge(names[i].length(), String.valueOf(MSRunSender.getStringZaehler(this.get(run.sender, i)))) + TRENNER;
                        continue;
                    }
                    if (i == MSRunSender.Count.WARTEZEIT_FEHLVERSUCHE.ordinal()) {
                        long l = this.get(run.sender, i);
                        zeile = zeile + this.textLaenge(names[i].length(), String.valueOf(l == 0L ? "0" : (l < 1000L ? "<1" : Long.valueOf(l / 1000L)))) + TRENNER;
                        continue;
                    }
                    zeile = zeile + this.textLaenge(names[i].length(), String.valueOf(this.get(run.sender, i))) + TRENNER;
                }
            }
            ret.add(zeile);
        }
        ret.add("");
        return ret;
    }

    private String textLaenge(int max, String text) {
        if (text.length() > max) {
            text = text.substring(0, max - 1);
        }
        while (text.length() < max) {
            text = text + " ";
        }
        return text;
    }
}

