/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller;

import mediathek.controller.Log;
import mediathek.tool.GuiFunktionen;
import msearch.tool.GermanStringSorter;

public class MVUsedUrl
implements Comparable<MVUsedUrl> {
    public static final String[] title = new String[]{"Datum", "Thema", "Titel", "Url"};
    public static final int USED_URL_DATUM = 0;
    public static final int USED_URL_THEMA = 1;
    public static final int USED_URL_TITEL = 2;
    public static final int USED_URL_URL = 3;
    private static final GermanStringSorter sorter = GermanStringSorter.getInstance();
    private static final String TRENNER = "  |###|  ";
    private static final String PAUSE = " |#| ";
    String[] uUrl;

    public MVUsedUrl(String date, String thema, String title, String url) {
        this.uUrl = new String[]{date, thema, title, url};
    }

    public static String getUsedUrl(String date, String thema, String title, String url) {
        return date + PAUSE + GuiFunktionen.textLaenge(25, MVUsedUrl.putzen(thema), false, false) + PAUSE + GuiFunktionen.textLaenge(40, MVUsedUrl.putzen(title), false, false) + TRENNER + url + "\n";
    }

    public String getUsedUrl() {
        return this.uUrl[0] + PAUSE + GuiFunktionen.textLaenge(25, MVUsedUrl.putzen(this.uUrl[1]), false, false) + PAUSE + GuiFunktionen.textLaenge(40, MVUsedUrl.putzen(this.uUrl[2]), false, false) + TRENNER + this.uUrl[3] + "\n";
    }

    public static MVUsedUrl getUrlAusZeile(String zeile) {
        String url = "";
        String thema = "";
        String titel = "";
        String datum = "";
        try {
            if (zeile.contains(TRENNER)) {
                int a1 = zeile.lastIndexOf(TRENNER);
                url = zeile.substring(a1 += TRENNER.length()).trim();
                titel = zeile.substring(zeile.lastIndexOf(PAUSE) + PAUSE.length(), zeile.lastIndexOf(TRENNER)).trim();
                datum = zeile.substring(0, zeile.indexOf(PAUSE)).trim();
                thema = zeile.substring(zeile.indexOf(PAUSE) + PAUSE.length(), zeile.lastIndexOf(PAUSE)).trim();
            } else {
                url = zeile;
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung(398853224, ex);
        }
        return new MVUsedUrl(datum, thema, titel, url);
    }

    public static String getHeaderString() {
        return GuiFunktionen.textLaenge(40, title[2], false, false) + "    " + GuiFunktionen.textLaenge(25, title[1], false, false) + "    " + GuiFunktionen.textLaenge(10, title[0], false, false) + "    " + title[3];
    }

    public String getString() {
        return GuiFunktionen.textLaenge(40, this.uUrl[2], false, false) + "    " + GuiFunktionen.textLaenge(25, this.uUrl[1], false, false) + "    " + (this.uUrl[0].isEmpty() ? "          " : this.uUrl[0]) + "    " + this.uUrl[3];
    }

    public String getUrl() {
        return this.uUrl[3];
    }

    @Override
    public int compareTo(MVUsedUrl arg0) {
        return sorter.compare(this.uUrl[2], arg0.uUrl[2]);
    }

    private static String putzen(String s) {
        s = s.replace("\n", "");
        s = s.replace("|", "");
        s = s.replace(TRENNER, "");
        return s;
    }
}

