/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.painter;

import com.explodingpixels.painter.MacWidgetsPainter;
import com.explodingpixels.widgets.WindowUtils;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import javax.swing.SwingUtilities;

public class FocusStatePainter
implements MacWidgetsPainter<Component> {
    private MacWidgetsPainter<Component> fComponentFocusedPainter;
    private MacWidgetsPainter<Component> fWindowFocusedPainter;
    private MacWidgetsPainter<Component> fWindowUnfocusedPainter;

    public FocusStatePainter(MacWidgetsPainter<Component> componentFocusedPainter, MacWidgetsPainter<Component> windowUnfocusedPainter) {
        this(componentFocusedPainter, windowUnfocusedPainter, windowUnfocusedPainter);
    }

    public FocusStatePainter(MacWidgetsPainter<Component> componentFocusedPainter, MacWidgetsPainter<Component> windowFocusedPainter, MacWidgetsPainter<Component> windowUnfocusedPainter) {
        if (componentFocusedPainter == null) {
            throw new IllegalArgumentException("Component focused Painter cannot be null.");
        }
        if (windowFocusedPainter == null) {
            throw new IllegalArgumentException("Window focused Painter cannot be null.");
        }
        if (windowUnfocusedPainter == null) {
            throw new IllegalArgumentException("Window unfocused Painter cannot be null.");
        }
        this.fComponentFocusedPainter = componentFocusedPainter;
        this.fWindowFocusedPainter = windowFocusedPainter;
        this.fWindowUnfocusedPainter = windowUnfocusedPainter;
    }

    @Override
    public void paint(Graphics2D g, Component component, int width, int height) {
        Window activeAncestor = null;
        Window active = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (active != null) {
            activeAncestor = SwingUtilities.getWindowAncestor(active);
        }
        Window componentAncestor = SwingUtilities.getWindowAncestor(component);
        MacWidgetsPainter<Component> painterToUse = component.hasFocus() || componentAncestor.equals(activeAncestor) ? this.fComponentFocusedPainter : (WindowUtils.isParentWindowFocused(component) || componentAncestor.equals(activeAncestor) ? this.fWindowFocusedPainter : this.fWindowUnfocusedPainter);
        painterToUse.paint(g, component, width, height);
    }
}

