<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); ?>
<div id="help-holder">
  <p class='header1'>Good practices</p>
  <p>This is a list of things that have been known to work for various users of Aigaion. Read them at your leisure, and use what you think might work for you as well. Or ignore everything that you think to be nonsense.</p>
    <ul>
      <li><b><i>Check if the paper was already added</i></b> before you go through all the work of adding an entry to a shared database, e.g. by searching for the author names or the title. If you share your database with other people and you want to add a new article to the database, it may be that somebody already added it. After all, if this other person added it to a topic for which you are not registered, you will not see it appear.</li>
      <li><b><i>Use a consistent scheme for naming your BibTeX ID's</i></b>. It saves you a lot of work when you are writing a paper in LaTeX and need to cite papers contained in the BibTeX export of Aigaion.</li>
      <li><b><i>Create a 'To be processed' topic</i></b>. When you are quickly scanning a new paper, adding it to the database and writing a preliminary note for it, you sometimes don't take the time to immediately embed the paper in the proper places in the topic hierarchy. To be sure that you don't lose track of it and forget to do this later, it might be useful to add that paper under the topic 'To be processed'. Later on you can then just clean up that topic every once in a while.</li>
      <li><b><i>Maintain the database</i></b>. Sometimes take the time to browse through the topics and papers to see if the structures still make sense to you, and whether papers are stored under the right topics. Often your perception of a paper changes over time, so when you are rereading a paper, and writing comments on it, it might be a good moment to see if it still is assigned to all the right topics. Used in this way, the database will help you structure your views on the literature, besides just serving as a repository of BibTeX links.</li>
      <li><b><i>Adding publications</i></b>: It is a good practice to add only those publications of which you really have an opinion. It is better to have fewer publications which are carefully placed in the topic hierarchy and commented with notes than to add anything that you ever saw, which would result in a database full of uninteresting things among which the relevant papers would be hard to find.</li>
    </ul>
  </p>
</div>
