/*
 * Decompiled with CFR 0.152.
 */
package edsim51sh;

import edsim51sh.Cpu;
import edsim51sh.MainPanel;
import edsim51sh.exceptions.BitAddressAccessException;
import edsim51sh.ports.Port;
import edsim51sh.ports.PortPinDescriptions;
import edsim51sh.settings.HardwareSettings;
import edsim51sh.settings.HardwareSettingsReaderWriter;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;

public abstract class TargetBoard {
    HardwareSettings hardwareSettings;
    PortPinDescriptions portPinDescriptions;
    String title;
    private Cpu cpu;
    private HardwareSettingsReaderWriter hsrw;
    private MainPanel mainPanel;
    private JPanel gui;
    private String version;

    public TargetBoard() {
        this("edsim51shSettings.ser");
    }

    public TargetBoard(String hardwareSettingsFileName) {
        this.hsrw = new HardwareSettingsReaderWriter(hardwareSettingsFileName, this);
        this.hardwareSettings = this.hsrw.readSettings();
    }

    public void init(JPanel gui, String title, String version) {
        this.gui = gui;
        this.title = title;
        this.version = version;
    }

    public void registerAlwaysOnTopFrame(JFrame alwaysOnTopFrame) {
        this.mainPanel.addAlwaysOnTopFrame(alwaysOnTopFrame);
    }

    public void registerAlwaysOnTopCheckBox(JCheckBox alwaysOnTopCheckBox) {
        this.mainPanel.addAlwaysOnTopCheckBox(alwaysOnTopCheckBox);
    }

    public double getCpuMachineCycleLength() {
        if (this.cpu == null) {
            return 1.0;
        }
        return this.cpu.getMachineCycleLength();
    }

    public void setPortPinDescription(int portNumber, int pinNumber, String description) {
        this.setPortPinDescription(portNumber, pinNumber, description, null);
    }

    public void setPortPinDescription(int portNumber, int pinNumber, String description, String toolTip) {
        if (this.portPinDescriptions == null) {
            this.portPinDescriptions = new PortPinDescriptions();
        }
        this.portPinDescriptions.setPortPinDescription(portNumber, pinNumber, description, toolTip);
    }

    public boolean setPortPin(int portNumber, int pinNumber, int hardwareId) {
        if (this.cpu == null || this.cpu.memory == null) {
            return false;
        }
        Port port = this.cpu.memory.getPort(portNumber &= 3);
        boolean status = port.hardwareSetPortPin(pinNumber &= 7, hardwareId);
        if (this.cpu.memory.port0.isItTimeToUpdateGui()) {
            this.mainPanel.updateGui();
        }
        return status;
    }

    public boolean setPortPin(int portNumber, int pinNumber) {
        return this.setPortPin(portNumber, pinNumber, 0);
    }

    public void clearPortPin(int portNumber, int pinNumber, int hardwareId) {
        if (this.cpu == null || this.cpu.memory == null) {
            return;
        }
        Port port = this.cpu.memory.getPort(portNumber &= 3);
        port.hardwareClearPortPin(pinNumber &= 7, hardwareId);
        if (this.cpu.memory.port0.isItTimeToUpdateGui()) {
            this.mainPanel.updateGui();
        }
    }

    public void clearPortPin(int portNumber, int pinNumber) {
        this.clearPortPin(portNumber, pinNumber, 0);
    }

    public int readPortPin(int portNumber, int pinNumber) {
        portNumber &= 3;
        pinNumber &= 7;
        if (this.cpu == null || this.cpu.memory == null) {
            return 1;
        }
        Port port = this.cpu.memory.getPort(portNumber);
        return port.getPortPin(pinNumber);
    }

    public int readPortLatch(int portNumber, int pinNumber) {
        portNumber &= 3;
        pinNumber &= 7;
        if (this.cpu == null || this.cpu.memory == null) {
            return 1;
        }
        try {
            return this.cpu.memory.readPortLatch(portNumber, pinNumber);
        }
        catch (BitAddressAccessException bitAddressAccessException) {
            return -1;
        }
    }

    public int getInstructionCycles() {
        return this.cpu.getInstructionCycles();
    }

    public int getInstructionElapsedTime() {
        return this.cpu.getInstructionElapsedTime();
    }

    public long getInstructionElapsedTimeInNanos() {
        return this.cpu.getInstructionElapsedTimeInNanos();
    }

    public int getBatchElapsedTime() {
        return this.cpu.getBatchElapsedTime();
    }

    public long getProgramElapsedTime() {
        return this.cpu.getProgramElapsedTime();
    }

    public void setHardwareSetting(String id, String setting) {
        this.hardwareSettings.setHardWareSetting(id, setting);
    }

    public String getHardwareSetting(String id) {
        return this.hardwareSettings.getHardwareSetting(id);
    }

    public void reset() {
    }

    public abstract void updatePortPins();

    public abstract void updateTargetBoardGraphics();

    public abstract void setTargetBoardGraphicsSize(boolean var1);

    public HardwareSettings getCurrentHardwareSettings() {
        return this.hardwareSettings;
    }

    String getTitle() {
        return this.title;
    }

    JPanel getGui() {
        return this.gui;
    }

    String getVersion() {
        return this.version;
    }

    PortPinDescriptions getPortPinDescriptions() {
        return this.portPinDescriptions;
    }

    void setCpu(Cpu cpu) {
        this.cpu = cpu;
    }

    void setMainPanel(MainPanel mainPanel) {
        this.mainPanel = mainPanel;
    }

    void saveHardwareSettings() {
        this.hsrw.writeSettings();
    }
}

