/*
 * Decompiled with CFR 0.152.
 */
package edsim51di;

import edsim51di.Board;
import edsim51di.DACGraphics;
import edsim51di.Mapping;
import edsim51di.Peripheral;
import edsim51di.Scope;
import edsim51di.ScopeFrame;
import edsim51di.logicdiagram.LogicDiagramInterface;

class DAC
extends Peripheral {
    private double[] data = new double[]{1.0, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7};
    private double WR = 0.7;
    private int wrPort;
    private int wrPin;
    private DACGraphics dacGraphics;
    private ScopeFrame scopeFrame;
    private Board board;
    private boolean wr = true;
    private int voltage = 0;

    DAC(Board board) {
        super("Digital-to-analogue^Converter", false);
        this.board = board;
        double[] d = board.getPortMapSetting("dac_dbs");
        if (d != null) {
            this.data = d;
        }
        if ((d = board.getPortMapSetting("dac_wr")) != null) {
            this.WR = d[0];
        }
        this.scopeFrame = new ScopeFrame(board);
        this.dacGraphics = new DACGraphics(this.scopeFrame, board);
        this.initDataLineMappings(this.data, "DAC DB");
        this.wrPort = this.getPortNumber(this.WR);
        this.wrPin = this.getPinNumber(this.WR);
    }

    @Override
    public LogicDiagramInterface[] getLogicDiagramInterfaces() {
        LogicDiagramInterface[] interfaces = new LogicDiagramInterface[9];
        int start = 848;
        for (int i = 0; i < 8; ++i) {
            interfaces[i] = new LogicDiagramInterface();
            interfaces[i].peripheralPin = start;
            interfaces[i].portNumber = this.dataLineMappings[i].portNumber;
            interfaces[i].pinNumber = this.dataLineMappings[i].pinNumber;
            start -= 20;
        }
        interfaces[8] = new LogicDiagramInterface();
        interfaces[8].peripheralPin = 868;
        interfaces[8].portNumber = this.wrPort;
        interfaces[8].pinNumber = this.wrPin;
        return interfaces;
    }

    Mapping getWRMapping() {
        return new Mapping(this.wrPort, this.wrPin, "DAC WR");
    }

    DACGraphics getGraphics() {
        return this.dacGraphics;
    }

    int getOutputVoltage() {
        return this.voltage;
    }

    void cycle() {
        Scope scope = this.scopeFrame.getScope();
        boolean bl = this.wr = this.board.readPortPin(this.wrPort, this.wrPin) == 1;
        if (!this.wr) {
            this.voltage = 0;
            for (int i = 0; i < 8; ++i) {
                if (this.board.readPortPin(this.dataLineMappings[i].portNumber, this.dataLineMappings[i].pinNumber) != 1) continue;
                this.voltage += 1 << i;
            }
            scope.enableInputs();
            scope.latchData(this.voltage);
        } else {
            scope.disableInputs();
        }
        scope.incrementTime(this.board.getInstructionCycles());
        scope.setMicrosecondsPerDivision();
    }

    void refreshGraphics() {
        this.dacGraphics.setVoltage(this.voltage);
        if (this.scopeFrame.isVisible()) {
            this.scopeFrame.setVoltage(this.dacGraphics.getVoltageString());
            this.scopeFrame.getScope().repaint();
        }
    }
}

