/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.util.StringTokenizer;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.util.ForesterUtil;

public class Property
implements PhylogenyData {
    private String _value;
    private final String _ref;
    private final String _unit;
    private final String _datatype;
    private final AppliesTo _applies_to;
    private final String _id_ref;

    public Property(String string, String string2, String string3, String string4, AppliesTo appliesTo) {
        this(string, string2, string3, string4, appliesTo, "");
    }

    private Property(String string, String string2, String string3, String string4, AppliesTo appliesTo, boolean bl) {
        this._ref = string;
        this._unit = string3;
        this._datatype = string4;
        this._applies_to = appliesTo;
        this._id_ref = "";
        this.setValue(string2);
    }

    public Property(String string, String string2, String string3, String string4, AppliesTo appliesTo, String string5) {
        if (!ForesterUtil.isEmpty(string) && string.indexOf(":") < 1) {
            throw new IllegalArgumentException("property reference [" + string + "] is not in the expected format (missing a \":\")");
        }
        if (!ForesterUtil.isEmpty(string3) && string3.indexOf(":") < 1) {
            throw new IllegalArgumentException("property unit [" + string3 + "] is not in the expected format (missing a \":\")");
        }
        if (!ForesterUtil.isEmpty(string4) && string4.indexOf(":") < 1) {
            throw new IllegalArgumentException("property datatype [" + string3 + "] is not in the expected format (missing a \":\")");
        }
        this._ref = string;
        this._unit = string3;
        this._datatype = string4;
        this._applies_to = appliesTo;
        this._id_ref = string5;
        this.setValue(string2);
    }

    @Override
    public StringBuffer asSimpleText() {
        return new StringBuffer(this.getValue());
    }

    @Override
    public StringBuffer asText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getRef());
        stringBuffer.append(": ");
        stringBuffer.append(this.getValue());
        if (!ForesterUtil.isEmpty(this.getUnit())) {
            stringBuffer.append(" ");
            stringBuffer.append(this.getUnit());
        }
        return stringBuffer;
    }

    @Override
    public PhylogenyData copy() {
        return new Property(this.getRef(), this.getValue(), this.getUnit(), this.getDataType(), this.getAppliesTo(), this.getIdRef());
    }

    public AppliesTo getAppliesTo() {
        return this._applies_to;
    }

    public String getDataType() {
        return this._datatype;
    }

    public String getIdRef() {
        return this._id_ref;
    }

    public String getRef() {
        return this._ref;
    }

    public String getUnit() {
        return this._unit;
    }

    public String getValue() {
        return this._value;
    }

    @Override
    public boolean isEqual(PhylogenyData phylogenyData) {
        if (phylogenyData == null) {
            return false;
        }
        return ((Property)phylogenyData).getValue().equals(this.getValue()) && ((Property)phylogenyData).getUnit().equals(this.getUnit()) && ((Property)phylogenyData).getRef().equals(this.getRef());
    }

    public void setValue(String string) {
        this._value = string;
    }

    @Override
    public StringBuffer toNHX() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toPhyloXML(Writer writer, int n, String string) throws IOException {
        PhylogenyDataUtil.appendElement(writer, "property", this.getValue(), "ref", this.getRef(), "unit", this.getUnit(), "datatype", this.getDataType(), "applies_to", this.getAppliesTo().toString(), "id_ref", this.getIdRef(), string);
    }

    public String toString() {
        return this.asText().toString();
    }

    public static Property createFromNhxString(String string) throws IllegalArgumentException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        int n = stringTokenizer.countTokens();
        String string2 = "error in NHX property tag format: expected: X[N|B|C|S|T|P|O]=<datatype>=<ref>=<value>[=<unit>], got: \"" + string + "\" instead";
        if (n != 4 && n != 5) {
            throw new IllegalArgumentException(string2);
        }
        String string3 = stringTokenizer.nextToken();
        AppliesTo appliesTo = null;
        if (string3.equals("XN")) {
            appliesTo = AppliesTo.NODE;
        } else if (string3.equals("XB")) {
            appliesTo = AppliesTo.PARENT_BRANCH;
        } else if (string3.equals("XC")) {
            appliesTo = AppliesTo.CLADE;
        } else if (string3.equals("XS")) {
            appliesTo = AppliesTo.ANNOTATION;
        } else if (string3.equals("XT")) {
            appliesTo = AppliesTo.OTHER;
        } else if (string3.equals("XP")) {
            appliesTo = AppliesTo.PHYLOGENY;
        } else if (string3.equals("XO")) {
            appliesTo = AppliesTo.OTHER;
        } else {
            throw new IllegalArgumentException(string2);
        }
        String string4 = stringTokenizer.nextToken();
        if (string4.equals("S")) {
            string4 = "xsd:string";
        } else if (string4.equals("L")) {
            string4 = "xsd:long";
        } else if (string4.equals("D")) {
            string4 = "xsd:decimal";
        } else if (string4.equals("B")) {
            string4 = "xsd:boolean";
        } else if (string4.equals("U")) {
            string4 = "xsd:anyURI";
        }
        String string5 = stringTokenizer.nextToken();
        String string6 = stringTokenizer.nextToken();
        String string7 = "";
        if (n == 5) {
            string7 = stringTokenizer.nextToken();
        }
        return new Property(string5, string6, string7, string4, appliesTo, true);
    }

    public static enum AppliesTo {
        PHYLOGENY{

            public String toString() {
                return "phylogeny";
            }
        }
        ,
        CLADE{

            public String toString() {
                return "clade";
            }
        }
        ,
        NODE{

            public String toString() {
                return "node";
            }
        }
        ,
        ANNOTATION{

            public String toString() {
                return "annotation";
            }
        }
        ,
        PARENT_BRANCH{

            public String toString() {
                return "parent_branch";
            }
        }
        ,
        OTHER{

            public String toString() {
                return "other";
            }
        };

    }
}

