/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny;

import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.PhylogenyData;

public class PhylogenyBranch {
    private final PhylogenyNode _node_1;
    private final PhylogenyNode _node_2;
    private PhylogenyData _data;
    private final boolean _is_directed;
    private boolean _towards_1;

    public PhylogenyBranch(PhylogenyNode phylogenyNode, PhylogenyNode phylogenyNode2) {
        if (phylogenyNode == null || phylogenyNode2 == null) {
            throw new IllegalArgumentException("Attempt to create a branch with a null node");
        }
        this._node_1 = phylogenyNode;
        this._node_2 = phylogenyNode2;
        this._is_directed = false;
    }

    public PhylogenyBranch(PhylogenyNode phylogenyNode, PhylogenyNode phylogenyNode2, boolean bl) {
        if (phylogenyNode == null || phylogenyNode2 == null) {
            throw new IllegalArgumentException("Attempt to create a branch with a null node");
        }
        this._node_1 = phylogenyNode;
        this._node_2 = phylogenyNode2;
        this._is_directed = true;
        this._towards_1 = bl;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PhylogenyBranch phylogenyBranch = (PhylogenyBranch)object;
        return this.hashCode() == phylogenyBranch.hashCode();
    }

    public PhylogenyNode getConnectedNode(PhylogenyNode phylogenyNode) throws IllegalArgumentException {
        if (phylogenyNode == this._node_1) {
            return this._node_2;
        }
        if (phylogenyNode == this._node_2) {
            return this._node_1;
        }
        throw new IllegalArgumentException("Attempt to get connected node on branch with node which is not connected by the branch");
    }

    public PhylogenyData getData() {
        return this._data;
    }

    public PhylogenyNode getFirstNode() {
        return this._node_1;
    }

    public PhylogenyNode getSecondNode() {
        return this._node_2;
    }

    public int hashCode() {
        int n = 1;
        int n2 = this._node_1.hashCode();
        int n3 = this._node_2.hashCode();
        int n4 = 0;
        int n5 = 0;
        if (!this._is_directed) {
            if (n2 > n3) {
                n4 = n3;
                n5 = n2;
            } else {
                n4 = n2;
                n5 = n3;
            }
        } else if (this._towards_1) {
            n4 = n3;
            n5 = n2;
        } else {
            n4 = n2;
            n5 = n3;
        }
        n = 31 * n + (this._data == null ? 0 : this._data.hashCode());
        n = 31 * n + (this._is_directed ? 1231 : 1237);
        n = 31 * n + n4;
        n = 31 * n + n5;
        return n;
    }

    public boolean isDirected() {
        return this._is_directed;
    }

    public boolean isDirectionTowards(PhylogenyNode phylogenyNode) throws RuntimeException {
        if (!this.isDirected()) {
            throw new RuntimeException("Attempt to get direction of undirected branch");
        }
        return phylogenyNode == this._node_1 && this._towards_1;
    }

    public void setDirectionTowards(PhylogenyNode phylogenyNode) {
        this._towards_1 = phylogenyNode == this._node_1;
    }

    public String toString() {
        if (this.isDirected()) {
            if (this.isDirectionTowards(this.getFirstNode())) {
                return this.getSecondNode().getName() + " -> " + this.getFirstNode().getName();
            }
            return this.getFirstNode().getName() + " -> " + this.getSecondNode().getName();
        }
        return this.getFirstNode().getName() + " -- " + this.getSecondNode().getName();
    }
}

