/*
 * Decompiled with CFR 0.152.
 */
package org.forester.msa_compactor;

import org.forester.msa.Msa;
import org.forester.msa.MsaMethods;

public final class MsaProperties {
    private final double _entropy21;
    private final double _entropy7;
    private final double _gap_ratio;
    private final int _length;
    private final int _number_of_sequences;
    private final double _avg_number_of_gaps;
    private final String _removed_seq;

    public MsaProperties(int n, int n2, double d, double d2, double d3, double d4, String string) {
        this._number_of_sequences = n;
        this._length = n2;
        this._gap_ratio = d;
        this._entropy7 = d2;
        this._entropy21 = d3;
        this._avg_number_of_gaps = d4;
        this._removed_seq = string;
    }

    public MsaProperties(Msa msa, String string, boolean bl) {
        this._number_of_sequences = msa.getNumberOfSequences();
        this._length = msa.getLength();
        this._gap_ratio = MsaMethods.calcGapRatio(msa);
        this._removed_seq = string;
        this._avg_number_of_gaps = MsaMethods.calcNumberOfGapsStats(msa).arithmeticMean();
        if (bl) {
            this._entropy7 = MsaMethods.calcNormalizedShannonsEntropy(7, msa);
            this._entropy21 = MsaMethods.calcNormalizedShannonsEntropy(21, msa);
        } else {
            this._entropy7 = -1.0;
            this._entropy21 = -1.0;
        }
    }

    public final double getEntropy21() {
        return this._entropy21;
    }

    public final double getEntropy7() {
        return this._entropy7;
    }

    public final double getGapRatio() {
        return this._gap_ratio;
    }

    public final double getAvgNumberOfGaps() {
        return this._avg_number_of_gaps;
    }

    public final int getLength() {
        return this._length;
    }

    public final int getNumberOfSequences() {
        return this._number_of_sequences;
    }

    public final String getRemovedSeq() {
        return this._removed_seq;
    }
}

