/*
 * Decompiled with CFR 0.152.
 */
package org.forester.msa;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.forester.io.parsers.FastaParser;
import org.forester.io.writers.SequenceWriter;
import org.forester.msa.Msa;
import org.forester.msa.MsaInferrer;
import org.forester.sequence.MolecularSequence;
import org.forester.util.SystemCommandExecutor;

public final class Mafft
extends MsaInferrer {
    private static final String DEFAULT_PARAMETERS = "--maxiterate 1000 --localpair";
    private String _error;
    private int _exit_code;
    private final String _path_to_prg;

    public static MsaInferrer createInstance(String string) throws IOException {
        return new Mafft(string);
    }

    private Mafft(String string) throws IOException {
        if (!Mafft.isInstalled(string)) {
            throw new IOException("cannot execute MAFFT with \"" + string + "\"");
        }
        this._path_to_prg = new String(string);
        this.init();
    }

    public static String getDefaultParameters() {
        return DEFAULT_PARAMETERS;
    }

    @Override
    public String getErrorDescription() {
        return this._error;
    }

    @Override
    public int getExitCode() {
        return this._exit_code;
    }

    @Override
    public Msa infer(List<MolecularSequence> list, List<String> list2) throws IOException, InterruptedException {
        File file = File.createTempFile("__mafft_input_", ".fasta");
        file.deleteOnExit();
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        SequenceWriter.writeSeqs(list, bufferedWriter, SequenceWriter.SEQ_FORMAT.FASTA, 100);
        bufferedWriter.close();
        Msa msa = this.infer(file, list2);
        file.delete();
        return msa;
    }

    @Override
    public Msa infer(File file, List<String> list) throws IOException, InterruptedException {
        this.init();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this._path_to_prg);
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(list.get(i));
        }
        arrayList.add(file.getAbsolutePath());
        SystemCommandExecutor systemCommandExecutor = new SystemCommandExecutor(arrayList);
        int n = systemCommandExecutor.executeCommand();
        StringBuilder stringBuilder = systemCommandExecutor.getStandardErrorFromCommand();
        this._error = stringBuilder.toString();
        if (n != 0) {
            throw new IOException("MAFFT program failed, exit code: " + n + "\nCommand:\n" + arrayList + "\nError:\n" + stringBuilder);
        }
        StringBuilder stringBuilder2 = systemCommandExecutor.getStandardOutputFromCommand();
        if (stringBuilder2 == null || stringBuilder2.length() < 2) {
            throw new IOException("MAFFT program did not produce any output\nCommand:\n" + arrayList + "\nError:\n" + stringBuilder);
        }
        Msa msa = FastaParser.parseMsa(stringBuilder2.toString());
        return msa;
    }

    private void init() {
        this._error = null;
        this._exit_code = -100;
    }
}

