/*
 * Decompiled with CFR 0.152.
 */
package org.forester.go;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.forester.go.GoId;
import org.forester.go.GoNameSpace;
import org.forester.go.GoRelationship;
import org.forester.go.GoSubset;
import org.forester.go.GoTerm;
import org.forester.go.GoXRef;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.util.ForesterUtil;

public class BasicGoTerm
implements GoTerm {
    private final GoId _id;
    private final String _name;
    private final boolean _is_obsolete;
    private final GoNameSpace _namespace;
    private String _definition;
    private List<GoId> _alt_ids;
    private List<GoId> _super_go_ids;
    private List<GoXRef> _go_xrefs;
    private List<GoSubset> _go_subsets;
    private String _comment;
    private List<GoRelationship> _go_relationships;

    public BasicGoTerm(GoId goId, String string, GoNameSpace goNameSpace, boolean bl) {
        if (goId == null || ForesterUtil.isEmpty(string) || goNameSpace == null) {
            throw new IllegalArgumentException("attempt to create GO term with empty id, name, or namespace");
        }
        this._id = goId;
        this._name = string;
        this._namespace = goNameSpace;
        this._is_obsolete = bl;
        this.init();
    }

    public BasicGoTerm(String string, String string2, String string3, boolean bl) {
        if (ForesterUtil.isEmpty(string) || ForesterUtil.isEmpty(string2) || ForesterUtil.isEmpty(string3)) {
            throw new IllegalArgumentException("attempt to create GO term with empty id, name, or namespace");
        }
        this._id = new GoId(string);
        this._name = string2;
        this._namespace = new GoNameSpace(string3);
        this._is_obsolete = bl;
        this.init();
    }

    @Override
    public StringBuffer asSimpleText() {
        return new StringBuffer(this.getGoId().toString());
    }

    @Override
    public StringBuffer asText() {
        return new StringBuffer(this.toString());
    }

    @Override
    public int compareTo(GoTerm goTerm) {
        return this.getGoId().compareTo(goTerm.getGoId());
    }

    @Override
    public PhylogenyData copy() {
        BasicGoTerm basicGoTerm = new BasicGoTerm(this.getGoId(), this.getName(), this.getGoNameSpace(), this.isObsolete());
        basicGoTerm.setGoXrefs(this.getGoXRefs());
        basicGoTerm.setGoSubsets(this.getGoSubsets());
        basicGoTerm.setSuperTerms(this.getSuperGoIds());
        basicGoTerm.setAltIds(this.getAltIds());
        basicGoTerm.setDefinition(this.getDefinition());
        return basicGoTerm;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            throw new IllegalArgumentException("attempt to check go term equality to null");
        }
        if (object.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check go term equality to " + object + " [" + object.getClass() + "]");
        }
        GoTerm goTerm = (GoTerm)object;
        return this.getGoNameSpace().equals(goTerm.getGoNameSpace()) && this.getGoId().equals(goTerm.getGoId());
    }

    @Override
    public List<GoId> getAltIds() {
        return this._alt_ids;
    }

    @Override
    public String getComment() {
        return this._comment;
    }

    @Override
    public String getDefinition() {
        return this._definition;
    }

    @Override
    public GoId getGoId() {
        return this._id;
    }

    @Override
    public GoNameSpace getGoNameSpace() {
        return this._namespace;
    }

    @Override
    public List<GoRelationship> getGoRelationships() {
        return this._go_relationships;
    }

    @Override
    public List<GoSubset> getGoSubsets() {
        return this._go_subsets;
    }

    @Override
    public List<GoXRef> getGoXRefs() {
        return this._go_xrefs;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public List<GoId> getSuperGoIds() {
        return this._super_go_ids;
    }

    public int hashCode() {
        return this.getGoId().hashCode();
    }

    private void init() {
        this.setGoXrefs(new ArrayList<GoXRef>());
        this.setSuperTerms(new ArrayList<GoId>());
        this.setAltIds(new ArrayList<GoId>());
        this.setGoRelationships(new ArrayList<GoRelationship>());
        this.setGoSubsets(new ArrayList<GoSubset>());
        this.setDefinition("");
        this.setComment("");
    }

    @Override
    public boolean isEqual(PhylogenyData phylogenyData) {
        return this.equals(phylogenyData);
    }

    @Override
    public boolean isObsolete() {
        return this._is_obsolete;
    }

    private void setAltIds(List<GoId> list) {
        this._alt_ids = list;
    }

    public void setComment(String string) {
        this._comment = string;
    }

    public void setDefinition(String string) {
        this._definition = string;
    }

    private void setGoRelationships(List<GoRelationship> list) {
        this._go_relationships = list;
    }

    public void setGoSubsets(List<GoSubset> list) {
        this._go_subsets = list;
    }

    private void setGoXrefs(List<GoXRef> list) {
        this._go_xrefs = list;
    }

    private void setSuperTerms(List<GoId> list) {
        this._super_go_ids = list;
    }

    @Override
    public StringBuffer toNHX() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toPhyloXML(Writer writer, int n, String string) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getGoId());
        stringBuffer.append(": ");
        stringBuffer.append(this.getName());
        stringBuffer.append(" [");
        stringBuffer.append(this.getGoNameSpace());
        stringBuffer.append("]");
        if (this.isObsolete()) {
            stringBuffer.append(" [is obsolete]");
        }
        return stringBuffer.toString();
    }
}

