/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.render.colorscale;

import com.approximatrix.charting.render.colorscale.AbstractColorScale;
import java.awt.Color;

public class SimpleColorScale
extends AbstractColorScale {
    protected static final Color FAILED_CALC = Color.BLACK;
    private double minV = 0.0;
    private double maxV = 1.0;

    public SimpleColorScale() {
    }

    public SimpleColorScale(double min, double max) {
        this.minV = min;
        this.maxV = max;
    }

    public SimpleColorScale(int min, int max) {
        this((double)min, (double)max);
    }

    @Override
    public Color getColor(double value) {
        if (this.maxV - this.minV == 0.0) {
            return FAILED_CALC;
        }
        double multiple = (value - this.minV) / (this.maxV - this.minV);
        int r = Math.max(0, (int)(511.0 * (0.5 - multiple)));
        int b = Math.max(0, (int)(511.0 * (multiple - 0.5)));
        int g = (int)(511.0 * multiple - Math.max(0.0, 767.0 * (multiple - 0.5)));
        return new Color(Math.min(r, 255), Math.min(g, 255), Math.min(b, 255));
    }

    @Override
    public Color getColor(int value) {
        return this.getColor((double)value);
    }
}

