/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.render;

import com.approximatrix.charting.coordsystem.CoordSystem;
import com.approximatrix.charting.model.IntegratedImageModel;
import com.approximatrix.charting.render.AbstractChartRenderer;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;

public class ImageRenderer
extends AbstractChartRenderer {
    private AffineTransform last = null;
    private Image renderImage = null;
    private IntegratedImageModel dpmodel = null;
    private int scaleHints = 2;

    public ImageRenderer(CoordSystem cs, IntegratedImageModel model) {
        super(cs, model);
        this.coord = cs;
        this.model = model;
        this.dpmodel = model;
        this.renderImage = null;
    }

    @Override
    public boolean renderChart(Graphics2D g) {
        if (this.last != this.coord.getTransform(0) || this.renderImage == null) {
            try {
                this.renderImage = this.dpmodel.getViewableImage();
            }
            catch (NullPointerException npe) {
                System.err.println("Error in scaling/displaying image...");
                npe.printStackTrace();
                return false;
            }
        }
        Rectangle rect = this.coord.getInnerBounds();
        g.drawImage(this.renderImage.getScaledInstance(rect.width, rect.height, this.scaleHints), rect.x, rect.y, null);
        return true;
    }

    public void setScaleHint(int value) {
        this.scaleHints = value;
    }
}

