/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop;

import com.openstego.desktop.OpenStegoCmd;
import com.openstego.desktop.OpenStegoConfig;
import com.openstego.desktop.OpenStegoCrypto;
import com.openstego.desktop.OpenStegoException;
import com.openstego.desktop.OpenStegoPlugin;
import com.openstego.desktop.ui.OpenStegoUI;
import com.openstego.desktop.util.CommonUtil;
import com.openstego.desktop.util.LabelUtil;
import com.openstego.desktop.util.PluginManager;
import com.openstego.desktop.util.UserPreferences;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.UIManager;

public class OpenStego {
    public static final String NAMESPACE = "OpenStego";
    private OpenStegoConfig config = null;
    private OpenStegoPlugin plugin = null;

    public OpenStego(OpenStegoPlugin plugin) throws OpenStegoException {
        this(plugin, (OpenStegoConfig)null);
    }

    public OpenStego(OpenStegoPlugin plugin, OpenStegoConfig config) throws OpenStegoException {
        if (plugin == null) {
            throw new OpenStegoException(null, NAMESPACE, 9);
        }
        this.plugin = plugin;
        this.config = config == null ? new OpenStegoConfig() : config;
    }

    public OpenStego(OpenStegoPlugin plugin, Map<String, String> propMap) throws OpenStegoException {
        this(plugin, new OpenStegoConfig(propMap));
    }

    public byte[] embedData(byte[] msg, String msgFileName, byte[] cover, String coverFileName, String stegoFileName) throws OpenStegoException {
        if (!this.plugin.getPurposes().contains((Object)OpenStegoPlugin.Purpose.DATA_HIDING)) {
            throw new OpenStegoException(null, NAMESPACE, 14);
        }
        try {
            if (this.config.isUseCompression()) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                GZIPOutputStream zos = new GZIPOutputStream(bos);
                zos.write(msg);
                zos.finish();
                zos.close();
                bos.close();
                msg = bos.toByteArray();
            }
            if (this.config.isUseEncryption()) {
                OpenStegoCrypto crypto = new OpenStegoCrypto(this.config.getPassword(), this.config.getEncryptionAlgorithm());
                msg = crypto.encrypt(msg);
            }
            return this.plugin.embedData(msg, msgFileName, cover, coverFileName, stegoFileName);
        }
        catch (OpenStegoException osEx) {
            throw osEx;
        }
        catch (Exception ex) {
            throw new OpenStegoException(ex);
        }
    }

    public byte[] embedData(File msgFile, File coverFile, String stegoFileName) throws OpenStegoException {
        byte[] byArray;
        block10: {
            if (!this.plugin.getPurposes().contains((Object)OpenStegoPlugin.Purpose.DATA_HIDING)) {
                throw new OpenStegoException(null, NAMESPACE, 14);
            }
            String filename = null;
            InputStream is = msgFile == null ? System.in : new FileInputStream(msgFile);
            try {
                if (msgFile != null) {
                    filename = msgFile.getName();
                }
                byArray = this.embedData(CommonUtil.streamToBytes(is), filename, coverFile == null ? null : CommonUtil.fileToBytes(coverFile), coverFile == null ? null : coverFile.getName(), stegoFileName);
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioEx) {
                    throw new OpenStegoException(ioEx);
                }
            }
            is.close();
        }
        return byArray;
    }

    public byte[] embedMark(byte[] sig, String sigFileName, byte[] cover, String coverFileName, String stegoFileName) throws OpenStegoException {
        if (!this.plugin.getPurposes().contains((Object)OpenStegoPlugin.Purpose.WATERMARKING)) {
            throw new OpenStegoException(null, NAMESPACE, 10);
        }
        try {
            return this.plugin.embedData(sig, sigFileName, cover, coverFileName, stegoFileName);
        }
        catch (OpenStegoException osEx) {
            throw osEx;
        }
        catch (Exception ex) {
            throw new OpenStegoException(ex);
        }
    }

    public byte[] embedMark(File sigFile, File coverFile, String stegoFileName) throws OpenStegoException {
        byte[] byArray;
        block10: {
            if (!this.plugin.getPurposes().contains((Object)OpenStegoPlugin.Purpose.WATERMARKING)) {
                throw new OpenStegoException(null, NAMESPACE, 10);
            }
            String filename = null;
            InputStream is = sigFile == null ? System.in : new FileInputStream(sigFile);
            try {
                if (sigFile != null) {
                    filename = sigFile.getName();
                }
                byArray = this.embedMark(CommonUtil.streamToBytes(is), filename, coverFile == null ? null : CommonUtil.fileToBytes(coverFile), coverFile == null ? null : coverFile.getName(), stegoFileName);
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioEx) {
                    throw new OpenStegoException(ioEx);
                }
            }
            is.close();
        }
        return byArray;
    }

    public List<?> extractData(byte[] stegoData, String stegoFileName) throws OpenStegoException {
        if (!this.plugin.getPurposes().contains((Object)OpenStegoPlugin.Purpose.DATA_HIDING)) {
            throw new OpenStegoException(null, NAMESPACE, 14);
        }
        byte[] msg = null;
        ArrayList<Object> output = new ArrayList<Object>();
        try {
            output.add(this.plugin.extractMsgFileName(stegoData, stegoFileName));
            msg = this.plugin.extractData(stegoData, stegoFileName, null);
            if (this.config.isUseEncryption()) {
                OpenStegoCrypto crypto = new OpenStegoCrypto(this.config.getPassword(), this.config.getEncryptionAlgorithm());
                msg = crypto.decrypt(msg);
            }
            if (this.config.isUseCompression()) {
                try (ByteArrayInputStream bis = new ByteArrayInputStream(msg);
                     GZIPInputStream zis = new GZIPInputStream(bis);){
                    msg = CommonUtil.streamToBytes(zis);
                }
                catch (IOException ioEx) {
                    throw new OpenStegoException(ioEx, NAMESPACE, 5);
                }
            }
            output.add(msg);
        }
        catch (OpenStegoException osEx) {
            throw osEx;
        }
        catch (Exception ex) {
            throw new OpenStegoException(ex);
        }
        return output;
    }

    public List<?> extractData(File stegoFile) throws OpenStegoException {
        if (!this.plugin.getPurposes().contains((Object)OpenStegoPlugin.Purpose.DATA_HIDING)) {
            throw new OpenStegoException(null, NAMESPACE, 14);
        }
        return this.extractData(CommonUtil.fileToBytes(stegoFile), stegoFile.getName());
    }

    public byte[] extractMark(byte[] stegoData, String stegoFileName, byte[] origSigData) throws OpenStegoException {
        if (!this.plugin.getPurposes().contains((Object)OpenStegoPlugin.Purpose.WATERMARKING)) {
            throw new OpenStegoException(null, NAMESPACE, 10);
        }
        return this.plugin.extractData(stegoData, stegoFileName, origSigData);
    }

    public byte[] extractMark(File stegoFile, File origSigFile) throws OpenStegoException {
        if (!this.plugin.getPurposes().contains((Object)OpenStegoPlugin.Purpose.WATERMARKING)) {
            throw new OpenStegoException(null, NAMESPACE, 10);
        }
        return this.extractMark(CommonUtil.fileToBytes(stegoFile), stegoFile.getName(), CommonUtil.fileToBytes(origSigFile));
    }

    public double checkMark(byte[] stegoData, String stegoFileName, byte[] origSigData) throws OpenStegoException {
        if (!this.plugin.getPurposes().contains((Object)OpenStegoPlugin.Purpose.WATERMARKING)) {
            throw new OpenStegoException(null, NAMESPACE, 10);
        }
        return this.plugin.checkMark(stegoData, stegoFileName, origSigData);
    }

    public double checkMark(File stegoFile, File origSigFile) throws OpenStegoException {
        if (!this.plugin.getPurposes().contains((Object)OpenStegoPlugin.Purpose.WATERMARKING)) {
            throw new OpenStegoException(null, NAMESPACE, 10);
        }
        double correl = this.checkMark(CommonUtil.fileToBytes(stegoFile), stegoFile.getName(), CommonUtil.fileToBytes(origSigFile));
        if (Double.isNaN(correl)) {
            correl = 0.0;
        }
        return correl;
    }

    public byte[] generateSignature() throws OpenStegoException {
        if (!this.plugin.getPurposes().contains((Object)OpenStegoPlugin.Purpose.WATERMARKING)) {
            throw new OpenStegoException(null, NAMESPACE, 10);
        }
        if (this.config.getPassword() == null || this.config.getPassword().trim().length() == 0) {
            throw new OpenStegoException(null, NAMESPACE, 15);
        }
        return this.plugin.generateSignature();
    }

    public byte[] getDiff(byte[] stegoData, String stegoFileName, byte[] coverData, String coverFileName, String diffFileName) throws OpenStegoException {
        return this.plugin.getDiff(stegoData, stegoFileName, coverData, coverFileName, diffFileName);
    }

    public byte[] getDiff(File stegoFile, File coverFile, String diffFileName) throws OpenStegoException {
        return this.getDiff(CommonUtil.fileToBytes(stegoFile), stegoFile.getName(), CommonUtil.fileToBytes(coverFile), coverFile.getName(), diffFileName);
    }

    public OpenStegoConfig getConfig() {
        return this.config;
    }

    public static void main(String[] args) {
        block8: {
            try {
                PluginManager.loadPlugins();
                UserPreferences.init();
                if (args.length == 0) {
                    try {
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    new OpenStegoUI().setVisible(true);
                    break block8;
                }
                OpenStegoCmd.execute(args);
            }
            catch (OpenStegoException osEx) {
                if (osEx.getErrorCode() == 0) {
                    osEx.printStackTrace(System.err);
                } else {
                    System.err.println(osEx.getMessage());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        }
    }

    static {
        LabelUtil.addNamespace(NAMESPACE, "i18n.OpenStegoLabels");
    }
}

