/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.protocols;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.xmind.core.Core;
import org.xmind.core.IAdaptable;
import org.xmind.core.ITopic;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.util.FileUtils;
import org.xmind.gef.image.ImageExportUtils;
import org.xmind.ui.browser.BrowserSupport;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.browser.BrowserUtil;
import org.xmind.ui.io.WebImageManager;
import org.xmind.ui.mindmap.IHyperlinked;
import org.xmind.ui.mindmap.IProtocol;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.ImageUtils;
import org.xmind.ui.util.JobPool;
import org.xmind.ui.util.MindMapUtils;

public class WebProtocol
implements IProtocol {
    public static final String WEB_ICON_EVENT_TYPE = "webIcon";
    private static String DEFAULT_BROWSER_ID = "org.xmind.ui.defaultProtocol.browser";
    private static final String PATH_FAVICONS = "favicons/";
    private static JobPool jobPool = new JobPool();

    @Override
    public IAction createOpenHyperlinkAction(Object context, String url) {
        OpenURLAction action = new OpenURLAction(url);
        ImageDescriptor image = this.getWebIcon(url, new Callback((IAction)action, context){
            private final /* synthetic */ IAction val$action;
            private final /* synthetic */ Object val$context;
            {
                this.val$action = iAction;
                this.val$context = object;
            }

            @Override
            public void handleWith(final ImageDescriptor icon) {
                if (icon == null) {
                    return;
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ICoreEventSource source;
                        ImageDescriptor oldImage = val$action.getImageDescriptor();
                        val$action.setImageDescriptor(icon);
                        ITopic topic = null;
                        if (val$context instanceof ITopic) {
                            topic = (ITopic)val$context;
                        } else if (val$context instanceof IAdaptable) {
                            topic = (ITopic)((IAdaptable)val$context).getAdapter(ITopic.class);
                        }
                        if (topic != null && (source = (ICoreEventSource)topic.getAdapter(ICoreEventSource.class)) != null) {
                            source.getCoreEventSupport().dispatchValueChange(source, WebProtocol.WEB_ICON_EVENT_TYPE, (Object)oldImage, (Object)icon);
                        }
                    }
                });
            }
        });
        if (image != null) {
            action.setImageDescriptor(image);
        }
        return action;
    }

    private ImageDescriptor getWebIcon(String url, final Callback callback) {
        final String iconUrl = this.getWebIconUrl(url);
        if (iconUrl == null) {
            return null;
        }
        final String key = "org.xmind.ui.webIcon(" + iconUrl + ")";
        ImageDescriptor image = ImageUtils.getDescriptor((String)key);
        if (image != null) {
            return image;
        }
        image = this.getFaviconFromFile(iconUrl);
        if (image != null) {
            ImageUtils.putImageDescriptor((String)key, (ImageDescriptor)image);
            return image;
        }
        WebImageManager.getInstance().requestWebImage(iconUrl, jobPool, new WebImageManager.WebImageCallback(){

            public void handleWith(String imagePath) {
                if (imagePath == null || !new File(imagePath).exists()) {
                    return;
                }
                String newPath = WebProtocol.this.saveFaviconToFile(iconUrl, imagePath);
                if (newPath == null || !new File(newPath).exists()) {
                    return;
                }
                ImageDescriptor image = null;
                try {
                    image = ImageDescriptor.createFromURL((URL)new File(newPath).toURI().toURL());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                if (image == null) {
                    return;
                }
                ImageUtils.putImageDescriptor((String)key, (ImageDescriptor)image);
                if (callback != null) {
                    callback.handleWith(image);
                }
            }
        });
        return null;
    }

    private String getWebIconUrl(String url) {
        if (url == null) {
            return null;
        }
        int domainEnd = -1;
        if (url.contains("://")) {
            int start = url.indexOf("://") + "://".length();
            domainEnd = url.indexOf("/", start);
        } else {
            domainEnd = url.indexOf("/");
        }
        String domain = url.substring(0, domainEnd == -1 ? url.length() : domainEnd);
        return String.valueOf(domain) + "/favicon.ico";
    }

    private ImageDescriptor getFaviconFromFile(String key) {
        String fileName = this.getFileName(key);
        String path = Core.getWorkspace().getAbsolutePath(PATH_FAVICONS + fileName);
        if (path == null) {
            return null;
        }
        File file = new File(path);
        if (file.exists()) {
            long lastModified = file.lastModified();
            long currentTime = System.currentTimeMillis();
            if ((currentTime - lastModified) / 86400000L > 30L) {
                file.delete();
            } else {
                try {
                    return ImageDescriptor.createFromURL((URL)new File(path).toURI().toURL());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private String saveFaviconToFile(String key, String tempImagePath) {
        if (tempImagePath == null) {
            return null;
        }
        String fileName = this.getFileName(key);
        String path = Core.getWorkspace().getAbsolutePath(PATH_FAVICONS + fileName);
        if (path == null) {
            return null;
        }
        File file = new File(path);
        if (file.exists()) {
            return path;
        }
        Image image = null;
        try {
            image = new Image((Device)Display.getCurrent(), tempImagePath);
        }
        catch (Exception exception) {
            return null;
        }
        Image image1x = ImageUtils.createScaledImage((Image)image, (int)16, (int)16);
        Image image2x = ImageUtils.createScaledImage((Image)image, (int)32, (int)32);
        FileUtils.ensureFileParent((File)file);
        FileOutputStream outputStream = null;
        FileOutputStream outputStream2x = null;
        try {
            try {
                File file1x = new File(path);
                file1x.createNewFile();
                outputStream = new FileOutputStream(file1x);
                ImageExportUtils.saveImage((Image)image1x, (OutputStream)outputStream, (int)5);
                String path2x = Core.getWorkspace().getAbsolutePath(PATH_FAVICONS + this.get2xFileName(key));
                File file2x = new File(path2x);
                file2x.createNewFile();
                outputStream2x = new FileOutputStream(file2x);
                ImageExportUtils.saveImage((Image)image2x, (OutputStream)outputStream2x, (int)5);
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    outputStream.close();
                    outputStream2x.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                new File(tempImagePath).delete();
                image.dispose();
                image1x.dispose();
                image2x.dispose();
            }
        }
        finally {
            try {
                outputStream.close();
                outputStream2x.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            new File(tempImagePath).delete();
            image.dispose();
            image1x.dispose();
            image2x.dispose();
        }
        return path;
    }

    private String getFileName(String key) {
        if (key == null) {
            return null;
        }
        key = key.substring(0, key.lastIndexOf(".ico"));
        key = key.replace("://", "-");
        key = key.replace(".", "-");
        key = key.replace("/", "-");
        key = String.valueOf(key) + ".png";
        key = MindMapUtils.trimFileName(key);
        return key;
    }

    private String get2xFileName(String key) {
        String fileName = this.getFileName(key);
        if (fileName != null) {
            fileName = String.valueOf(fileName.substring(0, fileName.length() - 4)) + "@2x" + fileName.substring(fileName.length() - 4);
        }
        return fileName;
    }

    @Override
    public boolean isHyperlinkModifiable(Object source, String uri) {
        return true;
    }

    private static interface Callback {
        public void handleWith(ImageDescriptor var1);
    }

    private static class OpenURLAction
    extends Action
    implements IHyperlinked {
        private String url;

        public OpenURLAction(String url) {
            super(MindMapMessages.OpenHyperlink_text, MindMapUI.getImages().get("hyperlink.png", true));
            this.url = url;
            this.setDisabledImageDescriptor(MindMapUI.getImages().get("hyperlink.png", false));
            this.setToolTipText(url);
        }

        public void run() {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    String theURL = OpenURLAction.this.url;
                    try {
                        URI uri = new URI(theURL);
                        if ("www.xmind.net".equals(uri.getHost()) || "www.xmind.cn".equals(uri.getHost())) {
                            theURL = BrowserUtil.makeRedirectURL((String)theURL);
                        }
                    }
                    catch (Exception exception) {}
                    BrowserSupport.getInstance().createBrowser(DEFAULT_BROWSER_ID).openURL(theURL);
                }
            });
        }

        @Override
        public String getHyperlink() {
            return this.url;
        }
    }
}

