/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.print;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.draw2d.RotatableWrapLabel;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.util.UnitConvertor;

public class PrintUtils {
    public static int getHeaderHeight(IDialogSettings settings, int targetDpi) {
        String headerText = settings.get("headerText");
        Font headerFont = PrintUtils.getFont(settings, "headerFont", targetDpi);
        int headerHeight = PrintUtils.getHeight(headerText, headerFont);
        return headerHeight;
    }

    public static int getBottomHeight(IDialogSettings settings, int targetDpi) {
        int bottomHeight = Math.max(PrintUtils.getFooterHeight(settings, targetDpi), PrintUtils.getPageNumberHeight(settings, targetDpi));
        return bottomHeight;
    }

    private static int getFooterHeight(IDialogSettings settings, int targetDpi) {
        String footerText = settings.get("footerText");
        Font footerFont = PrintUtils.getFont(settings, "footerFont", targetDpi);
        return PrintUtils.getHeight(footerText, footerFont);
    }

    private static int getPageNumberHeight(IDialogSettings settings, int targetDpi) {
        boolean multiPages = settings.getBoolean("multiPages");
        if (!multiPages) {
            return 0;
        }
        String pageNumberText = "- 1 -";
        Font pageNumberFont = Display.getCurrent().getSystemFont();
        pageNumberFont = FontUtils.getNewHeight((Font)pageNumberFont, (int)(pageNumberFont.getFontData()[0].getHeight() * targetDpi / UnitConvertor.getScreenDpi().y));
        return PrintUtils.getHeight(pageNumberText, pageNumberFont);
    }

    private static Font getFont(IDialogSettings settings, String fontKey, int targetDpi) {
        FontData[] fontData;
        Font font = null;
        String fontValue = settings.get(fontKey);
        if (fontValue != null && (fontData = FontUtils.toFontData((String)fontValue)) != null) {
            FontData[] fontDataArray = fontData;
            int n = fontData.length;
            int n2 = 0;
            while (n2 < n) {
                FontData fd = fontDataArray[n2];
                fd.setHeight(fd.getHeight() * targetDpi / UnitConvertor.getScreenDpi().y);
                ++n2;
            }
            font = new Font((Device)Display.getCurrent(), fontData);
        }
        if (font == null) {
            FontData[] defaultFontData = JFaceResources.getDefaultFontDescriptor().getFontData();
            int defaultHeight = defaultFontData[0].getHeight();
            font = new Font((Device)Display.getCurrent(), FontUtils.newHeight((FontData[])defaultFontData, (int)(defaultHeight * targetDpi / UnitConvertor.getScreenDpi().y)));
        }
        return font;
    }

    private static int getHeight(String text, Font font) {
        RotatableWrapLabel label = new RotatableWrapLabel();
        label.setText(text);
        label.setFont(font);
        return text == null || text.equals("") ? 0 : label.getPreferredSize().height;
    }
}

