/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.editor.IPasswordProvider;
import org.xmind.ui.mindmap.IWorkbookRef;

public class PasswordProvider
implements IPasswordProvider {
    @Override
    public String askForPassword(IWorkbookRef workbookRef, String message) {
        final String[] password = new String[]{null};
        final String theMessage = message != null ? message : (workbookRef != null ? NLS.bind((String)MindMapMessages.PasswordProvider_askPassword_message, (Object)workbookRef.getName()) : MindMapMessages.EncryteDialog_label_message);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                PasswordDialog dialog = new PasswordDialog(null, theMessage);
                int ret = dialog.open();
                if (ret == 0) {
                    password[0] = dialog.getValue();
                }
            }
        });
        return password[0];
    }

    private static class PasswordDialog
    extends Dialog {
        private String value;
        private String message;

        protected PasswordDialog(Shell parentShell, String message) {
            super(parentShell);
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.value = null;
            this.message = message;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(MindMapMessages.EncryptDialog_title);
        }

        protected Point getInitialSize() {
            return new Point(300, 200);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Label messageLabel = new Label(composite, 64);
            messageLabel.setText(this.message);
            messageLabel.setLayoutData((Object)new GridData(4, 4, true, false));
            final Text passwordInput = new Text(composite, 0x400804);
            passwordInput.setLayoutData((Object)new GridData(4, 4, true, false));
            passwordInput.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    PasswordDialog.this.value = passwordInput.getText();
                }
            });
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    passwordInput.setFocus();
                }
            });
            return composite;
        }

        public String getValue() {
            return this.value;
        }
    }
}

