/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.DividendServer;
import org.yccheok.jstock.engine.Duration;
import org.yccheok.jstock.engine.Period;
import org.yccheok.jstock.engine.StockHistoryNotFoundException;
import org.yccheok.jstock.engine.StockHistoryServer;
import org.yccheok.jstock.engine.StockServer;
import org.yccheok.jstock.engine.StockServerFactory;
import org.yccheok.jstock.engine.YahooStockHistoryServer2;
import org.yccheok.jstock.engine.YahooStockServer;

public class YahooStockServerFactory
implements StockServerFactory {
    private final StockServer stockServer = new YahooStockServer();
    private static final Log log = LogFactory.getLog(YahooStockServerFactory.class);

    @Override
    public char getId() {
        return 'd';
    }

    private YahooStockServerFactory() {
    }

    public static StockServerFactory newInstance() {
        return new YahooStockServerFactory();
    }

    @Override
    public StockServer getStockServer() {
        return this.stockServer;
    }

    @Override
    public StockHistoryServer getStockHistoryServer(Code code) {
        try {
            return new YahooStockHistoryServer2(code);
        }
        catch (StockHistoryNotFoundException exp) {
            log.error(null, (Throwable)exp);
            return null;
        }
    }

    @Override
    public StockHistoryServer getStockHistoryServer(Code code, Duration duration) {
        try {
            return new YahooStockHistoryServer2(code, duration);
        }
        catch (StockHistoryNotFoundException exp) {
            log.error(null, (Throwable)exp);
            return null;
        }
    }

    @Override
    public StockHistoryServer getStockHistoryServer(Code code, Period period) {
        try {
            return new YahooStockHistoryServer2(code, period);
        }
        catch (StockHistoryNotFoundException exp) {
            log.error(null, (Throwable)exp);
            return null;
        }
    }

    @Override
    public DividendServer getDividendServer() {
        return null;
    }
}

