/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.DividendServer;
import org.yccheok.jstock.engine.IEXApi;
import org.yccheok.jstock.engine.SimpleDate;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockInfo;
import org.yccheok.jstock.engine.Utils;
import org.yccheok.jstock.engine.iex.dividends.DividendsResponse;
import org.yccheok.jstock.portfolio.Dividend;
import retrofit2.Call;

public class IEXDividendServer
implements DividendServer {
    private static final Log log = LogFactory.getLog(IEXDividendServer.class);

    @Override
    public List<Dividend> getDividends(Code code) {
        ArrayList<Dividend> dividends = new ArrayList<Dividend>();
        IEXApi api = Utils.getIEXApi();
        Call<List<DividendsResponse>> call = api.dividends(Utils.toIEXFormat(code), Utils.getIEXToken());
        try {
            List dividendsResponses = (List)call.execute().body();
            StockInfo stockInfo = null;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
            for (DividendsResponse dividendsResponse : dividendsResponses) {
                double amount = dividendsResponse.getAmount();
                if (amount <= 0.0) continue;
                if (stockInfo == null) {
                    Stock stock = Utils.getStock(code);
                    stockInfo = StockInfo.newInstance(stock);
                }
                Date date = simpleDateFormat.parse(dividendsResponse.getPaymentDate());
                SimpleDate simpleDate = new SimpleDate(date);
                Dividend dividend = new Dividend(stockInfo, amount, simpleDate);
                dividends.add(dividend);
            }
        }
        catch (Exception e) {
            log.error(null, (Throwable)e);
        }
        return dividends;
    }
}

