/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.odg;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ODGConstants {
    public static final String OFFICE_NAMESPACE = "urn:oasis:names:tc:opendocument:xmlns:office:1.0";
    public static final String DRAWING_NAMESPACE = "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0";
    public static final String SVG_NAMESPACE = "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0";
    public static final String STYLE_NAMESPACE = "urn:oasis:names:tc:opendocument:xmlns:style:1.0";
    public static final String TEXT_NAMESPACE = "urn:oasis:names:tc:opendocument:xmlns:text:1.0";
    public static final Map<String, StrokeStyle> STROKE_STYLES;
    public static final Map<String, FillStyle> FILL_STYLES;

    private ODGConstants() {
    }

    static {
        HashMap<String, Enum> m = new HashMap<String, Enum>();
        m.put("none", StrokeStyle.NONE);
        m.put("dash", StrokeStyle.DASH);
        m.put("solid", StrokeStyle.SOLID);
        STROKE_STYLES = Collections.unmodifiableMap(m);
        m = new HashMap();
        m.put("none", FillStyle.NONE);
        m.put("solid", FillStyle.SOLID);
        m.put("bitmap", FillStyle.BITMAP);
        m.put("gradient", FillStyle.GRADIENT);
        m.put("hatch", FillStyle.HATCH);
        FILL_STYLES = Collections.unmodifiableMap(m);
    }

    public static enum FillStyle {
        NONE,
        SOLID,
        BITMAP,
        GRADIENT,
        HATCH;

    }

    public static enum StrokeStyle {
        NONE,
        DASH,
        SOLID;

    }
}

