/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest.tunnel;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleResourceNotFoundException;
import org.apache.guacamole.net.auth.ActiveConnection;
import org.apache.guacamole.net.auth.Identifiable;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.rest.activeconnection.APIActiveConnection;
import org.apache.guacamole.rest.directory.DirectoryObjectResource;
import org.apache.guacamole.rest.directory.DirectoryObjectResourceFactory;
import org.apache.guacamole.rest.tunnel.StreamResource;
import org.apache.guacamole.tunnel.StreamInterceptingTunnel;
import org.apache.guacamole.tunnel.UserTunnel;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class TunnelResource {
    private static final String DEFAULT_MEDIA_TYPE = "application/octet-stream";
    private final UserTunnel tunnel;
    @Inject
    private DirectoryObjectResourceFactory<ActiveConnection, APIActiveConnection> activeConnectionResourceFactory;

    @AssistedInject
    public TunnelResource(@Assisted UserTunnel tunnel) {
        this.tunnel = tunnel;
    }

    @Path(value="activeConnection")
    public DirectoryObjectResource<ActiveConnection, APIActiveConnection> getActiveConnection() throws GuacamoleException {
        UserContext userContext = this.tunnel.getUserContext();
        ActiveConnection activeConnection = this.tunnel.getActiveConnection();
        if (activeConnection == null) {
            throw new GuacamoleResourceNotFoundException("No readable active connection for tunnel.");
        }
        return this.activeConnectionResourceFactory.create(userContext, userContext.getActiveConnectionDirectory(), (Identifiable)activeConnection);
    }

    @Path(value="streams/{index}/{filename}")
    public StreamResource getStream(@PathParam(value="index") int streamIndex, @QueryParam(value="type") @DefaultValue(value="application/octet-stream") String mediaType, @PathParam(value="filename") String filename) throws GuacamoleException {
        return new StreamResource((StreamInterceptingTunnel)this.tunnel, streamIndex, mediaType);
    }
}

