/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.resource;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.guacamole.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(ResourceServlet.class);
    private static final int BUFFER_SIZE = 10240;
    private final Resource resource;

    public ResourceServlet(Resource resource) {
        this.resource = resource;
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.addDateHeader("Last-Modified", this.resource.getLastModified());
        response.setContentType(this.resource.getMimeType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        InputStream input = this.resource.asStream();
        if (input == null) {
            logger.debug("Resource does not exist: \"{}\"", (Object)request.getServletPath());
            response.setStatus(404);
            return;
        }
        try {
            int length;
            this.doHead(request, response);
            long ifModifiedSince = request.getDateHeader("If-Modified-Since");
            if (this.resource.getLastModified() - ifModifiedSince < 1000L) {
                logger.debug("Resource not modified: \"{}\"", (Object)request.getServletPath());
                response.setStatus(304);
                return;
            }
            byte[] buffer = new byte[10240];
            ServletOutputStream output = response.getOutputStream();
            while ((length = input.read(buffer)) != -1) {
                output.write(buffer, 0, length);
            }
        }
        finally {
            input.close();
        }
    }
}

