/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec;

import java.net.SocketAddress;
import java.util.Queue;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.file.FileRegion;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.session.AttributeKey;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.DefaultWriteRequest;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.core.write.WriteRequestWrapper;
import org.apache.mina.filter.codec.AbstractProtocolDecoderOutput;
import org.apache.mina.filter.codec.AbstractProtocolEncoderOutput;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderException;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderException;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.apache.mina.filter.codec.RecoverableProtocolDecoderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolCodecFilter
extends IoFilterAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtocolCodecFilter.class);
    private static final Class<?>[] EMPTY_PARAMS = new Class[0];
    private static final IoBuffer EMPTY_BUFFER = IoBuffer.wrap(new byte[0]);
    private final AttributeKey ENCODER = new AttributeKey(ProtocolCodecFilter.class, "encoder");
    private final AttributeKey DECODER = new AttributeKey(ProtocolCodecFilter.class, "decoder");
    private final AttributeKey DECODER_OUT = new AttributeKey(ProtocolCodecFilter.class, "decoderOut");
    private final AttributeKey ENCODER_OUT = new AttributeKey(ProtocolCodecFilter.class, "encoderOut");
    private final ProtocolCodecFactory factory;

    public ProtocolCodecFilter(ProtocolCodecFactory protocolCodecFactory) {
        if (protocolCodecFactory == null) {
            throw new IllegalArgumentException("factory");
        }
        this.factory = protocolCodecFactory;
    }

    public void onPreAdd(IoFilterChain ioFilterChain, String string, IoFilter.NextFilter nextFilter) throws Exception {
        if (ioFilterChain.contains(this)) {
            throw new IllegalArgumentException("You can't add the same filter instance more than once.  Create another instance and add it.");
        }
    }

    public void onPostRemove(IoFilterChain ioFilterChain, String string, IoFilter.NextFilter nextFilter) throws Exception {
        this.disposeCodec(ioFilterChain.getSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession ioSession, Object object) throws Exception {
        LOGGER.debug("Processing a MESSAGE_RECEIVED for session {}", (Object)ioSession.getId());
        if (!(object instanceof IoBuffer)) {
            nextFilter.messageReceived(ioSession, object);
            return;
        }
        IoBuffer ioBuffer = (IoBuffer)object;
        ProtocolDecoder protocolDecoder = this.factory.getDecoder(ioSession);
        ProtocolDecoderOutput protocolDecoderOutput = this.getDecoderOut(ioSession, nextFilter);
        while (ioBuffer.hasRemaining()) {
            int n = ioBuffer.position();
            try {
                ProtocolDecoderOutput protocolDecoderOutput2 = protocolDecoderOutput;
                synchronized (protocolDecoderOutput2) {
                    protocolDecoder.decode(ioSession, ioBuffer, protocolDecoderOutput);
                }
                protocolDecoderOutput.flush(nextFilter, ioSession);
            }
            catch (Throwable throwable) {
                ProtocolDecoderException protocolDecoderException = throwable instanceof ProtocolDecoderException ? (ProtocolDecoderException)throwable : new ProtocolDecoderException(throwable);
                if (protocolDecoderException.getHexdump() == null) {
                    int n2 = ioBuffer.position();
                    ioBuffer.position(n);
                    protocolDecoderException.setHexdump(ioBuffer.getHexDump());
                    ioBuffer.position(n2);
                }
                protocolDecoderOutput.flush(nextFilter, ioSession);
                nextFilter.exceptionCaught(ioSession, protocolDecoderException);
                if (throwable instanceof RecoverableProtocolDecoderException && ioBuffer.position() != n) continue;
                break;
            }
        }
    }

    public void messageSent(IoFilter.NextFilter nextFilter, IoSession ioSession, WriteRequest writeRequest) throws Exception {
        if (writeRequest instanceof EncodedWriteRequest) {
            return;
        }
        if (writeRequest instanceof MessageWriteRequest) {
            MessageWriteRequest messageWriteRequest = (MessageWriteRequest)writeRequest;
            nextFilter.messageSent(ioSession, messageWriteRequest.getParentRequest());
        } else {
            nextFilter.messageSent(ioSession, writeRequest);
        }
    }

    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession ioSession, WriteRequest writeRequest) throws Exception {
        Object object = writeRequest.getMessage();
        if (object instanceof IoBuffer || object instanceof FileRegion) {
            nextFilter.filterWrite(ioSession, writeRequest);
            return;
        }
        ProtocolEncoder protocolEncoder = this.factory.getEncoder(ioSession);
        ProtocolEncoderOutput protocolEncoderOutput = this.getEncoderOut(ioSession, nextFilter, writeRequest);
        if (protocolEncoder == null) {
            throw new ProtocolEncoderException("The encoder is null for the session " + ioSession);
        }
        if (protocolEncoderOutput == null) {
            throw new ProtocolEncoderException("The encoderOut is null for the session " + ioSession);
        }
        try {
            Object object2;
            protocolEncoder.encode(ioSession, object, protocolEncoderOutput);
            Queue<Object> queue = ((AbstractProtocolEncoderOutput)protocolEncoderOutput).getMessageQueue();
            while (!queue.isEmpty() && (object2 = queue.poll()) != null) {
                if (object2 instanceof IoBuffer && !((IoBuffer)object2).hasRemaining()) continue;
                SocketAddress socketAddress = writeRequest.getDestination();
                EncodedWriteRequest encodedWriteRequest = new EncodedWriteRequest(object2, null, socketAddress);
                nextFilter.filterWrite(ioSession, encodedWriteRequest);
            }
            nextFilter.filterWrite(ioSession, new MessageWriteRequest(writeRequest));
        }
        catch (Throwable throwable) {
            ProtocolEncoderException protocolEncoderException = throwable instanceof ProtocolEncoderException ? (ProtocolEncoderException)throwable : new ProtocolEncoderException(throwable);
            throw protocolEncoderException;
        }
    }

    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession ioSession) throws Exception {
        ProtocolDecoder protocolDecoder = this.factory.getDecoder(ioSession);
        ProtocolDecoderOutput protocolDecoderOutput = this.getDecoderOut(ioSession, nextFilter);
        try {
            protocolDecoder.finishDecode(ioSession, protocolDecoderOutput);
        }
        catch (Throwable throwable) {
            ProtocolDecoderException protocolDecoderException = throwable instanceof ProtocolDecoderException ? (ProtocolDecoderException)throwable : new ProtocolDecoderException(throwable);
            throw protocolDecoderException;
        }
        finally {
            this.disposeCodec(ioSession);
            protocolDecoderOutput.flush(nextFilter, ioSession);
        }
        nextFilter.sessionClosed(ioSession);
    }

    private void disposeCodec(IoSession ioSession) {
        this.disposeEncoder(ioSession);
        this.disposeDecoder(ioSession);
        this.disposeDecoderOut(ioSession);
    }

    private void disposeEncoder(IoSession ioSession) {
        ProtocolEncoder protocolEncoder = (ProtocolEncoder)ioSession.removeAttribute(this.ENCODER);
        if (protocolEncoder == null) {
            return;
        }
        try {
            protocolEncoder.dispose(ioSession);
        }
        catch (Throwable throwable) {
            LOGGER.warn("Failed to dispose: " + protocolEncoder.getClass().getName() + " (" + protocolEncoder + ')');
        }
    }

    private void disposeDecoder(IoSession ioSession) {
        ProtocolDecoder protocolDecoder = (ProtocolDecoder)ioSession.removeAttribute(this.DECODER);
        if (protocolDecoder == null) {
            return;
        }
        try {
            protocolDecoder.dispose(ioSession);
        }
        catch (Throwable throwable) {
            LOGGER.warn("Failed to dispose: " + protocolDecoder.getClass().getName() + " (" + protocolDecoder + ')');
        }
    }

    private ProtocolDecoderOutput getDecoderOut(IoSession ioSession, IoFilter.NextFilter nextFilter) {
        ProtocolDecoderOutput protocolDecoderOutput = (ProtocolDecoderOutput)ioSession.getAttribute(this.DECODER_OUT);
        if (protocolDecoderOutput == null) {
            protocolDecoderOutput = new ProtocolDecoderOutputImpl();
            ioSession.setAttribute(this.DECODER_OUT, protocolDecoderOutput);
        }
        return protocolDecoderOutput;
    }

    private ProtocolEncoderOutput getEncoderOut(IoSession ioSession, IoFilter.NextFilter nextFilter, WriteRequest writeRequest) {
        ProtocolEncoderOutput protocolEncoderOutput = (ProtocolEncoderOutput)ioSession.getAttribute(this.ENCODER_OUT);
        if (protocolEncoderOutput == null) {
            protocolEncoderOutput = new ProtocolEncoderOutputImpl(ioSession, nextFilter, writeRequest);
            ioSession.setAttribute(this.ENCODER_OUT, protocolEncoderOutput);
        }
        return protocolEncoderOutput;
    }

    private void disposeDecoderOut(IoSession ioSession) {
        ioSession.removeAttribute(this.DECODER_OUT);
    }

    private static class ProtocolEncoderOutputImpl
    extends AbstractProtocolEncoderOutput {
        private final IoSession session;
        private final IoFilter.NextFilter nextFilter;
        private final WriteRequest writeRequest;

        public ProtocolEncoderOutputImpl(IoSession ioSession, IoFilter.NextFilter nextFilter, WriteRequest writeRequest) {
            this.session = ioSession;
            this.nextFilter = nextFilter;
            this.writeRequest = writeRequest;
        }
    }

    private static class ProtocolDecoderOutputImpl
    extends AbstractProtocolDecoderOutput {
        public void flush(IoFilter.NextFilter nextFilter, IoSession ioSession) {
            Queue<Object> queue = this.getMessageQueue();
            while (!queue.isEmpty()) {
                nextFilter.messageReceived(ioSession, queue.poll());
            }
        }
    }

    private static class MessageWriteRequest
    extends WriteRequestWrapper {
        public MessageWriteRequest(WriteRequest writeRequest) {
            super(writeRequest);
        }

        public Object getMessage() {
            return EMPTY_BUFFER;
        }

        public String toString() {
            return "MessageWriteRequest, parent : " + super.toString();
        }
    }

    private static class EncodedWriteRequest
    extends DefaultWriteRequest {
        public EncodedWriteRequest(Object object, WriteFuture writeFuture, SocketAddress socketAddress) {
            super(object, writeFuture, socketAddress);
        }

        public boolean isEncoded() {
            return true;
        }
    }
}

