/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle.gui;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import net.sf.portecle.gui.DocumentMaxLengthFilter;

public class IntegerDocumentFilter
extends DocumentMaxLengthFilter {
    public IntegerDocumentFilter(int n) {
        super(n);
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
        boolean bl;
        if (string == null || string.isEmpty()) {
            super.insertString(filterBypass, n, string, attributeSet);
            return;
        }
        try {
            bl = Integer.parseInt(string) >= 0;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        if (!bl) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        super.insertString(filterBypass, n, string, attributeSet);
    }

    @Override
    public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
        boolean bl;
        if (string == null || string.isEmpty()) {
            super.replace(filterBypass, n, n2, string, attributeSet);
            return;
        }
        try {
            bl = Integer.parseInt(string) >= 0;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        if (!bl) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        super.replace(filterBypass, n, n2, string, attributeSet);
    }
}

