/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.smarttools.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.smarttools.SmarttoolsHelper;
import net.sourceforge.squirrel_sql.plugins.smarttools.comp.STButton;
import net.sourceforge.squirrel_sql.plugins.smarttools.gui.SmarttoolMissingIndicesFrame;

public class SmarttoolCreateIndexD
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 3733610935239923743L;
    private static final ILogger log = LoggerController.createLogger(SmarttoolMissingIndicesFrame.class);
    private static final StringManager stringManager = StringManagerFactory.getStringManager(SmarttoolMissingIndicesFrame.class);
    private String tablename = null;
    private ISession session = null;
    private Vector<String> vecColumns = new Vector();
    private Vector<String> vecSource = new Vector();
    private Vector<String> vecTarget = new Vector();
    private JLabel lblCreateType = new JLabel();
    private JRadioButton rbPrimaryKey = new JRadioButton();
    private ButtonGroup buttongroup1 = new ButtonGroup();
    private JRadioButton rbUniqueIndex = new JRadioButton();
    private JLabel lblTitleListSourceColumns = new JLabel();
    private JList listSourceColumns = new JList();
    private JLabel lblDdl = new JLabel();
    private JTextArea taDdl = new JTextArea();
    private STButton btnRemove = new STButton();
    private STButton btnAdd = new STButton();
    private STButton btnAddAll = new STButton();
    private STButton btnRemoveAll = new STButton();
    private JLabel lblIndexname = new JLabel();
    private JTextField tfName = new JTextField();
    private JLabel lblTitleListTargetColumns = new JLabel();
    private JList listTargetColumns = new JList();
    private STButton btnExecuteDdl = new STButton();

    public SmarttoolCreateIndexD(Frame owner, ISession session, String tablename) {
        super(owner, true);
        this.setTitle(i18n.TITLE + " " + tablename);
        this.session = session;
        this.tablename = tablename;
        this.initializePanel();
        this.setSize(700, 500);
        int x = (int)(this.getToolkit().getScreenSize().getWidth() - (double)this.getWidth()) / 2;
        int y = (int)(this.getToolkit().getScreenSize().getHeight() - (double)this.getHeight()) / 2;
        this.setLocation(x, y);
        this.setVisible(true);
    }

    public JPanel createPanel() {
        JPanel jpanel1 = new JPanel();
        FormLayout formlayout1 = new FormLayout("FILL:4DLU:NONE,FILL:DEFAULT:NONE,FILL:4DLU:NONE,FILL:DEFAULT:NONE,FILL:4DLU:NONE,FILL:DEFAULT:NONE,FILL:4DLU:GROW(0.6),FILL:4DLU:NONE,FILL:DEFAULT:NONE,FILL:4DLU:NONE,FILL:DEFAULT:NONE,FILL:4DLU:NONE,FILL:DEFAULT:GROW(1.0),FILL:4DLU:NONE,FILL:DEFAULT:NONE,FILL:4DLU:NONE", "CENTER:2DLU:NONE,CENTER:DEFAULT:NONE,CENTER:2DLU:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:2DLU:NONE,CENTER:DEFAULT:NONE,CENTER:2DLU:NONE,CENTER:DEFAULT:NONE,CENTER:2DLU:NONE,CENTER:DEFAULT:NONE,FILL:DEFAULT:GROW(1.0),CENTER:2DLU:NONE,CENTER:DEFAULT:NONE,CENTER:2DLU:NONE,FILL:DEFAULT:GROW(1.0),CENTER:2DLU:NONE");
        CellConstraints cc = new CellConstraints();
        jpanel1.setLayout((LayoutManager)formlayout1);
        this.lblCreateType.setName("lblCreateType");
        this.lblCreateType.setText("create");
        jpanel1.add((Component)this.lblCreateType, cc.xy(2, 2));
        this.rbPrimaryKey.setActionCommand("primary key");
        this.rbPrimaryKey.setName("rbPrimaryKey");
        this.rbPrimaryKey.setText("primary key");
        this.rbPrimaryKey.setToolTipText("create ddl statement for primary key");
        this.buttongroup1.add(this.rbPrimaryKey);
        jpanel1.add((Component)this.rbPrimaryKey, cc.xy(4, 2));
        this.rbUniqueIndex.setActionCommand("unique index");
        this.rbUniqueIndex.setName("rbUniqueIndex");
        this.rbUniqueIndex.setText("unique index");
        this.rbUniqueIndex.setToolTipText("create ddl statement for unique index");
        this.buttongroup1.add(this.rbUniqueIndex);
        jpanel1.add((Component)this.rbUniqueIndex, cc.xy(6, 2));
        this.lblTitleListSourceColumns.setName("lblTitleListSourceColumns");
        this.lblTitleListSourceColumns.setText("source columns:");
        jpanel1.add((Component)this.lblTitleListSourceColumns, cc.xywh(2, 4, 3, 1));
        this.listSourceColumns.setName("listSourceColumns");
        JScrollPane jscrollpane1 = new JScrollPane();
        jscrollpane1.setViewportView(this.listSourceColumns);
        jscrollpane1.setVerticalScrollBarPolicy(20);
        jscrollpane1.setHorizontalScrollBarPolicy(30);
        jpanel1.add((Component)jscrollpane1, cc.xywh(2, 5, 6, 8));
        this.lblDdl.setName("lblDdl");
        this.lblDdl.setText("DDL");
        jpanel1.add((Component)this.lblDdl, cc.xy(2, 14));
        this.taDdl.setName("taDdl");
        JScrollPane jscrollpane2 = new JScrollPane();
        jscrollpane2.setViewportView(this.taDdl);
        jscrollpane2.setVerticalScrollBarPolicy(20);
        jscrollpane2.setHorizontalScrollBarPolicy(30);
        jpanel1.add((Component)jscrollpane2, cc.xywh(2, 16, 14, 1));
        this.btnRemove.setActionCommand("<");
        this.btnRemove.setName("btnRemove");
        this.btnRemove.setText("<");
        this.btnRemove.setToolTipText("remove the selected target columns");
        jpanel1.add((Component)this.btnRemove, cc.xy(9, 11));
        this.btnAdd.setActionCommand(">");
        this.btnAdd.setName("btnAdd");
        this.btnAdd.setText(">");
        this.btnAdd.setToolTipText("add the selected source column to the target columns");
        jpanel1.add((Component)this.btnAdd, cc.xy(9, 5));
        this.btnAddAll.setActionCommand(">>");
        this.btnAddAll.setName("btnAddAll");
        this.btnAddAll.setText(">>");
        this.btnAddAll.setToolTipText("add all columns to the target columns");
        jpanel1.add((Component)this.btnAddAll, cc.xy(9, 7));
        this.btnRemoveAll.setActionCommand("<<");
        this.btnRemoveAll.setName("btnRemoveAll");
        this.btnRemoveAll.setText("<<");
        this.btnRemoveAll.setToolTipText("remove all target columns");
        jpanel1.add((Component)this.btnRemoveAll, cc.xy(9, 9));
        this.lblIndexname.setName("lblIndexname");
        this.lblIndexname.setText("index name");
        jpanel1.add((Component)this.lblIndexname, cc.xy(11, 2));
        this.tfName.setName("tfName");
        jpanel1.add((Component)this.tfName, cc.xywh(13, 2, 3, 1));
        this.lblTitleListTargetColumns.setName("lblTitleListTargetColumns");
        this.lblTitleListTargetColumns.setText("target columns:");
        jpanel1.add((Component)this.lblTitleListTargetColumns, cc.xywh(11, 4, 3, 1));
        this.listTargetColumns.setName("listTargetColumns");
        JScrollPane jscrollpane3 = new JScrollPane();
        jscrollpane3.setViewportView(this.listTargetColumns);
        jscrollpane3.setVerticalScrollBarPolicy(20);
        jscrollpane3.setHorizontalScrollBarPolicy(30);
        jpanel1.add((Component)jscrollpane3, cc.xywh(11, 5, 5, 8));
        this.btnExecuteDdl.setActionCommand("-> SQL");
        this.btnExecuteDdl.setName("btnExecuteDdl");
        this.btnExecuteDdl.setText("execute");
        this.btnExecuteDdl.setToolTipText("execute the created ddl statement");
        jpanel1.add((Component)this.btnExecuteDdl, cc.xy(15, 14));
        return jpanel1;
    }

    protected void initializePanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createPanel(), "Center");
        this.initLabels();
        this.rbPrimaryKey.addActionListener(this);
        this.rbUniqueIndex.addActionListener(this);
        this.rbUniqueIndex.setSelected(true);
        this.rbUniqueIndex.doClick();
        this.tfName.addActionListener(this);
        this.tfName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                SmarttoolCreateIndexD.this.createDdl();
            }
        });
        this.listSourceColumns.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    SmarttoolCreateIndexD.this.btnAdd.doClick();
                }
            }
        });
        this.listTargetColumns.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    SmarttoolCreateIndexD.this.btnRemove.doClick();
                }
            }
        });
        this.btnAdd.addActionListener(this);
        this.btnAddAll.addActionListener(this);
        this.btnRemove.addActionListener(this);
        this.btnRemoveAll.addActionListener(this);
        this.btnExecuteDdl.addActionListener(this);
        try {
            ITableInfo[] itableInfo = this.session.getMetaData().getTables(null, null, this.tablename, new String[]{"TABLE"}, null);
            if (itableInfo.length == 1) {
                TableColumnInfo[] tci = this.session.getMetaData().getColumnInfo(itableInfo[0]);
                for (int i = 0; i < tci.length; ++i) {
                    this.vecColumns.add(tci[i].getColumnName());
                }
                this.refreshVecSource();
                this.displayLists();
            }
        }
        catch (SQLException e) {
            log.error((Object)e);
            JOptionPane.showMessageDialog(null, i18n.ERROR_READ_COLUMNNAMES);
        }
    }

    private void initLabels() {
        this.lblCreateType.setText(i18n.LBL_CREATE_TYPE);
        this.rbPrimaryKey.setText(i18n.LBL_RB_PRIMARY_KEY);
        this.rbPrimaryKey.setToolTipText(i18n.TOOLTIP_RB_PRIMARY_KEY);
        this.rbUniqueIndex.setText(i18n.LBL_RB_UNIQUE_INDEX);
        this.rbUniqueIndex.setToolTipText(i18n.TOOLTIP_RB_UNIQUE_INDEX);
        this.lblIndexname.setText(i18n.LBL_INDEXNAME);
        this.lblTitleListSourceColumns.setText(i18n.LBL_LIST_SOURCE_COLUMNS);
        this.lblTitleListTargetColumns.setText(i18n.LBL_LIST_TARGET_COLUMNS);
        this.lblDdl.setText(i18n.LBL_DDL);
        this.btnRemove.setText("");
        this.btnRemove.setToolTipText(i18n.TOOLTIP_BTN_REMOVE);
        this.btnAdd.setText("");
        this.btnAdd.setToolTipText(i18n.TOOLTIP_BTN_ADD);
        this.btnAddAll.setText("");
        this.btnAddAll.setToolTipText(i18n.TOOLTIP_BTN_ADD_ALL);
        this.btnRemoveAll.setText("");
        this.btnRemoveAll.setToolTipText(i18n.TOOLTIP_BTN_REMOVE_ALL);
        this.btnExecuteDdl.setText(i18n.LBL_BTN_EXECUTE_DDL);
        this.btnExecuteDdl.setToolTipText(i18n.TOOLTIP_BTN_EXECUTE_DDL);
        this.btnAdd.setIcon(SmarttoolsHelper.loadIcon("add16x16.png"));
        this.btnAddAll.setIcon(SmarttoolsHelper.loadIcon("addAll16x16.png"));
        this.btnRemove.setIcon(SmarttoolsHelper.loadIcon("remove16x16.png"));
        this.btnRemoveAll.setIcon(SmarttoolsHelper.loadIcon("removeAll16x16.png"));
        this.btnExecuteDdl.setIcon(SmarttoolsHelper.loadIcon("change16x16.png"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.rbPrimaryKey || e.getSource() == this.rbUniqueIndex || e.getSource() == this.tfName || e.getSource() == this.btnAdd || e.getSource() == this.btnAddAll || e.getSource() == this.btnRemove || e.getSource() == this.btnRemoveAll || e.getSource() == this.btnExecuteDdl) {
            if (e.getSource() == this.rbPrimaryKey) {
                this.tfName.setText("PK_" + this.tablename + "_MAIN");
            } else if (e.getSource() == this.rbUniqueIndex) {
                this.tfName.setText(this.tablename + "_MAIN");
            } else if (e.getSource() == this.btnAdd) {
                this.addEntry();
            } else if (e.getSource() == this.btnAddAll) {
                this.addEntries();
            } else if (e.getSource() == this.btnRemove) {
                this.removeEntry();
            } else if (e.getSource() == this.btnRemoveAll) {
                this.removeEntries();
            } else if (e.getSource() == this.btnExecuteDdl) {
                this.executeDdl();
            }
            this.createDdl();
        }
    }

    private void addEntry() {
        int index = this.listSourceColumns.getSelectedIndex();
        if (index > -1) {
            this.vecTarget.add(this.vecSource.get(index));
            this.vecSource.remove(index);
            this.displayLists();
        }
    }

    private void addEntries() {
        for (int i = 0; i < this.vecSource.size(); ++i) {
            this.vecTarget.add(this.vecSource.get(i));
        }
        this.vecSource.removeAllElements();
        this.displayLists();
    }

    private void removeEntry() {
        int index = this.listTargetColumns.getSelectedIndex();
        if (index > -1) {
            this.vecTarget.remove(index);
            this.refreshVecSource();
            this.displayLists();
        }
    }

    private void removeEntries() {
        this.vecTarget.removeAllElements();
        this.refreshVecSource();
        this.displayLists();
    }

    private void refreshVecSource() {
        this.vecSource.removeAllElements();
        for (int col = 0; col < this.vecColumns.size(); ++col) {
            String column = this.vecColumns.get(col);
            boolean colFound = false;
            for (int target = 0; target < this.vecTarget.size(); ++target) {
                if (!this.vecTarget.get(target).equals(column)) continue;
                colFound = true;
                break;
            }
            if (colFound) continue;
            this.vecSource.add(column);
        }
    }

    private void displayLists() {
        this.listSourceColumns.setListData(this.vecSource);
        this.listTargetColumns.setListData(this.vecTarget);
        if (this.listSourceColumns.getModel().getSize() > 0) {
            this.listSourceColumns.setSelectedIndex(0);
        }
        if (this.listTargetColumns.getModel().getSize() > 0) {
            this.listTargetColumns.setSelectedIndex(0);
        }
        this.createDdl();
    }

    private void createDdl() {
        StringBuilder buf = new StringBuilder();
        if (this.rbPrimaryKey.isSelected()) {
            buf.append("ALTER TABLE ");
            buf.append(this.tablename);
            buf.append(" ADD CONSTRAINT ");
            buf.append(this.tfName.getText());
            buf.append(" PRIMARY KEY (");
        } else {
            buf.append("CREATE UNIQUE INDEX ");
            buf.append(this.tfName.getText());
            buf.append(" ON ");
            buf.append(this.tablename);
            buf.append(" (");
        }
        if (this.listTargetColumns.getModel().getSize() > 0) {
            for (int i = 0; i < this.listTargetColumns.getModel().getSize(); ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append((String)this.listTargetColumns.getModel().getElementAt(i));
            }
        }
        buf.append(")");
        buf.append(this.session.getQueryTokenizer().getSQLStatementSeparator());
        this.taDdl.setText(buf.toString());
    }

    private void executeDdl() {
        if (this.listTargetColumns.getModel().getSize() < 1) {
            JOptionPane.showMessageDialog(this, i18n.ERROR_NO_TARGET_COLUMNS_SELECTED);
            this.listSourceColumns.requestFocusInWindow();
        }
        if (this.tfName.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, i18n.ERROR_NO_INDEX_KEY_NAME);
            this.tfName.requestFocusInWindow();
        } else if (JOptionPane.showConfirmDialog(this, i18n.QUESTION_EXECUTE_DDL, "?", 0) == 0) {
            Statement stmt = null;
            try {
                stmt = this.session.getSQLConnection().createStatement();
                stmt.executeUpdate(this.taDdl.getText());
                JOptionPane.showMessageDialog(this, i18n.INFO_SUCCESS_EXECUTE);
            }
            catch (SQLException e) {
                try {
                    JOptionPane.showMessageDialog(this, i18n.ERROR_EXECUTE_DDL);
                    log.error((Object)e.getLocalizedMessage());
                }
                catch (Throwable throwable) {
                    SQLUtilities.closeStatement(stmt);
                    throw throwable;
                }
                SQLUtilities.closeStatement((Statement)stmt);
            }
            SQLUtilities.closeStatement((Statement)stmt);
        }
    }

    static /* synthetic */ StringManager access$300() {
        return stringManager;
    }

    private static interface i18n {
        public static final String TITLE = SmarttoolCreateIndexD.access$300().getString("createindex.title");
        public static final String LBL_CREATE_TYPE = SmarttoolCreateIndexD.access$300().getString("createindex.lbl.createtype");
        public static final String LBL_RB_PRIMARY_KEY = SmarttoolCreateIndexD.access$300().getString("createindex.lbl.rb.primarykey");
        public static final String LBL_RB_UNIQUE_INDEX = SmarttoolCreateIndexD.access$300().getString("createindex.lbl.rb.uniqueindex");
        public static final String LBL_INDEXNAME = SmarttoolCreateIndexD.access$300().getString("createindex.lbl.indexname");
        public static final String LBL_LIST_SOURCE_COLUMNS = SmarttoolCreateIndexD.access$300().getString("createindex.lbl.title.listsourcecolumns");
        public static final String LBL_LIST_TARGET_COLUMNS = SmarttoolCreateIndexD.access$300().getString("createindex.lbl.title.listtargetcolumns");
        public static final String LBL_DDL = SmarttoolCreateIndexD.access$300().getString("createindex.lbl.ddl");
        public static final String LBL_BTN_EXECUTE_DDL = SmarttoolCreateIndexD.access$300().getString("createindex.lbl.btn.executeddl");
        public static final String TOOLTIP_RB_PRIMARY_KEY = SmarttoolCreateIndexD.access$300().getString("createindex.tooltip.rb.primarykey");
        public static final String TOOLTIP_RB_UNIQUE_INDEX = SmarttoolCreateIndexD.access$300().getString("createindex.tooltip.rb.uniqueindex");
        public static final String TOOLTIP_BTN_REMOVE = SmarttoolCreateIndexD.access$300().getString("createindex.tooltip.btn.remove");
        public static final String TOOLTIP_BTN_ADD = SmarttoolCreateIndexD.access$300().getString("createindex.tooltip.btn.add");
        public static final String TOOLTIP_BTN_ADD_ALL = SmarttoolCreateIndexD.access$300().getString("createindex.tooltip.btn.addall");
        public static final String TOOLTIP_BTN_REMOVE_ALL = SmarttoolCreateIndexD.access$300().getString("createindex.tooltip.btn.removeall");
        public static final String TOOLTIP_BTN_EXECUTE_DDL = SmarttoolCreateIndexD.access$300().getString("createindex.tooltip.btn.executeddl");
        public static final String ERROR_READ_COLUMNNAMES = SmarttoolCreateIndexD.access$300().getString("createindex.error.read.columnnames");
        public static final String ERROR_NO_TARGET_COLUMNS_SELECTED = SmarttoolCreateIndexD.access$300().getString("createindex.error.no.targetcolumns.selected");
        public static final String ERROR_NO_INDEX_KEY_NAME = SmarttoolCreateIndexD.access$300().getString("createindex.error.no.index.key.name");
        public static final String ERROR_EXECUTE_DDL = SmarttoolCreateIndexD.access$300().getString("createindex.error.execute.ddl");
        public static final String QUESTION_EXECUTE_DDL = SmarttoolCreateIndexD.access$300().getString("createindex.question.execute.ddl");
        public static final String INFO_SUCCESS_EXECUTE = SmarttoolCreateIndexD.access$300().getString("createindex.info.success.execute");
    }
}

