/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTableModel;
import net.sourceforge.squirrel_sql.fw.gui.ColumnOrder;
import net.sourceforge.squirrel_sql.fw.gui.SortingListener;
import net.sourceforge.squirrel_sql.fw.gui.SquirrelTableCellValueCollator;

public class SortableTableModel
extends AbstractTableModel {
    private transient MyTableModelListener _actualModelLis = new MyTableModelListener();
    private int _sortedColumn = -1;
    private ColumnOrder _columnOrder = ColumnOrder.NATURAL;
    private TableModel _actualModel;
    private ArrayList<SortingListener> _sortingListeners = new ArrayList();
    private Integer[] _indexes = new Integer[0];

    public TableModel getActualModel() {
        return this._actualModel;
    }

    public SortableTableModel(TableModel model) {
        this.setActualModel(model);
    }

    public void setActualModel(TableModel newModel) {
        if (this._actualModel != null) {
            this._actualModel.removeTableModelListener(this._actualModelLis);
        }
        this._actualModel = newModel;
        if (this._actualModel != null) {
            this._actualModel.addTableModelListener(this._actualModelLis);
        }
        this.tableChangedIntern();
    }

    @Override
    public int getRowCount() {
        return this._actualModel != null ? this._actualModel.getRowCount() : 0;
    }

    @Override
    public int getColumnCount() {
        return this._actualModel != null ? this._actualModel.getColumnCount() : 0;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (-42 == col) {
            return row + 1;
        }
        if (row < this._indexes.length) {
            return this._actualModel.getValueAt(this._indexes[row], col);
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this._actualModel.setValueAt(value, this._indexes[row], col);
    }

    @Override
    public String getColumnName(int col) {
        return this._actualModel.getColumnName(col);
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return this._actualModel.getColumnClass(col);
    }

    public void deleteRows(int[] rows) {
        int[] actualRows = new int[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            if (rows[i] >= this._indexes.length) continue;
            actualRows[i] = this._indexes[rows[i]];
        }
        ((DataSetViewerTableModel)this._actualModel).deleteRows(actualRows);
    }

    public void insertRow(Object[] values) {
        ((DataSetViewerTableModel)this._actualModel).addRow(values);
        ((DataSetViewerTableModel)this._actualModel).fireTableChanged(new TableModelEvent(this._actualModel));
        this.fireTableChanged(new TableModelEvent(this));
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return this._actualModel.isCellEditable(row, col);
    }

    public ColumnOrder sortByColumn(int column) {
        ColumnOrder newOrder = ColumnOrder.ASC;
        if (column == this._sortedColumn) {
            newOrder = this._columnOrder.next();
        }
        this.sortByColumn(column, newOrder);
        return newOrder;
    }

    public void sortByColumn(int column, ColumnOrder newOrder) {
        this._sortedColumn = column;
        this._columnOrder = newOrder;
        if (ColumnOrder.NATURAL != newOrder) {
            TableModelComparator comparator = new TableModelComparator(column, newOrder);
            Arrays.sort(this._indexes, comparator);
        } else {
            for (int i = 0; i < this._indexes.length; ++i) {
                this._indexes[i] = i;
            }
        }
        this.fireTableDataChanged();
        this.fireSortingListeners(column, this._columnOrder);
    }

    private void fireSortingListeners(int column, ColumnOrder columnOrder) {
        SortingListener[] listeners;
        for (SortingListener listener : listeners = this._sortingListeners.toArray(new SortingListener[this._sortingListeners.size()])) {
            listener.sortingDone(column, columnOrder);
        }
    }

    public ColumnOrder getColumnOrder() {
        return this._columnOrder;
    }

    public void tableChanged() {
        this.tableChangedIntern();
        if (-1 != this._sortedColumn) {
            this.sortByColumn(this._sortedColumn, this._columnOrder);
        } else {
            this.fireTableDataChanged();
        }
    }

    private void tableChangedIntern() {
        this._indexes = new Integer[this.getRowCount()];
        for (int i = 0; i < this._indexes.length; ++i) {
            this._indexes[i] = i;
        }
    }

    public int transformToModelRow(int viewRow) {
        if (0 > viewRow || viewRow >= this._indexes.length) {
            return -1;
        }
        return this._indexes[viewRow];
    }

    public int transformToViewRow(int modelRow) {
        Integer viewRowInteger = modelRow;
        for (int i = 0; i < this._indexes.length; ++i) {
            if (!viewRowInteger.equals(this._indexes[i])) continue;
            return i;
        }
        return -1;
    }

    public void removeSortingListener(SortingListener sortingListener) {
        this._sortingListeners.remove(sortingListener);
    }

    public void addSortingListener(SortingListener sortingListener) {
        this._sortingListeners.add(sortingListener);
    }

    public int getSortedColumn() {
        return this._sortedColumn;
    }

    protected class MyTableModelListener
    implements TableModelListener {
        protected MyTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent evt) {
            SortableTableModel.this.tableChangedIntern();
        }
    }

    class TableModelComparator
    implements Comparator<Integer> {
        private int _iColumn;
        private int _iAscending;
        private final SquirrelTableCellValueCollator _collator = new SquirrelTableCellValueCollator();
        private boolean _allDataIsString = true;

        public TableModelComparator(int iColumn, ColumnOrder compColumnOrder) {
            this._iColumn = iColumn;
            if (ColumnOrder.ASC == compColumnOrder) {
                this._iAscending = 1;
            } else if (ColumnOrder.DESC == compColumnOrder) {
                this._iAscending = -1;
            }
            int limit = SortableTableModel.this._actualModel.getRowCount();
            for (int i = 0; i < limit; ++i) {
                Object data = SortableTableModel.this._actualModel.getValueAt(i, this._iColumn);
                if (data instanceof String) continue;
                this._allDataIsString = false;
                break;
            }
        }

        @Override
        public int compare(Integer i1, Integer i2) {
            Object data1 = SortableTableModel.this._actualModel.getValueAt(i1, this._iColumn);
            Object data2 = SortableTableModel.this._actualModel.getValueAt(i2, this._iColumn);
            return this._collator.compareTableCellValues(data1, data2, this._iAscending, this._allDataIsString);
        }
    }
}

