/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.util.codereformat;

import java.util.ArrayList;
import net.sourceforge.squirrel_sql.client.util.codereformat.CommentSpec;
import net.sourceforge.squirrel_sql.client.util.codereformat.Piece;
import net.sourceforge.squirrel_sql.client.util.codereformat.PieceMarkerSpec;
import net.sourceforge.squirrel_sql.client.util.codereformat.StateOfPosition;
import net.sourceforge.squirrel_sql.client.util.codereformat.TopLevelPiecesIterator;

public class CodeReformatorKernel {
    private CommentSpec[] _commentSpecs;
    private PieceMarkerSpec[] _pieceSpecs;
    private boolean _lineBreakFor_AND_OR_in_FROM_clause;

    public CodeReformatorKernel(PieceMarkerSpec[] pieceSpecs, CommentSpec[] commentSpecs, boolean lineBreakFor_and_or_in_from_clause) {
        this._commentSpecs = commentSpecs;
        this._pieceSpecs = pieceSpecs;
        this._lineBreakFor_AND_OR_in_FROM_clause = lineBreakFor_and_or_in_from_clause;
    }

    public String[] toPieces(String in) {
        TopLevelPiecesIterator topLevelPiecesIterator = new TopLevelPiecesIterator(this._pieceSpecs, this.getStatesOfPosition(in), this._lineBreakFor_AND_OR_in_FROM_clause);
        ArrayList<String> ret = new ArrayList<String>();
        String upperIn = in.replaceAll("\u00df", "s");
        upperIn = upperIn.toUpperCase();
        int begin = 0;
        while (begin < in.length()) {
            Piece p = topLevelPiecesIterator.getNextToplevelPiece(begin, upperIn);
            if (null == p.spec) {
                ret.add(in.substring(begin).trim());
                begin = in.length();
                continue;
            }
            int type = p.spec.getType();
            switch (type) {
                case 0: {
                    if (begin < p.beginsAt && 0 < in.substring(begin, p.beginsAt).trim().length()) {
                        ret.add(in.substring(begin, p.beginsAt).trim());
                    }
                    int afterPieceMarker = p.beginsAt + p.spec.getLengthRightSpaced();
                    Piece nextP = topLevelPiecesIterator.getNextToplevelPiece(afterPieceMarker, upperIn);
                    if (null == nextP.spec) {
                        ret.add(in.substring(p.beginsAt).trim());
                        begin = in.length();
                        break;
                    }
                    if (1 == nextP.spec.getType()) {
                        if (nextP.beginsAt + nextP.spec.getLengthRightSpaced() < in.length()) {
                            ret.add(in.substring(p.beginsAt, nextP.beginsAt + nextP.spec.getLengthRightSpaced()).trim());
                        } else {
                            ret.add(in.substring(p.beginsAt).trim());
                        }
                        begin = nextP.beginsAt + nextP.spec.getLengthRightSpaced();
                        break;
                    }
                    ret.add(in.substring(p.beginsAt, nextP.beginsAt).trim());
                    begin = nextP.beginsAt;
                    break;
                }
                case 1: {
                    if (p.beginsAt + p.spec.getLengthRightSpaced() < in.length()) {
                        ret.add(in.substring(begin, p.beginsAt + p.spec.getLengthRightSpaced()).trim());
                    } else {
                        ret.add(in.substring(begin).trim());
                    }
                    begin = p.beginsAt + p.spec.getLengthRightSpaced();
                    break;
                }
                case 2: {
                    if (begin < p.beginsAt && 0 < in.substring(begin, p.beginsAt).trim().length()) {
                        ret.add(in.substring(begin, p.beginsAt).trim());
                    }
                    if (p.beginsAt + p.spec.getLengthRightSpaced() < in.length()) {
                        ret.add(in.substring(p.beginsAt, p.beginsAt + p.spec.getLengthRightSpaced()).trim());
                    } else {
                        ret.add(in.substring(p.beginsAt).trim());
                    }
                    begin = p.beginsAt + p.spec.getLengthRightSpaced();
                }
            }
        }
        return ret.toArray(new String[ret.size()]);
    }

    public StateOfPosition[] getStatesOfPosition(String in) {
        StateOfPosition[] ret = new StateOfPosition[in.length()];
        StateOfPosition buf = new StateOfPosition();
        for (int i = 0; i < in.length(); ++i) {
            if ('\'' == in.charAt(i)) {
                ++buf.literalSepCount;
            }
            if (0 == buf.literalSepCount % 2) {
                for (int j = 0; j < this._commentSpecs.length; ++j) {
                    if (in.substring(i).startsWith(this._commentSpecs[j].commentBegin) && -1 == buf.commentIndex) {
                        buf.commentIndex = j;
                    }
                    if (!in.substring(i).startsWith(this._commentSpecs[j].commentEnd) || j != buf.commentIndex) continue;
                    buf.commentIndex = -1;
                }
            }
            if (0 == buf.literalSepCount % 2 && -1 == buf.commentIndex) {
                if ('(' == in.charAt(i)) {
                    ++buf.braketDepth;
                }
                if (')' == in.charAt(i)) {
                    --buf.braketDepth;
                }
            }
            buf.isTopLevel = -1 == buf.commentIndex && 0 == buf.literalSepCount % 2 && 0 == buf.braketDepth;
            ret[i] = (StateOfPosition)buf.clone();
        }
        return ret;
    }
}

