/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.shortcut;

import java.util.MissingResourceException;
import javax.swing.Action;
import javax.swing.KeyStroke;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.fw.resources.ResourceBundleHandler;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class ShortCutReader {
    private ResourceBundleHandler _bundleHandler;

    public ShortCutReader(ResourceBundleHandler bundleHandler) {
        this._bundleHandler = bundleHandler;
    }

    public KeyStroke getDefaultShortcutAsKeyStroke(String fullKey, String actionName) {
        return KeyStroke.getKeyStroke(this._getShortcutAsString(fullKey, actionName, null, true));
    }

    public KeyStroke getShortcutAsKeyStroke(String fullKey, Action action) {
        return KeyStroke.getKeyStroke(this._getShortcutAsString(fullKey, (String)action.getValue("Name"), action, false));
    }

    public String getShortcutAsString(String fullKey, Action action) {
        return this._getShortcutAsString(fullKey, (String)action.getValue("Name"), action, false);
    }

    private String _getShortcutAsString(String fullResourceKey, String actionName, Action action, boolean defaultShortCut) {
        Object shortcutFromAction;
        String ret = this.getShortcutFromResource(fullResourceKey);
        if (StringUtilities.isEmpty(ret, true) && null != (shortcutFromAction = this.getShortcutFromAction(action))) {
            ret = shortcutFromAction.toString();
        }
        if (!defaultShortCut && !StringUtilities.isEmpty(actionName, true)) {
            ret = Main.getApplication().getShortcutManager().registerAccelerator(actionName, KeyStroke.getKeyStroke(ret));
        }
        return ret;
    }

    private String getShortcutFromResource(String fullKey) throws MissingResourceException {
        try {
            return this._bundleHandler.getResourceString(fullKey, "accelerator");
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private Object getShortcutFromAction(Action action) {
        if (null == action) {
            return null;
        }
        return action.getValue("AcceleratorKey");
    }
}

