/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.filemanager;

import java.io.File;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.gui.titlefilepath.TitleFilePathHandler;
import net.sourceforge.squirrel_sql.client.preferences.SquirrelPreferences;
import net.sourceforge.squirrel_sql.client.session.action.file.FileSaveAction;
import net.sourceforge.squirrel_sql.client.session.filemanager.FileManagementCore;
import net.sourceforge.squirrel_sql.client.session.filemanager.IFileEditorAPI;
import net.sourceforge.squirrel_sql.client.util.PrintUtilities;
import net.sourceforge.squirrel_sql.fw.util.FileExtensionFilter;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class FileHandler {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(FileHandler.class);
    private final FileManagementCore _fileManagementCore;
    private IFileEditorAPI _fileEditorAPI;
    private boolean _fileOpened = false;
    private boolean _fileSaved = false;
    private boolean _unsavedEdits = false;

    public FileHandler(IFileEditorAPI fileEditorAPI, TitleFilePathHandler titleFileHandler) {
        this._fileManagementCore = new FileManagementCore(fileEditorAPI, titleFileHandler);
        this._fileEditorAPI = fileEditorAPI;
    }

    public IFileEditorAPI getFileEditorAPI() {
        return this._fileEditorAPI;
    }

    public boolean fileSave() {
        if (this._fileManagementCore.save()) {
            this._fileSaved = true;
            this._unsavedEdits = false;
            this.displayUnsavedEditsInTabComponent(false);
            ActionCollection actions = Main.getApplication().getActionCollection();
            actions.enableAction(FileSaveAction.class, false);
            return true;
        }
        return false;
    }

    public void fileAppend() {
        if (this._fileManagementCore.open(true)) {
            this._fileOpened = true;
            this._fileSaved = false;
            this._unsavedEdits = false;
            this.displayUnsavedEditsInTabComponent(this._unsavedEdits);
            ActionCollection actions = Main.getApplication().getActionCollection();
            actions.enableAction(FileSaveAction.class, true);
        }
    }

    public void fileClose() {
        this._closeFile(true);
    }

    public void fileReload() {
        if (null == this._fileManagementCore.getFile()) {
            Main.getApplication().getMessageHandler().showMessage(s_stringMgr.getString("SQLPanelAPI.nofileToRelaod"));
            return;
        }
        File file = this._fileManagementCore.getFile();
        int caretPosition = this._fileEditorAPI.getCaretPosition();
        if (!this._closeFile(true)) {
            return;
        }
        this.fileOpen(file);
        this._fileEditorAPI.setCaretPosition(Math.min(this._fileEditorAPI.getText().length(), caretPosition));
    }

    public void fileOpen() {
        if (this._unsavedEdits && !this.showConfirmSaveDialog()) {
            return;
        }
        if (this._fileManagementCore.open(false)) {
            this._fileOpened = true;
            this._fileSaved = false;
            this._unsavedEdits = false;
            this.displayUnsavedEditsInTabComponent(this._unsavedEdits);
            ActionCollection actions = Main.getApplication().getActionCollection();
            actions.enableAction(FileSaveAction.class, false);
        }
        this._fileEditorAPI.setCaretPosition(0);
    }

    public void fileOpen(File f) {
        this.fileOpen(f, false);
    }

    public void fileOpen(File f, boolean append) {
        if (this._unsavedEdits) {
            this.showConfirmSaveDialog();
        }
        if (!this._fileManagementCore.open(f, append)) {
            return;
        }
        this._fileOpened = true;
        this._fileSaved = false;
        this._unsavedEdits = false;
        this.displayUnsavedEditsInTabComponent(false);
        ActionCollection actions = Main.getApplication().getActionCollection();
        actions.enableAction(FileSaveAction.class, false);
        this._fileEditorAPI.setCaretPosition(0);
    }

    public void fileNew() {
        this.fileClose();
    }

    public void fileDetach() {
        this._closeFile(false);
    }

    public void fileSaveAs() {
        if (this._fileManagementCore.saveAs()) {
            this._fileSaved = true;
            this._unsavedEdits = false;
            this.displayUnsavedEditsInTabComponent(false);
            ActionCollection actions = Main.getApplication().getActionCollection();
            actions.enableAction(FileSaveAction.class, false);
        }
    }

    public boolean showConfirmCloseIfNecessary() {
        if (this._unsavedEdits) {
            return this.showConfirmSaveDialog();
        }
        return true;
    }

    public void resetUnsavedEdits() {
        this._unsavedEdits = false;
    }

    public void filePrint() {
        PrintUtilities.printComponent(this._fileEditorAPI.getTextComponent());
    }

    private boolean _closeFile(boolean clearEditor) {
        if (this._unsavedEdits && !this.showConfirmSaveDialog()) {
            return false;
        }
        if (clearEditor) {
            this._fileEditorAPI.setEntireSQLScript("");
        }
        this.clearSqlFile();
        this._fileOpened = false;
        this._fileSaved = false;
        this._unsavedEdits = false;
        ActionCollection actions = Main.getApplication().getActionCollection();
        actions.enableAction(FileSaveAction.class, true);
        this._fileManagementCore.clearCurrentFile();
        return true;
    }

    private boolean showConfirmSaveDialog() {
        File file = this._fileManagementCore.getFile();
        String filename = s_stringMgr.getString("SQLPanelAPI.untitledLabel");
        if (file != null) {
            filename = file.getAbsolutePath();
        }
        String msg = s_stringMgr.getString("SQLPanelAPI.unsavedchanges", filename);
        String title = s_stringMgr.getString("SQLPanelAPI.unsavedchangestitle", ": " + this._fileEditorAPI.getSession().getAlias().getName());
        JFrame f = (JFrame)this._fileEditorAPI.getOwningFrame();
        int option = JOptionPane.showConfirmDialog(f, msg, title, 1);
        if (option == 0) {
            return this.fileSave();
        }
        return option != 2 && option != -1;
    }

    public UndoableEditListener createEditListener() {
        return e -> this.onEditHappened(e);
    }

    public void onEditHappened(UndoableEditEvent e) {
        IApplication app = Main.getApplication();
        SquirrelPreferences prefs = app.getSquirrelPreferences();
        if (this._fileOpened || this._fileSaved) {
            if (prefs.getWarnForUnsavedFileEdits()) {
                this._unsavedEdits = true;
            }
            this.displayUnsavedEditsInTabComponent(true);
            ActionCollection actions = Main.getApplication().getActionCollection();
            actions.enableAction(FileSaveAction.class, true);
        } else if (prefs.getWarnForUnsavedBufferEdits()) {
            this._unsavedEdits = true;
        }
    }

    private void clearSqlFile() {
        this._fileManagementCore.clearSqlFile();
    }

    private void displayUnsavedEditsInTabComponent(boolean b) {
        this._fileManagementCore.displayUnsavedEditsInTabComponent(b);
    }

    public void replaceSqlFileExtensionFilterBy(FileExtensionFilter fileExtensionFilter, String fileEndingWithDot) {
        this._fileManagementCore.replaceSqlFileExtensionFilterBy(fileExtensionFilter, fileEndingWithDot);
    }
}

