/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.worksheettypechoice;

import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.resources.SquirrelResources;
import net.sourceforge.squirrel_sql.client.session.action.worksheettypechoice.NewSQLWorksheetAction;
import net.sourceforge.squirrel_sql.client.session.action.worksheettypechoice.SQLWorksheetTypeEnum;
import net.sourceforge.squirrel_sql.fw.gui.buttonchooser.ButtonChooser;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class SQLWorksheetTypeChooser {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SQLWorksheetTypeChooser.class);
    private NewSQLWorksheetAction _action;
    private final ButtonChooser _buttonChooser = new ButtonChooser();

    public SQLWorksheetTypeChooser(NewSQLWorksheetAction action) {
        this._action = action;
        this.initActionAndListeners();
        this.setEnabled(this._action.isEnabled());
        this._action.setEnabledListener(b -> this.setEnabled(b));
    }

    private void setEnabled(boolean enabled) {
        this._buttonChooser.setChooserEnabled(enabled);
    }

    public JComponent getComponent() {
        return this._buttonChooser;
    }

    private void initActionAndListeners() {
        SquirrelResources rsrc = Main.getApplication().getResources();
        ImageIcon iconAddSqlTab = rsrc.getIcon("add_tab");
        ImageIcon iconNewSqlWorkSheet = rsrc.getIcon("new_sql_worksheet");
        String textNewSqlWorkSheet = s_stringMgr.getString("SQLWorksheetTypeChooser.newSqlWorkSheet") + " (" + rsrc.getAcceleratorString(this._action) + ")";
        String textAddSqlTab = s_stringMgr.getString("SQLWorksheetTypeChooser.newSqlTab") + " (" + rsrc.getAcceleratorString(this._action) + ")";
        JButton btnNewSqlWorkSheet = new JButton(textNewSqlWorkSheet, iconNewSqlWorkSheet);
        btnNewSqlWorkSheet.addActionListener(e -> this._action.actionPerformed(e));
        this._buttonChooser.addButton(btnNewSqlWorkSheet);
        JButton btnAddSqlTab = new JButton(textAddSqlTab, iconAddSqlTab);
        btnAddSqlTab.addActionListener(e -> this._action.actionPerformed(e));
        this._buttonChooser.addButton(btnAddSqlTab);
        switch (SQLWorksheetTypeEnum.getSelectedType()) {
            case SQL_WORKSHEET: {
                this._buttonChooser.setSelectedButton(btnNewSqlWorkSheet);
                break;
            }
            case SQL_TAB: {
                this._buttonChooser.setSelectedButton(btnAddSqlTab);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown Type " + (Object)((Object)SQLWorksheetTypeEnum.getSelectedType()));
            }
        }
        this._buttonChooser.setButtonSelectedListener((button, formerSelectedButton) -> this.onButtonSelected(button, btnNewSqlWorkSheet, btnAddSqlTab));
    }

    private void onButtonSelected(AbstractButton button, JButton btnNewSqlWorkSheet, JButton btnAddSqlTab) {
        if (button == btnNewSqlWorkSheet) {
            SQLWorksheetTypeEnum.SQL_WORKSHEET.saveSelected();
        } else if (button == btnAddSqlTab) {
            SQLWorksheetTypeEnum.SQL_TAB.saveSelected();
        }
    }
}

