/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.completion;

import java.util.ArrayList;
import java.util.HashMap;
import net.sourceforge.squirrel_sql.client.session.ISyntaxHighlightTokenMatcher;
import net.sourceforge.squirrel_sql.client.session.SQLTokenListener;
import net.sourceforge.squirrel_sql.fw.completion.CompletionCandidates;
import net.sourceforge.squirrel_sql.fw.completion.CompletionInfo;
import net.sourceforge.squirrel_sql.fw.completion.util.CompletionParser;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernateConnection;
import net.sourceforge.squirrel_sql.plugins.hibernate.completion.AliasInfo;
import net.sourceforge.squirrel_sql.plugins.hibernate.completion.HQLFunctionInfo;
import net.sourceforge.squirrel_sql.plugins.hibernate.completion.HQLKeywordInfo;
import net.sourceforge.squirrel_sql.plugins.hibernate.completion.HqlSyntaxHighlightTokenMatcher;
import net.sourceforge.squirrel_sql.plugins.hibernate.completion.MappingInfoProvider;
import net.sourceforge.squirrel_sql.plugins.hibernate.completion.SimpleHQLCompletionInfo;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.MappedClassInfo;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.PropertyInfo;

public class HQLCompletionInfoCollection
implements MappingInfoProvider {
    private ArrayList<MappedClassInfo> _mappedClassInfos;
    private ArrayList<SimpleHQLCompletionInfo> _simpleInfos;
    private ArrayList<AliasInfo> _currentAliasInfos = new ArrayList();
    private HashMap<String, MappedClassInfo> _mappedClassInfoByClassName = new HashMap();
    private HashMap<String, MappedClassInfo> _mappedClassInfoBySimpleClassName = new HashMap();
    private HashMap<String, SimpleHQLCompletionInfo> _simpleInfosByName = new HashMap();
    private HashMap<String, String> _attributeNames = new HashMap();
    private HqlSyntaxHighlightTokenMatcher _hqlSyntaxHighlightTokenMatcher = new HqlSyntaxHighlightTokenMatcher(this);
    private MappedClassInfo _lastFoundMappedClassInfo;

    public HQLCompletionInfoCollection(HibernateConnection con) {
        this._mappedClassInfos = con.getMappedClassInfos();
        for (MappedClassInfo mappedClassInfo : this._mappedClassInfos) {
            this._mappedClassInfoByClassName.put(mappedClassInfo.getClassName(), mappedClassInfo);
            this._mappedClassInfoBySimpleClassName.put(mappedClassInfo.getSimpleClassName(), mappedClassInfo);
            for (String attrName : mappedClassInfo.getAttributeNames()) {
                this._attributeNames.put(attrName, attrName);
            }
        }
        this._simpleInfos = new ArrayList();
        this._simpleInfos.addAll(HQLKeywordInfo.createInfos());
        this._simpleInfos.addAll(HQLFunctionInfo.createInfos());
        for (SimpleHQLCompletionInfo simpleInfo : this._simpleInfos) {
            this._simpleInfosByName.put(simpleInfo.getCompareString(), simpleInfo);
        }
        this._hqlSyntaxHighlightTokenMatcher.addSQLTokenListener(new SQLTokenListener(){

            public void tableOrViewFound(String name) {
                HQLCompletionInfoCollection.this.onTableOrViewFound(name);
            }
        });
        for (MappedClassInfo mappedClassInfo : this._mappedClassInfos) {
            mappedClassInfo.initAttributesWithClassInfo(this);
        }
    }

    public CompletionCandidates getInfosStartingWith(CompletionParser parser) {
        String stringToReplace;
        int replacementStart;
        ArrayList<CompletionInfo> ciClasses = new ArrayList<CompletionInfo>();
        ArrayList<PropertyInfo> ciAttrs = new ArrayList<PropertyInfo>();
        for (AliasInfo aliasInfo : this._currentAliasInfos) {
            if (aliasInfo.matches(parser)) {
                ciClasses.add(aliasInfo);
            }
            ciAttrs.addAll(aliasInfo.getQualifiedMatchingAttributes(parser));
        }
        for (MappedClassInfo mappedClassInfo : this._mappedClassInfos) {
            if (mappedClassInfo.matches(parser, false, false)) {
                ciClasses.add(mappedClassInfo);
            }
            ciAttrs.addAll(mappedClassInfo.getQualifiedMatchingAttributes(parser));
        }
        ArrayList<Object> ret = new ArrayList<Object>();
        MappedClassInfo lastFoundBuf = this._lastFoundMappedClassInfo;
        if (null != lastFoundBuf) {
            if (1 == parser.size()) {
                ret.addAll(lastFoundBuf.getMatchingAttributes(parser));
            } else {
                for (PropertyInfo propertyInfo : lastFoundBuf.getAttributes()) {
                    if (!propertyInfo.getHibernatePropertyInfo().getPropertyName().equals(parser.getToken(0))) continue;
                    MappedClassInfo mappedClassInfo = propertyInfo.getMappedClassInfo();
                    CompletionParser simpleAttrFakeParser = new CompletionParser(mappedClassInfo.getClassName() + "." + parser.getAllButFirst());
                    ArrayList<PropertyInfo> matchingAttributes = mappedClassInfo.getQualifiedMatchingAttributes(simpleAttrFakeParser);
                    ret.addAll(matchingAttributes);
                }
            }
        }
        if (0 < ciClasses.size()) {
            ret.addAll(ciClasses);
            replacementStart = parser.getReplacementStart();
            stringToReplace = parser.getStringToReplace();
        } else {
            ret.addAll(ciAttrs);
            replacementStart = parser.getTextTillCarret().length() - parser.getLastToken().length();
            stringToReplace = parser.getLastToken();
        }
        for (SimpleHQLCompletionInfo simpleInfo : this._simpleInfos) {
            if (!simpleInfo.matches(parser)) continue;
            ret.add((Object)simpleInfo);
        }
        return new CompletionCandidates(ret.toArray(new CompletionInfo[ret.size()]), replacementStart, stringToReplace);
    }

    private void onTableOrViewFound(String name) {
        MappedClassInfo mappedClassInfo = this._mappedClassInfoBySimpleClassName.get(name);
        this._lastFoundMappedClassInfo = null != mappedClassInfo ? mappedClassInfo : this._mappedClassInfoByClassName.get(name);
    }

    public void setCurrentAliasInfos(ArrayList<AliasInfo> aliasInfos) {
        this._currentAliasInfos = aliasInfos;
    }

    @Override
    public MappedClassInfo getMappedClassInfoFor(String token) {
        CompletionParser cp = new CompletionParser(token);
        if (2 > cp.size()) {
            return this.getMappedClassInfoForNonAliasedToken(cp, true);
        }
        String aliasCandidate = cp.getToken(0);
        ArrayList<AliasInfo> buf = this._currentAliasInfos;
        for (AliasInfo currentAliasInfo : buf) {
            if (!currentAliasInfo.getCompareString().equals(aliasCandidate)) continue;
            ArrayList<PropertyInfo> matchingAttributes = currentAliasInfo.getQualifiedMatchingAttributes(cp);
            for (PropertyInfo matchingAttribute : matchingAttributes) {
                if (!matchingAttribute.getHibernatePropertyInfo().getPropertyName().equals(cp.getLastToken())) continue;
                return matchingAttribute.getMappedClassInfo();
            }
        }
        return this.getMappedClassInfoForNonAliasedToken(cp, false);
    }

    private MappedClassInfo getMappedClassInfoForNonAliasedToken(CompletionParser cp, boolean matchNameExact) {
        MappedClassInfo ret = null;
        for (MappedClassInfo mappedClassInfo : this._mappedClassInfos) {
            if (mappedClassInfo.matches(cp, true, true)) {
                return mappedClassInfo;
            }
            if (!matchNameExact && mappedClassInfo.matches(cp, false, true)) {
                ret = mappedClassInfo;
            }
            if (!cp.getStringToParse().startsWith(mappedClassInfo.getClassName()) && !cp.getStringToParse().startsWith(mappedClassInfo.getSimpleClassName())) continue;
            ArrayList<PropertyInfo> matchingAttributes = mappedClassInfo.getQualifiedMatchingAttributes(cp);
            for (PropertyInfo matchingAttribute : matchingAttributes) {
                if (!matchingAttribute.getHibernatePropertyInfo().getPropertyName().equals(cp.getLastToken())) continue;
                return matchingAttribute.getMappedClassInfo();
            }
        }
        return ret;
    }

    @Override
    public boolean mayBeClassOrAliasName(String token) {
        if (0 == token.length()) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(token.charAt(0))) {
            return false;
        }
        if (this._simpleInfosByName.containsKey(token)) {
            return false;
        }
        for (int i = 1; i < token.length(); ++i) {
            char c = token.charAt(i);
            if (Character.isJavaIdentifierPart(c) || '.' == c) continue;
            return false;
        }
        return true;
    }

    @Override
    public MappedClassInfo getExactMappedClassInfoFor(String className) {
        return this._mappedClassInfoByClassName.get(className);
    }

    public ISyntaxHighlightTokenMatcher getHqlSyntaxHighlightTokenMatcher() {
        return this._hqlSyntaxHighlightTokenMatcher;
    }

    public boolean isMappeadClass(String name) {
        return this._mappedClassInfoByClassName.containsKey(name) || this._mappedClassInfoBySimpleClassName.containsKey(name);
    }

    public boolean isFunction(String name) {
        SimpleHQLCompletionInfo completionInfo = this._simpleInfosByName.get(name);
        return null != completionInfo && completionInfo instanceof HQLFunctionInfo;
    }

    public boolean isKeyword(String name) {
        SimpleHQLCompletionInfo completionInfo = this._simpleInfosByName.get(name);
        return null != completionInfo && completionInfo instanceof HQLKeywordInfo;
    }

    public boolean isMappedAttribute(String name) {
        return this._attributeNames.containsKey(name);
    }
}

