/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.squirrel.tab;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.BaseDataSetTab;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.JavabeanDataSet;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import org.firebirdsql.squirrel.util.IndexInfo;

public class IndexInfoTab
extends BaseDataSetTab {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(IndexInfoTab.class);
    private String SQL = "SELECT RDB$INDEX_NAME,RDB$DESCRIPTION,RDB$INDEX_ID,RDB$RELATION_NAME,RDB$UNIQUE_FLAG,RDB$SEGMENT_COUNT,RDB$INDEX_INACTIVE,RDB$SYSTEM_FLAG,RDB$FOREIGN_KEY,RDB$EXPRESSION_SOURCE FROM RDB$INDICES WHERE RDB$INDEX_NAME = ?";

    public String getTitle() {
        return s_stringMgr.getString("IndexInfoTab.title");
    }

    public String getHint() {
        return s_stringMgr.getString("IndexInfoTab.hint");
    }

    protected IDataSet createDataSet() throws DataSetException {
        return new JavabeanDataSet((Object)this.createIndexInfo());
    }

    private IndexInfo createIndexInfo() throws DataSetException {
        IDatabaseObjectInfo doi;
        ResultSet rs;
        block5: {
            ISession session = this.getSession();
            ISQLConnection conn = session.getSQLConnection();
            PreparedStatement pstmt = null;
            rs = null;
            doi = this.getDatabaseObjectInfo();
            pstmt = conn.prepareStatement(this.SQL);
            pstmt.setString(1, doi.getSimpleName());
            rs = pstmt.executeQuery();
            if (!rs.next()) break block5;
            IndexInfo indexInfo = new IndexInfo(rs.getString(1), rs.getString(2), rs.getInt(3), rs.getString(4), rs.getInt(5), rs.getInt(6), rs.getInt(7), rs.getInt(8), rs.getString(9), rs.getString(10));
            SQLUtilities.closeResultSet((ResultSet)rs, (boolean)true);
            return indexInfo;
        }
        try {
            try {
                String msg = s_stringMgr.getString("IndexInfoTab.err.noindex", new Object[]{doi.getSimpleName()});
                throw new DataSetException(msg);
            }
            catch (SQLException ex) {
                throw new DataSetException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            SQLUtilities.closeResultSet(rs, (boolean)true);
            throw throwable;
        }
    }
}

