/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import com.jidesoft.utils.FontFilesResource;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.swing.plaf.FontUIResource;

public class SecurityUtils {
    public static final String BOLD = "Bold";
    public static final String ITALIC = "Italic";
    public static final String BOLD_ITALIC = "Bold Italic";
    private static Hashtable<String, String> _safeProperties = null;
    private static boolean _AWTEventListenerDisabled = false;

    public static FontUIResource createFontUIResource(String name, int style, int size) {
        Font font = SecurityUtils.createFont(name, style, size);
        if (font != null) {
            return new FontUIResource(font);
        }
        return null;
    }

    private static String createFontStrings(String font, int style) {
        String fontString;
        switch (style) {
            case 1: {
                fontString = font + " " + BOLD;
                break;
            }
            case 2: {
                fontString = font + " " + ITALIC;
                break;
            }
            case 3: {
                fontString = font + " " + BOLD_ITALIC;
                break;
            }
            default: {
                fontString = font;
            }
        }
        return fontString.replace(' ', '_');
    }

    private static FontStruct getFontStruct(String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        text = text.replace('_', ' ');
        FontStruct fontStruct = new FontStruct();
        if (text.endsWith(BOLD)) {
            fontStruct.style = 1;
            fontStruct.font = text.substring(0, text.length() - BOLD.length());
        } else if (text.endsWith(ITALIC)) {
            fontStruct.style = 2;
            fontStruct.font = text.substring(0, text.length() - ITALIC.length());
        } else if (text.endsWith(BOLD)) {
            fontStruct.style = 3;
            fontStruct.font = text.substring(0, text.length() - BOLD_ITALIC.length());
        } else {
            fontStruct.style = 0;
            fontStruct.font = text;
        }
        return fontStruct;
    }

    public static Font createFont(String name, int style, int size) {
        try {
            return new Font(name, style, size);
        }
        catch (AccessControlException e) {
            ClassLoader cl = SecurityUtils.class.getClassLoader();
            try {
                String value = null;
                try {
                    value = FontFilesResource.getResourceBundle(Locale.getDefault()).getString(SecurityUtils.createFontStrings(name, style));
                }
                catch (MissingResourceException me1) {
                    try {
                        value = FontFilesResource.getResourceBundle(Locale.getDefault()).getString(name);
                    }
                    catch (MissingResourceException me2) {
                        // empty catch block
                    }
                }
                if (value == null) {
                    return null;
                }
                Font font = Font.createFont(0, cl.getResourceAsStream(value));
                if (font != null) {
                    return font.deriveFont(style, size);
                }
            }
            catch (FontFormatException e1) {
                e1.printStackTrace();
                throw e;
            }
            catch (IOException e1) {
                e1.printStackTrace();
                throw e;
            }
            return null;
        }
    }

    private static Hashtable getSafeProperties() {
        if (_safeProperties == null) {
            _safeProperties = new Hashtable(13);
            _safeProperties.put("java.version", "");
            _safeProperties.put("java.vendor", "");
            _safeProperties.put("java.vendor.url", "");
            _safeProperties.put("java.class.version", "");
            _safeProperties.put("os.name", "");
            _safeProperties.put("os.version", "");
            _safeProperties.put("os.arch", "");
            _safeProperties.put("file.separator", "");
            _safeProperties.put("path.separator", "");
            _safeProperties.put("line.separator", "");
            _safeProperties.put("java.specification.version", "");
            _safeProperties.put("java.specification.vendor", "");
            _safeProperties.put("java.specification.name", "");
            _safeProperties.put("java.vm.specification.vendor", "");
            _safeProperties.put("java.vm.specification.name", "");
            _safeProperties.put("java.vm.version", "");
            _safeProperties.put("java.vm.vendor", "");
            _safeProperties.put("java.vm.name", "");
        }
        return _safeProperties;
    }

    public static String getProperty(String key, String defaultValue) {
        try {
            return System.getProperty(key, defaultValue);
        }
        catch (AccessControlException e) {
            return defaultValue;
        }
    }

    public static boolean isAWTEventListenerDisabled() {
        return _AWTEventListenerDisabled;
    }

    public static void setAWTEventListenerDisabled(boolean AWTEventListenerDisabled) {
        _AWTEventListenerDisabled = AWTEventListenerDisabled;
    }

    static class FontStruct {
        String font;
        int style;

        FontStruct() {
        }
    }
}

