/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextfilechooser;

import java.awt.Color;
import java.util.HashMap;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.fife.ui.rtextfilechooser.RTextFileChooser;

class FileChooserPreferences {
    public boolean showHiddenFiles;
    public boolean fileSystemAware;
    public boolean autoCompleteFileNames;
    public Color hiddenFileColor;
    public HashMap customColors;
    public boolean styleOpenFiles;
    public int openFilesStyle;
    public int viewMode;
    private static final String FTI_PREFIX = "fti_";
    private static final String AUTO_COMPLETE_KEY = "autoComplete";
    private static final String FILE_SYSTEM_AWARE_KEY = "fileSystemAware";
    private static final String HIDDEN_FILE_COLOR_KEY = "hiddenfilecolor";
    private static final String OPEN_FILES_STYLE_KEY = "openFilesStyle";
    private static final String SHOW_HIDDEN_FILES_KEY = "showhiddenfiles";
    private static final String STYLE_OPEN_FILES_KEY = "styleOpenFiles";
    private static final String VIEW_MODE_KEY = "viewMode";
    private static final Color DEFAULT_HIDDEN_FILE_COLOR = new Color(192, 192, 192);
    private static final Color DEFAULT_COLOR = Color.BLACK;
    private static final int DEFAULT_HIDDEN_FILE_COLOR_INT = DEFAULT_HIDDEN_FILE_COLOR.getRGB();
    private static final int DEFAULT_COLOR_INT = DEFAULT_COLOR.getRGB();

    private FileChooserPreferences() {
        this.setDefaults();
    }

    private static FileChooserPreferences generate(RTextFileChooser chooser) {
        FileChooserPreferences prefs = new FileChooserPreferences();
        prefs.customColors = chooser.getCustomColorsMap();
        prefs.hiddenFileColor = chooser.getHiddenFileColor();
        prefs.showHiddenFiles = chooser.getShowHiddenFiles();
        prefs.fileSystemAware = chooser.getFileSystemAware();
        prefs.autoCompleteFileNames = chooser.getAutoCompleteFileNames();
        prefs.styleOpenFiles = chooser.getStyleOpenFiles();
        prefs.openFilesStyle = chooser.getOpenFilesStyle();
        prefs.viewMode = chooser.getViewMode();
        return prefs;
    }

    public static FileChooserPreferences load() {
        FileChooserPreferences fprefs = new FileChooserPreferences();
        try {
            Preferences prefs = Preferences.userNodeForPackage(RTextFileChooser.class);
            fprefs.customColors = FileChooserPreferences.loadCustomColorsMap();
            fprefs.hiddenFileColor = new Color(prefs.getInt(HIDDEN_FILE_COLOR_KEY, DEFAULT_HIDDEN_FILE_COLOR_INT));
            fprefs.showHiddenFiles = prefs.getBoolean(SHOW_HIDDEN_FILES_KEY, fprefs.showHiddenFiles);
            fprefs.fileSystemAware = prefs.getBoolean(FILE_SYSTEM_AWARE_KEY, fprefs.fileSystemAware);
            fprefs.autoCompleteFileNames = prefs.getBoolean(AUTO_COMPLETE_KEY, fprefs.autoCompleteFileNames);
            fprefs.styleOpenFiles = prefs.getBoolean(STYLE_OPEN_FILES_KEY, fprefs.styleOpenFiles);
            fprefs.openFilesStyle = prefs.getInt(OPEN_FILES_STYLE_KEY, fprefs.openFilesStyle);
            fprefs.viewMode = prefs.getInt(VIEW_MODE_KEY, fprefs.viewMode);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            fprefs.setDefaults();
        }
        return fprefs;
    }

    private static HashMap loadCustomColorsMap() {
        HashMap<String, Color> map = new HashMap<String, Color>();
        try {
            Preferences prefs = Preferences.userNodeForPackage(RTextFileChooser.class);
            String[] keys = prefs.keys();
            int count = keys.length;
            int prefixLength = FTI_PREFIX.length();
            for (int i = 0; i < count; ++i) {
                if (!keys[i].startsWith(FTI_PREFIX)) continue;
                String extension = keys[i].substring(prefixLength);
                int packed = prefs.getInt(keys[i], DEFAULT_COLOR_INT);
                Color c = new Color(packed);
                map.put(extension, c);
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map;
    }

    public static void save(RTextFileChooser chooser) {
        FileChooserPreferences fcp = FileChooserPreferences.generate(chooser);
        Preferences prefs = Preferences.userNodeForPackage(RTextFileChooser.class);
        try {
            prefs.clear();
        }
        catch (BackingStoreException bse) {
            bse.printStackTrace();
        }
        Set keys = fcp.customColors.keySet();
        for (String key : keys) {
            Color c = (Color)fcp.customColors.get(key);
            prefs.putInt(FTI_PREFIX + key, c.getRGB());
        }
        prefs.putInt(HIDDEN_FILE_COLOR_KEY, fcp.hiddenFileColor.getRGB());
        prefs.putBoolean(SHOW_HIDDEN_FILES_KEY, fcp.showHiddenFiles);
        prefs.putBoolean(FILE_SYSTEM_AWARE_KEY, fcp.fileSystemAware);
        prefs.putBoolean(AUTO_COMPLETE_KEY, fcp.autoCompleteFileNames);
        prefs.putBoolean(STYLE_OPEN_FILES_KEY, fcp.styleOpenFiles);
        prefs.putInt(OPEN_FILES_STYLE_KEY, fcp.openFilesStyle);
        prefs.putInt(VIEW_MODE_KEY, fcp.viewMode);
    }

    protected void setDefaults() {
        this.showHiddenFiles = false;
        this.hiddenFileColor = DEFAULT_HIDDEN_FILE_COLOR;
        this.fileSystemAware = true;
        this.autoCompleteFileNames = true;
        this.customColors = null;
        this.styleOpenFiles = true;
        this.openFilesStyle = 2;
        this.viewMode = 0;
    }
}

