/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import java.sql.SQLException;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.functions.Expression;
import unity.functions.Function;

public class F_Replace
extends Function {
    private static final long serialVersionUID = 1L;
    private Expression sourceString;
    private Expression searchString;
    private Expression replaceString;

    public F_Replace(Expression expression, Expression expression2, Expression expression3) {
        this.sourceString = expression;
        this.searchString = expression2;
        this.replaceString = expression3;
    }

    @Override
    public Object evaluate(Tuple tuple) throws SQLException {
        String string = (String)this.sourceString.evaluate(tuple);
        if (string == null) {
            return null;
        }
        String string2 = (String)this.searchString.evaluate(tuple);
        if (string2 == null) {
            return string;
        }
        String string3 = (String)this.replaceString.evaluate(tuple);
        if (string3 == null) {
            return string;
        }
        return string.replaceAll(string2, string3);
    }

    @Override
    public int getReturnType() {
        return 12;
    }

    public static int[] getParamListTypes() {
        return new int[]{12, 12, 12};
    }

    public static String getFunctionName() {
        return "REPLACE";
    }

    @Override
    public String toString(Relation relation) {
        return "REPLACE(" + this.sourceString.toString(relation) + ", " + this.searchString.toString(relation) + ", " + this.replaceString.toString(relation) + ")";
    }
}

