/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "gu" locale.
 */
public class LocalizedNamesImpl_gu extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "IN",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AO",
        "AZ",
        "AF",
        "AS",
        "AW",
        "DZ",
        "AL",
        "CI",
        "IS",
        "QO",
        "IE",
        "AR",
        "AM",
        "GQ",
        "EG",
        "IL",
        "IT",
        "ET",
        "ID",
        "IQ",
        "IM",
        "IR",
        "UZ",
        "MP",
        "KP",
        "UY",
        "AI",
        "AD",
        "EC",
        "AQ",
        "AG",
        "ER",
        "SV",
        "AX",
        "AC",
        "EE",
        "AT",
        "AU",
        "OM",
        "KH",
        "KZ",
        "QA",
        "KI",
        "KG",
        "CK",
        "CW",
        "KW",
        "IC",
        "CV",
        "CM",
        "CA",
        "KE",
        "KY",
        "BQ",
        "CD",
        "CG",
        "CC",
        "KM",
        "CO",
        "XK",
        "CR",
        "CU",
        "CX",
        "HR",
        "CP",
        "GY",
        "GN",
        "GW",
        "GA",
        "GM",
        "GL",
        "GR",
        "GD",
        "GT",
        "GP",
        "GU",
        "GG",
        "GH",
        "TD",
        "CL",
        "CN",
        "CZ",
        "JM",
        "DE",
        "JE",
        "JP",
        "DJ",
        "GI",
        "JO",
        "GE",
        "ZM",
        "ZW",
        "TC",
        "TO",
        "TK",
        "TG",
        "TN",
        "TA",
        "DG",
        "DK",
        "DO",
        "DM",
        "TZ",
        "TW",
        "TJ",
        "TR",
        "TM",
        "TV",
        "TT",
        "TH",
        "ZA",
        "KR",
        "GS",
        "SS",
        "NE",
        "NG",
        "NA",
        "NI",
        "NU",
        "AN",
        "NL",
        "NP",
        "NO",
        "NF",
        "NR",
        "NZ",
        "NC",
        "PA",
        "PW",
        "EH",
        "PK",
        "PG",
        "PN",
        "TL",
        "PY",
        "PE",
        "PS",
        "PT",
        "PL",
        "PR",
        "PH",
        "FJ",
        "FI",
        "FO",
        "FK",
        "FR",
        "GF",
        "PF",
        "TF",
        "BM",
        "BG",
        "BS",
        "BD",
        "BB",
        "BI",
        "BF",
        "BJ",
        "BY",
        "BZ",
        "BE",
        "BH",
        "BW",
        "BO",
        "BA",
        "BV",
        "BR",
        "IO",
        "VG",
        "BN",
        "IN",
        "BT",
        "MN",
        "MO",
        "MY",
        "FM",
        "MQ",
        "MH",
        "MV",
        "MW",
        "ML",
        "MT",
        "MX",
        "MG",
        "YT",
        "MK",
        "ME",
        "MS",
        "MZ",
        "MC",
        "MU",
        "MA",
        "MD",
        "MR",
        "MM",
        "VI",
        "UG",
        "AE",
        "GB",
        "EU",
        "UA",
        "YE",
        "RW",
        "RU",
        "RE",
        "RO",
        "LU",
        "LR",
        "LA",
        "LV",
        "LT",
        "LY",
        "LB",
        "LS",
        "LI",
        "VU",
        "VN",
        "VA",
        "VE",
        "WF",
        "SC",
        "LK",
        "US",
        "UM",
        "WS",
        "RS",
        "SA",
        "ST",
        "CY",
        "SG",
        "SX",
        "SL",
        "SY",
        "SD",
        "SR",
        "SM",
        "KN",
        "PM",
        "BL",
        "MF",
        "LC",
        "VC",
        "SH",
        "CF",
        "SN",
        "SO",
        "SB",
        "ES",
        "EA",
        "SK",
        "SI",
        "SZ",
        "SJ",
        "CH",
        "SE",
        "HU",
        "HM",
        "HT",
        "HK",
        "HN",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "વિશ્વ");
    namesMap.put("002", "આફ્રિકા");
    namesMap.put("003", "ઉતર અમેરિકા");
    namesMap.put("005", "દક્ષિણ અમેરિકા");
    namesMap.put("009", "ઓશિઆનિયા");
    namesMap.put("011", "પશ્ચિમ આફ્રિકા");
    namesMap.put("013", "મધ્ય અમેરિકા");
    namesMap.put("014", "પૂર્વ અમેરિકા");
    namesMap.put("015", "ઉતરીય આફ્રિકા");
    namesMap.put("017", "મધ્ય આફ્રિકા");
    namesMap.put("018", "દક્ષિણી આફ્રિકા");
    namesMap.put("019", "અમેરિકાસ");
    namesMap.put("021", "ઉતરીય અમેરિકા");
    namesMap.put("029", "કેરિબિયન");
    namesMap.put("030", "પૂર્વી એશિયા");
    namesMap.put("034", "દક્ષિણી એશિયા");
    namesMap.put("035", "દક્ષિણ- પૂર્વ એશિયા");
    namesMap.put("039", "દક્ષિણી યૂરોપ");
    namesMap.put("053", "ઓસ્ટ્રેલિયા");
    namesMap.put("054", "મેલાનેશિયા");
    namesMap.put("057", "માઇક્રોનેશિયન રીજન");
    namesMap.put("061", "પોલિનેશિયા");
    namesMap.put("142", "એશિયા");
    namesMap.put("143", "મધ્ય એશિયા");
    namesMap.put("145", "પશ્ચિમ એશિયા");
    namesMap.put("150", "યૂરોપ");
    namesMap.put("151", "પૂર્વી યૂરોપ");
    namesMap.put("154", "ઉતરીય યૂરોપ");
    namesMap.put("155", "પશ્ચિમ યૂરોપ");
    namesMap.put("419", "લેટિન અમેરિકા");
    namesMap.put("AC", "એસેન્શન આઇલેન્ડ");
    namesMap.put("AD", "ઍંડોરા");
    namesMap.put("AE", "યુનાઇટેડ અરબ એમિરેટ્સ");
    namesMap.put("AF", "અફઘાનિસ્તાન");
    namesMap.put("AG", "એન્ટીગુઆ અને બરબુડા");
    namesMap.put("AI", "ઍંગ્વિલા");
    namesMap.put("AL", "અલ્બેનિયા");
    namesMap.put("AM", "આર્મેનિયા");
    namesMap.put("AN", "નેધરલેંડ્સ એંટિલેસ");
    namesMap.put("AO", "અંગોલા");
    namesMap.put("AQ", "એન્ટાર્કટિકા");
    namesMap.put("AR", "આર્જેન્ટીના");
    namesMap.put("AS", "અમેરીકન સમોઆ");
    namesMap.put("AT", "ઑસ્ટ્રિયા");
    namesMap.put("AU", "ઑસ્ટ્રેલિયા");
    namesMap.put("AW", "અરુબા");
    namesMap.put("AX", "એલેંડ આઇલેન્ડ્સ");
    namesMap.put("AZ", "અઝરબૈજાન");
    namesMap.put("BA", "બોસ્નિયા અને હર્ઝેગોવિના");
    namesMap.put("BB", "બાર્બાડોસ");
    namesMap.put("BD", "બાંગ્લાદેશ");
    namesMap.put("BE", "બેલ્જીયમ");
    namesMap.put("BF", "બુર્કિના ફાસો");
    namesMap.put("BG", "બલ્ગેરિયા");
    namesMap.put("BH", "બેહરીન");
    namesMap.put("BI", "બુરુંડી");
    namesMap.put("BJ", "બેનિન");
    namesMap.put("BL", "સેંટ બાર્થલેમી");
    namesMap.put("BM", "બર્મુડા");
    namesMap.put("BN", "બ્રુનેઇ");
    namesMap.put("BO", "બોલિવિયા");
    namesMap.put("BQ", "કેરેબિયન નેધરલેન્ડ્ઝ");
    namesMap.put("BR", "બ્રાઝિલ");
    namesMap.put("BS", "બહામાસ");
    namesMap.put("BT", "ભૂટાન");
    namesMap.put("BV", "બૌવેત આઇલેન્ડ");
    namesMap.put("BW", "બોત્સ્વાના");
    namesMap.put("BY", "બેલારુસ");
    namesMap.put("BZ", "બેલીઝ");
    namesMap.put("CA", "કેનેડા");
    namesMap.put("CC", "કોકોઝ આઇલેન્ડ");
    namesMap.put("CD", "કોંગો - કિંશાસા");
    namesMap.put("CF", "સેંટ્રલ આફ્રિકન રીપબ્લિક");
    namesMap.put("CG", "કોંગો - બ્રાઝાવિલે");
    namesMap.put("CH", "સ્વિટ્ઝર્લૅન્ડ");
    namesMap.put("CI", "આઇવરી કોસ્ટ");
    namesMap.put("CK", "કુક આઇલેન્ડ્સ");
    namesMap.put("CL", "ચિલી");
    namesMap.put("CM", "કૅમરૂન");
    namesMap.put("CN", "ચીન");
    namesMap.put("CO", "કોલમ્બિયા");
    namesMap.put("CP", "ક્લિપરટન આઇલેન્ડ");
    namesMap.put("CR", "કોસ્ટા રિકા");
    namesMap.put("CU", "ક્યુબા");
    namesMap.put("CV", "કૅપ વર્ડે");
    namesMap.put("CW", "કુરાકાઓ");
    namesMap.put("CX", "ક્રિસમસ આઇલેંડ");
    namesMap.put("CY", "સાયપ્રસ");
    namesMap.put("CZ", "ચેક રીપબ્લિક");
    namesMap.put("DE", "જર્મની");
    namesMap.put("DG", "ડિએગો ગારસિઆ");
    namesMap.put("DJ", "જીબૌટી");
    namesMap.put("DK", "ડેનમાર્ક");
    namesMap.put("DM", "ડોમિનિકા");
    namesMap.put("DO", "ડોમિનિકન રીપબ્લિક");
    namesMap.put("DZ", "અલ્જીરિયા");
    namesMap.put("EA", "સ્યુટા અને મેલિલા");
    namesMap.put("EC", "એક્વાડોર");
    namesMap.put("EE", "એસ્ટોનિયા");
    namesMap.put("EG", "ઇજિપ્ત");
    namesMap.put("EH", "પશ્ચિમી સહારા");
    namesMap.put("ER", "એરિટ્રિયા");
    namesMap.put("ES", "સ્પેન");
    namesMap.put("ET", "ઇથિઓપિયા");
    namesMap.put("EU", "યુરોપિયન સંઘ");
    namesMap.put("FI", "ફીનલેંડ");
    namesMap.put("FJ", "ફીજી");
    namesMap.put("FK", "ફૉકલૅંડ આઇલૅંડ્સ");
    namesMap.put("FM", "માઇક્રોનેશિયા");
    namesMap.put("FO", "ફૅરો આઇલેન્ડ્સ");
    namesMap.put("FR", "ફ્રાંસ");
    namesMap.put("GA", "ગેબન");
    namesMap.put("GB", "યુનાઇટેડ કિંગડમ");
    namesMap.put("GD", "ગ્રેનેડા");
    namesMap.put("GE", "જ્યોર્જીયા");
    namesMap.put("GF", "ફ્રેંચ ગયાના");
    namesMap.put("GG", "ગ્વેર્નસે");
    namesMap.put("GH", "ઘાના");
    namesMap.put("GI", "જીબ્રાલ્ટર");
    namesMap.put("GL", "ગ્રીનલેન્ડ");
    namesMap.put("GM", "ગેમ્બિયા");
    namesMap.put("GN", "ગિની");
    namesMap.put("GP", "ગ્વાડેલોપ");
    namesMap.put("GQ", "ઇક્વેટોરિયલ ગિની");
    namesMap.put("GR", "ગ્રીસ");
    namesMap.put("GS", "દક્ષિણ જ્યોર્જીયા અને દક્ષિણ સેન્ડવિચ આઇલેન્ડ");
    namesMap.put("GT", "ગ્વાટેમાલા");
    namesMap.put("GU", "ગ્વામ");
    namesMap.put("GW", "ગિની-બિસાઉ");
    namesMap.put("GY", "ગયાના");
    namesMap.put("HK", "હોંગકોંગ સાર ચીન");
    namesMap.put("HM", "હર્ડ આઇલૅંડ એંડ મેકડોનાલ્ડ આઇલૅંડ્સ");
    namesMap.put("HN", "હોન્ડુરસ");
    namesMap.put("HR", "ક્રોએશિયા");
    namesMap.put("HT", "હૈતિ");
    namesMap.put("HU", "હંગેરી");
    namesMap.put("IC", "કૅનેરી આઇલેન્ડ્સ");
    namesMap.put("ID", "ઇન્ડોનેશિયા");
    namesMap.put("IE", "આયર્લેંડ");
    namesMap.put("IL", "ઇઝરાઇલ");
    namesMap.put("IM", "ઇસ્લે ઓફ મૅન");
    namesMap.put("IN", "ભારત");
    namesMap.put("IO", "બ્રિટિશ ઇન્ડિયન ઓશન ટેરિટરી");
    namesMap.put("IQ", "ઇરાક");
    namesMap.put("IR", "ઈરાન");
    namesMap.put("IS", "આઇસલેન્ડ");
    namesMap.put("IT", "ઇટાલી");
    namesMap.put("JE", "જર્સી");
    namesMap.put("JM", "જમૈકા");
    namesMap.put("JO", "જોર્ડન");
    namesMap.put("JP", "જાપાન");
    namesMap.put("KE", "કેન્યા");
    namesMap.put("KG", "કિર્ગિઝ્સ્તાન");
    namesMap.put("KH", "કંબોડિયા");
    namesMap.put("KI", "કિરિબાટી");
    namesMap.put("KM", "કોમોરસ");
    namesMap.put("KN", "સેંટ કિટ્સ એંડ નેવિસ");
    namesMap.put("KP", "ઉત્તર કોરિયા");
    namesMap.put("KR", "દક્ષિણ કોરિયા");
    namesMap.put("KW", "કુવૈત");
    namesMap.put("KY", "કેયમેન આઇલૅંડ્સ");
    namesMap.put("KZ", "કઝાકિસ્તાન");
    namesMap.put("LA", "લાઓસ");
    namesMap.put("LB", "લેબનોન");
    namesMap.put("LC", "સેંટ લુસિયા");
    namesMap.put("LI", "લૈચટેંસ્ટેઇન");
    namesMap.put("LK", "શ્રીલંકા");
    namesMap.put("LR", "લાઇબેરિયા");
    namesMap.put("LS", "લેસોથો");
    namesMap.put("LT", "લિથુઆનિયા");
    namesMap.put("LU", "લક્ઝમબર્ગ");
    namesMap.put("LV", "લાત્વિયા");
    namesMap.put("LY", "લિબિયા");
    namesMap.put("MA", "મોરોક્કો");
    namesMap.put("MC", "મોનાકો");
    namesMap.put("MD", "મોલડોવા");
    namesMap.put("ME", "મૉન્ટેંનેગ્રો");
    namesMap.put("MF", "સેંટ માર્ટિન");
    namesMap.put("MG", "મેડાગાસ્કર");
    namesMap.put("MH", "માર્શલ આઇલેન્ડ્સ");
    namesMap.put("MK", "મેસેડોનિયા");
    namesMap.put("ML", "માલી");
    namesMap.put("MM", "મ્યાંમાર");
    namesMap.put("MN", "મંગોલિયા");
    namesMap.put("MO", "મકાઉ SAR ચીન");
    namesMap.put("MP", "ઉતરીય મારિયાના આઇલેન્ડ્સ");
    namesMap.put("MQ", "માર્ટીનીક");
    namesMap.put("MR", "મૌરિટાનિયા");
    namesMap.put("MS", "મોંટસેરાત");
    namesMap.put("MT", "માલ્ટા");
    namesMap.put("MU", "મોરિશિયસ");
    namesMap.put("MV", "માલદિવ્સ");
    namesMap.put("MW", "માલાવી");
    namesMap.put("MX", "મેક્સિકો");
    namesMap.put("MY", "મલેશિયા");
    namesMap.put("MZ", "મોઝામ્બિક");
    namesMap.put("NA", "નામિબિયા");
    namesMap.put("NC", "ન્યુ સેલેડોનિયા");
    namesMap.put("NE", "નાઇજર");
    namesMap.put("NF", "નોરફૉક આઇલેન્ડ");
    namesMap.put("NG", "નાઇજીરીયા");
    namesMap.put("NI", "નિકારાગુઆ");
    namesMap.put("NL", "નેધરલેન્ડ");
    namesMap.put("NO", "નૉર્વે");
    namesMap.put("NP", "નેપાળ");
    namesMap.put("NR", "નૌરુ");
    namesMap.put("NU", "નીયુ");
    namesMap.put("NZ", "ન્યુઝીલેન્ડ");
    namesMap.put("OM", "ઓમાન");
    namesMap.put("PA", "પનામા");
    namesMap.put("PE", "પેરુ");
    namesMap.put("PF", "ફ્રેંચ પોલિનેશિયા");
    namesMap.put("PG", "પાપુઆ ન્યૂ ગિની");
    namesMap.put("PH", "ફિલિપિન્સ");
    namesMap.put("PK", "પાકિસ્તાન");
    namesMap.put("PL", "પોલેંડ");
    namesMap.put("PM", "સેંટ પીએરે એન્ડ મિકીલોન");
    namesMap.put("PN", "પીટકૈર્ન");
    namesMap.put("PR", "પ્યુઅર્ટો રિકો");
    namesMap.put("PS", "પેલેસ્ટિનિયન ટેરિટરી");
    namesMap.put("PT", "પોર્ટુગલ");
    namesMap.put("PW", "પલાઉ");
    namesMap.put("PY", "પેરાગ્વે");
    namesMap.put("QA", "કતાર");
    namesMap.put("QO", "આઉટલાયિંગ ઓશનિયા");
    namesMap.put("RE", "રીયુનિયન");
    namesMap.put("RO", "રોમાનિયા");
    namesMap.put("RS", "સર્બિયા");
    namesMap.put("RU", "રશિયન ફેડરેશન");
    namesMap.put("RW", "રવાંડા");
    namesMap.put("SA", "સાઉદી અરેબિયા");
    namesMap.put("SB", "સોલોમન આઇલેન્ડ");
    namesMap.put("SC", "શેશેલ્સ");
    namesMap.put("SD", "સુદાન");
    namesMap.put("SE", "સ્વીડન");
    namesMap.put("SG", "સિંગાપુર");
    namesMap.put("SH", "સેંટ હેલેના");
    namesMap.put("SI", "સ્લોવેનિયા");
    namesMap.put("SJ", "સ્વાલબર્ડ એંડ જેન મેયન");
    namesMap.put("SK", "સ્લોવેકિયા");
    namesMap.put("SL", "સીએરા લેઓન");
    namesMap.put("SM", "સૅન મેરિનો");
    namesMap.put("SN", "સેનેગલ");
    namesMap.put("SO", "સોમાલિયા");
    namesMap.put("SR", "સુરીનામ");
    namesMap.put("SS", "દક્ષિણ સુદાન");
    namesMap.put("ST", "સાઓ ટૉમ અને પ્રિંસિપે");
    namesMap.put("SV", "એલ સેલ્વાડોર");
    namesMap.put("SX", "સિંટ માર્ટેન");
    namesMap.put("SY", "સીરિયા");
    namesMap.put("SZ", "સ્વાઝિલેન્ડ");
    namesMap.put("TA", "ટ્રિસ્ટન ડે કુના");
    namesMap.put("TC", "ટર્ક્સ એન્ડ કૈકોસ આઇલેન્ડ્સ");
    namesMap.put("TD", "ચાડ");
    namesMap.put("TF", "ફ્રેંચ સદર્ન ટેરિટરીઝ");
    namesMap.put("TG", "ટોગો");
    namesMap.put("TH", "થાઇલેંડ");
    namesMap.put("TJ", "તાજીકિસ્તાન");
    namesMap.put("TK", "ટોકેલાઉ");
    namesMap.put("TL", "પૂર્વ તિમોર");
    namesMap.put("TM", "તુર્ક્મનિસ્તાન");
    namesMap.put("TN", "ટ્યુનિશિયા");
    namesMap.put("TO", "ટોંગા");
    namesMap.put("TR", "તુર્કસ્તાન");
    namesMap.put("TT", "ત્રિનિડાડ અને ટોબેગો");
    namesMap.put("TV", "તુવાલુ");
    namesMap.put("TW", "તાઇવાન");
    namesMap.put("TZ", "તાંઝાનિયા");
    namesMap.put("UA", "યૂક્રેન");
    namesMap.put("UG", "યુગાંડા");
    namesMap.put("UM", "સંયુક્ત રાજ્ય આઉટલાઇંગ આયલેન્ડ્સ");
    namesMap.put("US", "સંયુકત રાજ્ય/ અમેરિકા");
    namesMap.put("UY", "ઉરુગ્વે");
    namesMap.put("UZ", "ઉઝ્બેકિસ્તાન");
    namesMap.put("VA", "વેટિકન");
    namesMap.put("VC", "સેંટ વિંસેંટ એંડ ધ ગ્રેનેડિન્સ");
    namesMap.put("VE", "વેનેઝુએલા");
    namesMap.put("VG", "બ્રિટિશ વર્જિન આઇલેન્ડ");
    namesMap.put("VI", "યુ.એસ વર્જિન આઇલેન્ડ");
    namesMap.put("VN", "વિયેતનામ");
    namesMap.put("VU", "વાનુઆતુ");
    namesMap.put("WF", "વૉલિસ એંડ ફ્યુચુના આઇલેન્ડ્સ");
    namesMap.put("WS", "સમોઆ");
    namesMap.put("XK", "કોસોવો");
    namesMap.put("YE", "યેમેન");
    namesMap.put("YT", "મેયોટ");
    namesMap.put("ZA", "દક્ષિણ આફ્રિકા");
    namesMap.put("ZM", "ઝામ્બિયા");
    namesMap.put("ZW", "ઝિમ્બાબ્વે");
    namesMap.put("ZZ", "અજ્ઞાત પ્રદેશ");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "વિશ્વ",
        "002": "આફ્રિકા",
        "003": "ઉતર અમેરિકા",
        "005": "દક્ષિણ અમેરિકા",
        "009": "ઓશિઆનિયા",
        "011": "પશ્ચિમ આફ્રિકા",
        "013": "મધ્ય અમેરિકા",
        "014": "પૂર્વ અમેરિકા",
        "015": "ઉતરીય આફ્રિકા",
        "017": "મધ્ય આફ્રિકા",
        "018": "દક્ષિણી આફ્રિકા",
        "019": "અમેરિકાસ",
        "021": "ઉતરીય અમેરિકા",
        "029": "કેરિબિયન",
        "030": "પૂર્વી એશિયા",
        "034": "દક્ષિણી એશિયા",
        "035": "દક્ષિણ- પૂર્વ એશિયા",
        "039": "દક્ષિણી યૂરોપ",
        "053": "ઓસ્ટ્રેલિયા",
        "054": "મેલાનેશિયા",
        "057": "માઇક્રોનેશિયન રીજન",
        "061": "પોલિનેશિયા",
        "142": "એશિયા",
        "143": "મધ્ય એશિયા",
        "145": "પશ્ચિમ એશિયા",
        "150": "યૂરોપ",
        "151": "પૂર્વી યૂરોપ",
        "154": "ઉતરીય યૂરોપ",
        "155": "પશ્ચિમ યૂરોપ",
        "419": "લેટિન અમેરિકા",
        "AC": "એસેન્શન આઇલેન્ડ",
        "AD": "ઍંડોરા",
        "AE": "યુનાઇટેડ અરબ એમિરેટ્સ",
        "AF": "અફઘાનિસ્તાન",
        "AG": "એન્ટીગુઆ અને બરબુડા",
        "AI": "ઍંગ્વિલા",
        "AL": "અલ્બેનિયા",
        "AM": "આર્મેનિયા",
        "AN": "નેધરલેંડ્સ એંટિલેસ",
        "AO": "અંગોલા",
        "AQ": "એન્ટાર્કટિકા",
        "AR": "આર્જેન્ટીના",
        "AS": "અમેરીકન સમોઆ",
        "AT": "ઑસ્ટ્રિયા",
        "AU": "ઑસ્ટ્રેલિયા",
        "AW": "અરુબા",
        "AX": "એલેંડ આઇલેન્ડ્સ",
        "AZ": "અઝરબૈજાન",
        "BA": "બોસ્નિયા અને હર્ઝેગોવિના",
        "BB": "બાર્બાડોસ",
        "BD": "બાંગ્લાદેશ",
        "BE": "બેલ્જીયમ",
        "BF": "બુર્કિના ફાસો",
        "BG": "બલ્ગેરિયા",
        "BH": "બેહરીન",
        "BI": "બુરુંડી",
        "BJ": "બેનિન",
        "BL": "સેંટ બાર્થલેમી",
        "BM": "બર્મુડા",
        "BN": "બ્રુનેઇ",
        "BO": "બોલિવિયા",
        "BQ": "કેરેબિયન નેધરલેન્ડ્ઝ",
        "BR": "બ્રાઝિલ",
        "BS": "બહામાસ",
        "BT": "ભૂટાન",
        "BV": "બૌવેત આઇલેન્ડ",
        "BW": "બોત્સ્વાના",
        "BY": "બેલારુસ",
        "BZ": "બેલીઝ",
        "CA": "કેનેડા",
        "CC": "કોકોઝ આઇલેન્ડ",
        "CD": "કોંગો - કિંશાસા",
        "CF": "સેંટ્રલ આફ્રિકન રીપબ્લિક",
        "CG": "કોંગો - બ્રાઝાવિલે",
        "CH": "સ્વિટ્ઝર્લૅન્ડ",
        "CI": "આઇવરી કોસ્ટ",
        "CK": "કુક આઇલેન્ડ્સ",
        "CL": "ચિલી",
        "CM": "કૅમરૂન",
        "CN": "ચીન",
        "CO": "કોલમ્બિયા",
        "CP": "ક્લિપરટન આઇલેન્ડ",
        "CR": "કોસ્ટા રિકા",
        "CU": "ક્યુબા",
        "CV": "કૅપ વર્ડે",
        "CW": "કુરાકાઓ",
        "CX": "ક્રિસમસ આઇલેંડ",
        "CY": "સાયપ્રસ",
        "CZ": "ચેક રીપબ્લિક",
        "DE": "જર્મની",
        "DG": "ડિએગો ગારસિઆ",
        "DJ": "જીબૌટી",
        "DK": "ડેનમાર્ક",
        "DM": "ડોમિનિકા",
        "DO": "ડોમિનિકન રીપબ્લિક",
        "DZ": "અલ્જીરિયા",
        "EA": "સ્યુટા અને મેલિલા",
        "EC": "એક્વાડોર",
        "EE": "એસ્ટોનિયા",
        "EG": "ઇજિપ્ત",
        "EH": "પશ્ચિમી સહારા",
        "ER": "એરિટ્રિયા",
        "ES": "સ્પેન",
        "ET": "ઇથિઓપિયા",
        "EU": "યુરોપિયન સંઘ",
        "FI": "ફીનલેંડ",
        "FJ": "ફીજી",
        "FK": "ફૉકલૅંડ આઇલૅંડ્સ",
        "FM": "માઇક્રોનેશિયા",
        "FO": "ફૅરો આઇલેન્ડ્સ",
        "FR": "ફ્રાંસ",
        "GA": "ગેબન",
        "GB": "યુનાઇટેડ કિંગડમ",
        "GD": "ગ્રેનેડા",
        "GE": "જ્યોર્જીયા",
        "GF": "ફ્રેંચ ગયાના",
        "GG": "ગ્વેર્નસે",
        "GH": "ઘાના",
        "GI": "જીબ્રાલ્ટર",
        "GL": "ગ્રીનલેન્ડ",
        "GM": "ગેમ્બિયા",
        "GN": "ગિની",
        "GP": "ગ્વાડેલોપ",
        "GQ": "ઇક્વેટોરિયલ ગિની",
        "GR": "ગ્રીસ",
        "GS": "દક્ષિણ જ્યોર્જીયા અને દક્ષિણ સેન્ડવિચ આઇલેન્ડ",
        "GT": "ગ્વાટેમાલા",
        "GU": "ગ્વામ",
        "GW": "ગિની-બિસાઉ",
        "GY": "ગયાના",
        "HK": "હોંગકોંગ સાર ચીન",
        "HM": "હર્ડ આઇલૅંડ એંડ મેકડોનાલ્ડ આઇલૅંડ્સ",
        "HN": "હોન્ડુરસ",
        "HR": "ક્રોએશિયા",
        "HT": "હૈતિ",
        "HU": "હંગેરી",
        "IC": "કૅનેરી આઇલેન્ડ્સ",
        "ID": "ઇન્ડોનેશિયા",
        "IE": "આયર્લેંડ",
        "IL": "ઇઝરાઇલ",
        "IM": "ઇસ્લે ઓફ મૅન",
        "IN": "ભારત",
        "IO": "બ્રિટિશ ઇન્ડિયન ઓશન ટેરિટરી",
        "IQ": "ઇરાક",
        "IR": "ઈરાન",
        "IS": "આઇસલેન્ડ",
        "IT": "ઇટાલી",
        "JE": "જર્સી",
        "JM": "જમૈકા",
        "JO": "જોર્ડન",
        "JP": "જાપાન",
        "KE": "કેન્યા",
        "KG": "કિર્ગિઝ્સ્તાન",
        "KH": "કંબોડિયા",
        "KI": "કિરિબાટી",
        "KM": "કોમોરસ",
        "KN": "સેંટ કિટ્સ એંડ નેવિસ",
        "KP": "ઉત્તર કોરિયા",
        "KR": "દક્ષિણ કોરિયા",
        "KW": "કુવૈત",
        "KY": "કેયમેન આઇલૅંડ્સ",
        "KZ": "કઝાકિસ્તાન",
        "LA": "લાઓસ",
        "LB": "લેબનોન",
        "LC": "સેંટ લુસિયા",
        "LI": "લૈચટેંસ્ટેઇન",
        "LK": "શ્રીલંકા",
        "LR": "લાઇબેરિયા",
        "LS": "લેસોથો",
        "LT": "લિથુઆનિયા",
        "LU": "લક્ઝમબર્ગ",
        "LV": "લાત્વિયા",
        "LY": "લિબિયા",
        "MA": "મોરોક્કો",
        "MC": "મોનાકો",
        "MD": "મોલડોવા",
        "ME": "મૉન્ટેંનેગ્રો",
        "MF": "સેંટ માર્ટિન",
        "MG": "મેડાગાસ્કર",
        "MH": "માર્શલ આઇલેન્ડ્સ",
        "MK": "મેસેડોનિયા",
        "ML": "માલી",
        "MM": "મ્યાંમાર",
        "MN": "મંગોલિયા",
        "MO": "મકાઉ SAR ચીન",
        "MP": "ઉતરીય મારિયાના આઇલેન્ડ્સ",
        "MQ": "માર્ટીનીક",
        "MR": "મૌરિટાનિયા",
        "MS": "મોંટસેરાત",
        "MT": "માલ્ટા",
        "MU": "મોરિશિયસ",
        "MV": "માલદિવ્સ",
        "MW": "માલાવી",
        "MX": "મેક્સિકો",
        "MY": "મલેશિયા",
        "MZ": "મોઝામ્બિક",
        "NA": "નામિબિયા",
        "NC": "ન્યુ સેલેડોનિયા",
        "NE": "નાઇજર",
        "NF": "નોરફૉક આઇલેન્ડ",
        "NG": "નાઇજીરીયા",
        "NI": "નિકારાગુઆ",
        "NL": "નેધરલેન્ડ",
        "NO": "નૉર્વે",
        "NP": "નેપાળ",
        "NR": "નૌરુ",
        "NU": "નીયુ",
        "NZ": "ન્યુઝીલેન્ડ",
        "OM": "ઓમાન",
        "PA": "પનામા",
        "PE": "પેરુ",
        "PF": "ફ્રેંચ પોલિનેશિયા",
        "PG": "પાપુઆ ન્યૂ ગિની",
        "PH": "ફિલિપિન્સ",
        "PK": "પાકિસ્તાન",
        "PL": "પોલેંડ",
        "PM": "સેંટ પીએરે એન્ડ મિકીલોન",
        "PN": "પીટકૈર્ન",
        "PR": "પ્યુઅર્ટો રિકો",
        "PS": "પેલેસ્ટિનિયન ટેરિટરી",
        "PT": "પોર્ટુગલ",
        "PW": "પલાઉ",
        "PY": "પેરાગ્વે",
        "QA": "કતાર",
        "QO": "આઉટલાયિંગ ઓશનિયા",
        "RE": "રીયુનિયન",
        "RO": "રોમાનિયા",
        "RS": "સર્બિયા",
        "RU": "રશિયન ફેડરેશન",
        "RW": "રવાંડા",
        "SA": "સાઉદી અરેબિયા",
        "SB": "સોલોમન આઇલેન્ડ",
        "SC": "શેશેલ્સ",
        "SD": "સુદાન",
        "SE": "સ્વીડન",
        "SG": "સિંગાપુર",
        "SH": "સેંટ હેલેના",
        "SI": "સ્લોવેનિયા",
        "SJ": "સ્વાલબર્ડ એંડ જેન મેયન",
        "SK": "સ્લોવેકિયા",
        "SL": "સીએરા લેઓન",
        "SM": "સૅન મેરિનો",
        "SN": "સેનેગલ",
        "SO": "સોમાલિયા",
        "SR": "સુરીનામ",
        "SS": "દક્ષિણ સુદાન",
        "ST": "સાઓ ટૉમ અને પ્રિંસિપે",
        "SV": "એલ સેલ્વાડોર",
        "SX": "સિંટ માર્ટેન",
        "SY": "સીરિયા",
        "SZ": "સ્વાઝિલેન્ડ",
        "TA": "ટ્રિસ્ટન ડે કુના",
        "TC": "ટર્ક્સ એન્ડ કૈકોસ આઇલેન્ડ્સ",
        "TD": "ચાડ",
        "TF": "ફ્રેંચ સદર્ન ટેરિટરીઝ",
        "TG": "ટોગો",
        "TH": "થાઇલેંડ",
        "TJ": "તાજીકિસ્તાન",
        "TK": "ટોકેલાઉ",
        "TL": "પૂર્વ તિમોર",
        "TM": "તુર્ક્મનિસ્તાન",
        "TN": "ટ્યુનિશિયા",
        "TO": "ટોંગા",
        "TR": "તુર્કસ્તાન",
        "TT": "ત્રિનિડાડ અને ટોબેગો",
        "TV": "તુવાલુ",
        "TW": "તાઇવાન",
        "TZ": "તાંઝાનિયા",
        "UA": "યૂક્રેન",
        "UG": "યુગાંડા",
        "UM": "સંયુક્ત રાજ્ય આઉટલાઇંગ આયલેન્ડ્સ",
        "US": "સંયુકત રાજ્ય/ અમેરિકા",
        "UY": "ઉરુગ્વે",
        "UZ": "ઉઝ્બેકિસ્તાન",
        "VA": "વેટિકન",
        "VC": "સેંટ વિંસેંટ એંડ ધ ગ્રેનેડિન્સ",
        "VE": "વેનેઝુએલા",
        "VG": "બ્રિટિશ વર્જિન આઇલેન્ડ",
        "VI": "યુ.એસ વર્જિન આઇલેન્ડ",
        "VN": "વિયેતનામ",
        "VU": "વાનુઆતુ",
        "WF": "વૉલિસ એંડ ફ્યુચુના આઇલેન્ડ્સ",
        "WS": "સમોઆ",
        "XK": "કોસોવો",
        "YE": "યેમેન",
        "YT": "મેયોટ",
        "ZA": "દક્ષિણ આફ્રિકા",
        "ZM": "ઝામ્બિયા",
        "ZW": "ઝિમ્બાબ્વે",
        "ZZ": "અજ્ઞાત પ્રદેશ"
    };
  }-*/;
}
