/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteAuthTokenRequest
extends BmcRequest<Void> {
    private String userId;
    private String authTokenId;
    private String ifMatch;

    @ConstructorProperties(value={"userId", "authTokenId", "ifMatch"})
    DeleteAuthTokenRequest(String userId, String authTokenId, String ifMatch) {
        this.userId = userId;
        this.authTokenId = authTokenId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().userId(this.userId).authTokenId(this.authTokenId).ifMatch(this.ifMatch);
    }

    public String toString() {
        return "DeleteAuthTokenRequest(super=" + super.toString() + ", userId=" + this.getUserId() + ", authTokenId=" + this.getAuthTokenId() + ", ifMatch=" + this.getIfMatch() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteAuthTokenRequest)) {
            return false;
        }
        DeleteAuthTokenRequest other = (DeleteAuthTokenRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$authTokenId = this.getAuthTokenId();
        String other$authTokenId = other.getAuthTokenId();
        if (this$authTokenId == null ? other$authTokenId != null : !this$authTokenId.equals(other$authTokenId)) {
            return false;
        }
        String this$ifMatch = this.getIfMatch();
        String other$ifMatch = other.getIfMatch();
        return !(this$ifMatch == null ? other$ifMatch != null : !this$ifMatch.equals(other$ifMatch));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeleteAuthTokenRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $authTokenId = this.getAuthTokenId();
        result = result * 59 + ($authTokenId == null ? 43 : $authTokenId.hashCode());
        String $ifMatch = this.getIfMatch();
        result = result * 59 + ($ifMatch == null ? 43 : $ifMatch.hashCode());
        return result;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getAuthTokenId() {
        return this.authTokenId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteAuthTokenRequest, Void> {
        private String userId;
        private String authTokenId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteAuthTokenRequest o) {
            this.userId(o.getUserId());
            this.authTokenId(o.getAuthTokenId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteAuthTokenRequest build() {
            DeleteAuthTokenRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder authTokenId(String authTokenId) {
            this.authTokenId = authTokenId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteAuthTokenRequest buildWithoutInvocationCallback() {
            return new DeleteAuthTokenRequest(this.userId, this.authTokenId, this.ifMatch);
        }

        public String toString() {
            return "DeleteAuthTokenRequest.Builder(userId=" + this.userId + ", authTokenId=" + this.authTokenId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

