/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.StepRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAStep;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.SmartSteppingFilter;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.modules.debugger.jpda.ExpressionPool;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.SourcePath;
import org.netbeans.modules.debugger.jpda.actions.CompoundSmartSteppingListener;
import org.netbeans.modules.debugger.jpda.actions.SmartSteppingFilterImpl;
import org.netbeans.modules.debugger.jpda.impl.StepUtils;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidRequestStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocatableWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MethodWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MirrorWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StackFrameWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeComponentWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.EventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.LocatableEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.BreakpointRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.StepRequestWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.debugger.jpda.SmartSteppingCallback;
import org.openide.util.Exceptions;

public class JPDAStepImpl
extends JPDAStep
implements Executor {
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.step");
    private static final String INIT = "<init>";
    private EditorContext.Operation[] currentOperations;
    private EditorContext.Operation lastOperation;
    private ExpressionPool.Interval currentExpInterval;
    private MethodExitBreakpointListener lastMethodExitBreakpointListener;
    private Set<BreakpointRequest> operationBreakpoints;
    private StepRequest boundaryStepRequest;
    private final Set<EventRequest> requestsToCancel = new HashSet<EventRequest>();
    private volatile StepPatternDepth stepPatternDepth;
    private boolean ignoreStepFilters = false;
    private boolean steppingFromFilteredLocation;
    private boolean steppingFromCompoundFilteredLocation;
    private boolean isInBoxingUnboxingLocation;
    private boolean wasInBoxingUnboxingLocation;
    private StopHereCheck stopHereCheck;
    private final Properties p;
    private final Session session;
    private SmartSteppingFilterImpl smartSteppingFilter;
    private CompoundSmartSteppingListener compoundSmartSteppingListener;

    public JPDAStepImpl(JPDADebugger debugger, Session session, int size, int depth) {
        super(debugger, size, depth);
        this.session = session;
        this.p = Properties.getDefault().getProperties("debugger.options.JPDA");
    }

    private String[] applyExclusionPatterns(StepRequest stepRequest) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        String[] exclusionPatterns;
        String[] stepFilters = this.getSteppingFilters();
        if (this.ignoreStepFilters || this.steppingFromFilteredLocation) {
            exclusionPatterns = stepFilters;
        } else {
            exclusionPatterns = this.debugger.getSmartSteppingFilter().getExclusionPatterns();
            if (stepFilters != null) {
                int epl = exclusionPatterns.length;
                exclusionPatterns = Arrays.copyOf(exclusionPatterns, epl + stepFilters.length);
                System.arraycopy(stepFilters, 0, exclusionPatterns, epl, stepFilters.length);
            }
        }
        if (exclusionPatterns != null) {
            for (int i = 0; i < exclusionPatterns.length; ++i) {
                StepRequestWrapper.addClassExclusionFilter(stepRequest, exclusionPatterns[i]);
                logger.finer("   add pattern: " + exclusionPatterns[i]);
            }
        } else {
            exclusionPatterns = new String[]{};
        }
        return exclusionPatterns;
    }

    private String[] getCurrentExclusionPatterns() {
        String[] exclusionPatterns = this.debugger.getSmartSteppingFilter().getExclusionPatterns();
        String[] stepFilters = this.getSteppingFilters();
        if (stepFilters != null) {
            int epl = exclusionPatterns.length;
            exclusionPatterns = Arrays.copyOf(exclusionPatterns, epl + stepFilters.length);
            System.arraycopy(stepFilters, 0, exclusionPatterns, epl, stepFilters.length);
        }
        return exclusionPatterns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStep(JPDAThread tr) {
        boolean[] setStoppedStateNoContinue;
        JPDAThreadImpl trImpl;
        JPDADebuggerImpl debuggerImpl;
        block24: {
            debuggerImpl = (JPDADebuggerImpl)this.debugger;
            trImpl = (JPDAThreadImpl)tr;
            VirtualMachine vm = debuggerImpl.getVirtualMachine();
            if (vm == null) {
                return;
            }
            SourcePath sourcePath = ((JPDADebuggerImpl)this.debugger).getEngineContext();
            setStoppedStateNoContinue = new boolean[]{false};
            int suspendPolicy = debuggerImpl.getSuspend();
            Lock lock = suspendPolicy == 1 ? trImpl.accessLock.writeLock() : debuggerImpl.accessLock.writeLock();
            lock.lock();
            try {
                ((JPDAThreadImpl)tr).waitUntilMethodInvokeDone();
                EventRequestManager erm = VirtualMachineWrapper.eventRequestManager(vm);
                List<StepRequest> stepRequests = EventRequestManagerWrapper.stepRequests(erm);
                try {
                    EventRequestManagerWrapper.deleteEventRequests(erm, stepRequests);
                }
                catch (InvalidRequestStateExceptionWrapper irex) {
                    ArrayList<StepRequest> assureDeletedAllstepRequests = new ArrayList<StepRequest>(stepRequests);
                    for (StepRequest sr : assureDeletedAllstepRequests) {
                        try {
                            EventRequestManagerWrapper.deleteEventRequest(erm, sr);
                        }
                        catch (InvalidRequestStateExceptionWrapper invalidRequestStateExceptionWrapper) {}
                    }
                }
                for (StepRequest stepRequest : stepRequests) {
                    debuggerImpl.getOperator().unregister(stepRequest);
                }
                this.steppingFromFilteredLocation = !((SmartSteppingFilterImpl)debuggerImpl.getSmartSteppingFilter()).stopHere(tr.getClassName());
                this.steppingFromCompoundFilteredLocation = !debuggerImpl.stopHere(tr).isStop();
                int size = this.getSize();
                boolean stepAdded = false;
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Step " + (size == 10 ? "operation" : "line") + " " + (this.getDepth() == 1 ? "into" : (this.getDepth() == 2 ? "over" : "out")) + " in thread " + tr.getName() + ", at: " + tr.getClassName() + "." + tr.getMethodName() + ":" + tr.getLineNumber(null));
                }
                if (size == 10 && !(stepAdded = this.addOperationStep(trImpl, false, sourcePath, setStoppedStateNoContinue))) {
                    size = -2;
                    logger.log(Level.FINE, "Operation step changed to line step");
                }
                logger.fine("  Operation step added = " + stepAdded);
                if (stepAdded) break block24;
                StepRequest stepRequest = EventRequestManagerWrapper.createStepRequest(VirtualMachineWrapper.eventRequestManager(vm), trImpl.getThreadReference(), size, this.getDepth());
                StepUtils.markOriginalStepDepth(stepRequest, trImpl.getThreadReference());
                String[] exclusionPatterns = this.applyExclusionPatterns(stepRequest);
                debuggerImpl.getOperator().register(stepRequest, this);
                EventRequestWrapper.setSuspendPolicy(stepRequest, this.debugger.getSuspend());
                boolean stepThrough = this.isStepThroughFilters();
                this.stepPatternDepth = new StepPatternDepth(tr.getStackDepth(), exclusionPatterns, stepThrough);
                logger.fine("Set stepPatternDepth to " + this.stepPatternDepth);
                try {
                    EventRequestWrapper.enable(stepRequest);
                    trImpl.setInStep(true, stepRequest);
                    this.requestsToCancel.add(stepRequest);
                }
                catch (IllegalThreadStateException itsex) {
                    debuggerImpl.getOperator().unregister(stepRequest);
                    stepRequest = null;
                }
                catch (ObjectCollectedExceptionWrapper ex) {
                    debuggerImpl.getOperator().unregister(stepRequest);
                    stepRequest = null;
                }
                catch (InvalidRequestStateExceptionWrapper ex) {
                    debuggerImpl.getOperator().unregister(stepRequest);
                    stepRequest = null;
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Step request submitted: " + stepRequest + ", size = " + size + ", depth = " + this.getDepth());
                }
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            }
            finally {
                lock.unlock();
            }
        }
        if (setStoppedStateNoContinue[0]) {
            debuggerImpl.setStoppedStateNoContinue(trImpl.getThreadReference());
        }
    }

    private boolean addOperationStep(JPDAThreadImpl tr, boolean lineStepExec, SourcePath sourcePath, boolean[] setStoppedStateNoContinue) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        boolean isBSR;
        ExpressionPool.OperationLocation[] nextOperationLocations;
        String methodName;
        EditorContext.Operation currentOp;
        StackFrame sf;
        ThreadReference trRef = tr.getThreadReference();
        try {
            sf = ThreadReferenceWrapper.frame(trRef, 0);
        }
        catch (IncompatibleThreadStateException itsex) {
            return false;
        }
        catch (IllegalThreadStateExceptionWrapper itsex) {
            return false;
        }
        catch (IndexOutOfBoundsException ioobex) {
            return false;
        }
        Location loc = LocatableWrapper.location(sf);
        Session currentSession = DebuggerManager.getDebuggerManager().getCurrentSession();
        String language = currentSession == null ? null : currentSession.getCurrentLanguage();
        String url = sourcePath.getURL(loc, language);
        ExpressionPool exprPool = ((JPDADebuggerImpl)this.debugger).getExpressionPool();
        ExpressionPool.Expression expr = exprPool.getExpressionAt(loc, url);
        if (expr == null) {
            return false;
        }
        EditorContext.Operation[] ops = expr.getOperations();
        int opIndex = -1;
        int codeIndex = (int)LocationWrapper.codeIndex(loc);
        if (codeIndex <= ops[0].getBytecodeIndex()) {
            if (!lineStepExec) {
                tr.clearLastOperations();
            }
            if (!ops[0].equals((Object)tr.getCurrentOperation()) && (opIndex = expr.findNextOperationIndex(codeIndex - 1)) >= 0 && ops[opIndex].getBytecodeIndex() == codeIndex) {
                tr.setCurrentOperation(ops[opIndex]);
                if (lineStepExec) {
                    return false;
                }
                if (!this.getHidden()) {
                    setStoppedStateNoContinue[0] = true;
                }
                return true;
            }
        }
        if ((currentOp = tr.getCurrentOperation()) != null) {
            EditorContext.Operation theLastOperation = null;
            List<EditorContext.Operation> lastOperations = tr.getLastOperations();
            if (lastOperations != null && lastOperations.size() > 0) {
                theLastOperation = lastOperations.get(lastOperations.size() - 1);
            }
            if (theLastOperation == currentOp) {
                for (EditorContext.Operation op : ops) {
                    if (op.getBytecodeIndex() != codeIndex) continue;
                    tr.setCurrentOperation(op);
                    if (!this.getHidden()) {
                        setStoppedStateNoContinue[0] = true;
                    }
                    return true;
                }
            }
        }
        this.lastOperation = currentOp;
        VirtualMachine vm = MirrorWrapper.virtualMachine(loc);
        if (this.lastOperation != null && (methodName = this.lastOperation.getMethodName()) != null && !INIT.equals(methodName) && vm.canGetMethodReturnValues()) {
            MethodBreakpoint mb = MethodBreakpoint.create((String)this.lastOperation.getMethodClassType(), (String)methodName);
            mb.setClassFilters(JPDAStepImpl.createClassFilters(vm, this.lastOperation.getMethodClassType(), methodName));
            mb.setThreadFilters(this.debugger, new JPDAThread[]{tr});
            mb.setBreakpointType(2);
            mb.setHidden(true);
            mb.setSuspend(0);
            this.lastMethodExitBreakpointListener = new MethodExitBreakpointListener(mb);
            mb.addJPDABreakpointListener((JPDABreakpointListener)this.lastMethodExitBreakpointListener);
            mb.setSession(this.debugger);
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)mb);
        }
        tr.holdLastOperations(true);
        if (opIndex < 0) {
            nextOperationLocations = expr.findNextOperationLocations(codeIndex);
        } else {
            Location[] locations = expr.getLocations();
            ExpressionPool.OperationLocation[] opLoc = new ExpressionPool.OperationLocation[ops.length - opIndex];
            int opLocIndex = 0;
            for (int i = opIndex; i < opLoc.length; ++i) {
                if (i != opIndex && locations[i].codeIndex() <= locations[opIndex].codeIndex()) continue;
                opLoc[opLocIndex++] = new ExpressionPool.OperationLocation(ops[i], locations[i], i);
            }
            if (opLocIndex == opLoc.length) {
                nextOperationLocations = opLoc;
            } else {
                nextOperationLocations = new ExpressionPool.OperationLocation[opLocIndex];
                System.arraycopy(opLoc, 0, nextOperationLocations, 0, opLocIndex);
            }
        }
        boolean isNextOperationFromDifferentExpression = false;
        if (nextOperationLocations != null) {
            this.operationBreakpoints = new HashSet<BreakpointRequest>();
            for (int ni = 0; ni < nextOperationLocations.length; ++ni) {
                Location nloc = nextOperationLocations[ni].getLocation();
                if (nextOperationLocations[ni].getIndex() < 0) {
                    isNextOperationFromDifferentExpression = true;
                    EditorContext.Operation[] newOps = new EditorContext.Operation[ops.length + 1];
                    System.arraycopy(ops, 0, newOps, 0, ops.length);
                    newOps[ops.length] = nextOperationLocations[ni].getOperation();
                    ops = newOps;
                }
                BreakpointRequest brReq = EventRequestManagerWrapper.createBreakpointRequest(VirtualMachineWrapper.eventRequestManager(vm), nloc);
                this.operationBreakpoints.add(brReq);
                ((JPDADebuggerImpl)this.debugger).getOperator().register(brReq, this);
                EventRequestWrapper.setSuspendPolicy(brReq, this.debugger.getSuspend());
                BreakpointRequestWrapper.addThreadFilter(brReq, trRef);
                EventRequestWrapper.putProperty(brReq, "thread", trRef);
                try {
                    EventRequestWrapper.enable(brReq);
                }
                catch (InvalidRequestStateExceptionWrapper ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                tr.setInStep(true, brReq);
                this.requestsToCancel.add(brReq);
            }
        } else if (lineStepExec) {
            return false;
        }
        if (!(isBSR = this.setUpBoundaryStepRequest(VirtualMachineWrapper.eventRequestManager(vm), trRef, isNextOperationFromDifferentExpression))) {
            return false;
        }
        this.currentOperations = ops;
        this.currentExpInterval = expr.getInterval();
        return true;
    }

    private boolean setUpBoundaryStepRequest(EventRequestManager erm, ThreadReference trRef, boolean isNextOperationFromDifferentExpression) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        this.boundaryStepRequest = EventRequestManagerWrapper.createStepRequest(erm, trRef, -2, 2);
        StepUtils.markOriginalStepDepth(this.boundaryStepRequest, trRef);
        if (isNextOperationFromDifferentExpression) {
            EventRequestWrapper.addCountFilter(this.boundaryStepRequest, 2);
        } else {
            EventRequestWrapper.addCountFilter(this.boundaryStepRequest, 1);
        }
        ((JPDADebuggerImpl)this.debugger).getOperator().register(this.boundaryStepRequest, this);
        EventRequestWrapper.setSuspendPolicy(this.boundaryStepRequest, this.debugger.getSuspend());
        try {
            EventRequestWrapper.enable(this.boundaryStepRequest);
            this.requestsToCancel.add(this.boundaryStepRequest);
        }
        catch (IllegalThreadStateException itsex) {
            ((JPDADebuggerImpl)this.debugger).getOperator().unregister(this.boundaryStepRequest);
            this.boundaryStepRequest = null;
            return false;
        }
        catch (InvalidRequestStateExceptionWrapper ex) {
            Exceptions.printStackTrace((Throwable)ex);
            ((JPDADebuggerImpl)this.debugger).getOperator().unregister(this.boundaryStepRequest);
            this.boundaryStepRequest = null;
            return false;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean exec(Event event) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void removed(EventRequest eventRequest) {
        block14: {
            JPDADebuggerImpl debuggerImpl;
            VirtualMachine vm;
            try {
                this.stepDone(eventRequest);
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                return;
            }
            if (this.lastMethodExitBreakpointListener != null) {
                this.lastMethodExitBreakpointListener.destroy();
                this.lastMethodExitBreakpointListener = null;
            }
            if ((vm = (debuggerImpl = (JPDADebuggerImpl)this.debugger).getVirtualMachine()) == null) {
                return;
            }
            try {
                EventRequestManager erm = VirtualMachineWrapper.eventRequestManager(vm);
                if (this.operationBreakpoints != null) {
                    for (BreakpointRequest br : this.operationBreakpoints) {
                        try {
                            EventRequestManagerWrapper.deleteEventRequest(erm, br);
                        }
                        catch (InvalidRequestStateExceptionWrapper ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        debuggerImpl.getOperator().unregister(br);
                    }
                    this.operationBreakpoints = null;
                }
                if (this.boundaryStepRequest == null) break block14;
                try {
                    EventRequestManagerWrapper.deleteEventRequest(erm, this.boundaryStepRequest);
                }
                catch (InvalidRequestStateExceptionWrapper ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                debuggerImpl.getOperator().unregister(this.boundaryStepRequest);
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                // empty catch block
            }
        }
    }

    private void stepDone(EventRequest er) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        JPDAThreadImpl t;
        if (er instanceof StepRequest) {
            StepRequest sr = (StepRequest)er;
            t = ((JPDADebuggerImpl)this.debugger).getThread(StepRequestWrapper.thread(sr));
        } else {
            ThreadReference tr = (ThreadReference)EventRequestWrapper.getProperty(er, "thread");
            t = tr != null ? ((JPDADebuggerImpl)this.debugger).getThread(tr) : null;
        }
        if (t != null) {
            t.setInStep(false, null);
        }
    }

    private static String[] createClassFilters(VirtualMachine vm, String className, String methodName) throws VMDisconnectedExceptionWrapper {
        return JPDAStepImpl.createClassFilters(vm, className, methodName, new ArrayList<String>()).toArray(new String[0]);
    }

    private static List<String> createClassFilters(VirtualMachine vm, String className, String methodName, List<String> filters) throws VMDisconnectedExceptionWrapper {
        List<ReferenceType> classTypes = VirtualMachineWrapper.classesByName0(vm, className);
        for (ReferenceType type : classTypes) {
            try {
                ClassType clazz;
                ClassType superClass;
                List<Method> methods;
                try {
                    methods = ReferenceTypeWrapper.methodsByName0(type, methodName);
                }
                catch (ClassNotPreparedExceptionWrapper ex) {
                    continue;
                }
                boolean hasNonStatic = methods.isEmpty();
                for (Method method : methods) {
                    if (!filters.contains(ReferenceTypeWrapper.name(type))) {
                        filters.add(ReferenceTypeWrapper.name(type));
                    }
                    if (TypeComponentWrapper.isStatic(method)) continue;
                    hasNonStatic = true;
                }
                if (!hasNonStatic || !(type instanceof ClassType) || (superClass = ClassTypeWrapper.superclass(clazz = (ClassType)type)) == null) continue;
                JPDAStepImpl.createClassFilters(vm, ReferenceTypeWrapper.name(superClass), methodName, filters);
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {}
        }
        return filters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean shouldNotStopHere(StepEvent event, int stepDepthDiff) {
        JPDADebuggerImpl debuggerImpl = (JPDADebuggerImpl)this.debugger;
        boolean useStepFilters = this.p.getBoolean("UseStepFilters", true);
        boolean stepThrough = this.isStepThroughFilters();
        try {
            ThreadReference tr = LocatableEventWrapper.thread(event);
            JPDAThreadImpl t = debuggerImpl.getThread(tr);
            t.accessLock.readLock().lock();
            try {
                int ss;
                int doStepSize = this.getSize() == -1 ? -1 : -2;
                try {
                    if (!ThreadReferenceWrapper.isSuspended(tr)) {
                        boolean bl = false;
                        return bl;
                    }
                }
                catch (IncompatibleThreadStateException | InvalidStackFrameExceptionWrapper e) {
                    Exceptions.printStackTrace((Throwable)e);
                    boolean m2 = false;
                    return m2;
                }
                catch (IllegalThreadStateExceptionWrapper | ObjectCollectedExceptionWrapper e) {
                    boolean m2 = false;
                    return m2;
                }
                Location loc = StackFrameWrapper.location(ThreadReferenceWrapper.frame(tr, 0));
                Method m2 = LocationWrapper.method(loc);
                boolean doStepAgain = false;
                int doStepDepth = this.getDepth();
                boolean filterSyntheticMethods = useStepFilters && this.p.getBoolean("FilterSyntheticMethods", true);
                boolean filterStaticInitializers = useStepFilters && this.p.getBoolean("FilterStaticInitializers", false);
                boolean filterConstructors = useStepFilters && this.p.getBoolean("FilterConstructors", false);
                int syntheticStep = JPDAStepImpl.isSyntheticMethod(m2, loc);
                if (filterSyntheticMethods && syntheticStep != 0) {
                    doStepAgain = true;
                    if (syntheticStep > 0) {
                        doStepDepth = syntheticStep;
                    }
                }
                if (filterStaticInitializers && MethodWrapper.isStaticInitializer(m2) || filterConstructors && MethodWrapper.isConstructor(m2)) {
                    doStepAgain = true;
                    doStepDepth = 3;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Method" + m2 + " is a static initializer, or constructor - will step out.");
                    }
                }
                if (!doStepAgain && (stepDepthDiff > 1 || this.wasInBoxingUnboxingLocation) && (doStepAgain = this.checkBoxingUnboxingMethods(loc, m2))) {
                    this.isInBoxingUnboxingLocation = true;
                }
                if (useStepFilters && !this.ignoreStepFilters && !doStepAgain) {
                    SmartSteppingCallback.StopOrStep stop = this.steppingFromCompoundFilteredLocation ? SmartSteppingCallback.StopOrStep.stop() : debuggerImpl.stopHere(t);
                    if (stop.isStop() && !this.steppingFromFilteredLocation) {
                        String[] exclusionPatterns = this.getCurrentExclusionPatterns();
                        String className = ReferenceTypeWrapper.name(LocationWrapper.declaringType(loc));
                        for (String pattern : exclusionPatterns) {
                            if (!JPDAStepImpl.match(className, pattern)) continue;
                            stop = SmartSteppingCallback.StopOrStep.skip();
                            break;
                        }
                    }
                    if (!stop.isStop()) {
                        doStepAgain = true;
                        int sd = stop.getStepDepth();
                        if (sd != 0) {
                            doStepDepth = sd;
                        } else {
                            EventRequest request = EventWrapper.request(event);
                            if (request instanceof StepRequest) {
                                doStepDepth = ((StepRequest)request).depth();
                            }
                        }
                        int ss2 = stop.getStepSize();
                        if (ss2 != 0) {
                            doStepSize = ss2;
                        }
                    }
                }
                if (this.stopHereCheck != null) {
                    boolean bl = doStepAgain = !this.stopHereCheck.stopHere(!doStepAgain);
                }
                if (doStepAgain) {
                    VirtualMachine vm = debuggerImpl.getVirtualMachine();
                    if (vm == null) {
                        boolean sd = false;
                        return sd;
                    }
                    StepRequest stepRequest = EventRequestManagerWrapper.createStepRequest(VirtualMachineWrapper.eventRequestManager(vm), tr, doStepSize, doStepDepth);
                    StepUtils.markOriginalStepDepth(stepRequest, tr);
                    String[] exclusionPatterns = this.applyExclusionPatterns(stepRequest);
                    debuggerImpl.getOperator().register(stepRequest, this);
                    EventRequestWrapper.setSuspendPolicy(stepRequest, this.debugger.getSuspend());
                    this.stepPatternDepth = new StepPatternDepth(t.getStackDepth(), exclusionPatterns, stepThrough);
                    logger.fine("Set stepPatternDepth to " + this.stepPatternDepth);
                    try {
                        EventRequestWrapper.enable(stepRequest);
                        this.requestsToCancel.add(stepRequest);
                    }
                    catch (IllegalThreadStateException itsex) {
                        debuggerImpl.getOperator().unregister(stepRequest);
                    }
                    catch (InvalidRequestStateExceptionWrapper irse) {
                        Exceptions.printStackTrace((Throwable)irse);
                    }
                    boolean bl = true;
                    return bl;
                }
                SmartSteppingCallback.StopOrStep stop = debuggerImpl.stopHere(t);
                if (stop.isStop()) {
                    boolean m2 = false;
                    return m2;
                }
                VirtualMachine vm = debuggerImpl.getVirtualMachine();
                if (vm == null) {
                    doStepAgain = false;
                    return doStepAgain;
                }
                int depth = stop.getStepDepth();
                if (depth == 0) {
                    Map properties = (Map)this.session.lookupFirst(null, Map.class);
                    boolean smartSteppingStepOut = properties != null && properties.containsKey("SS_ACTION_STEPOUT");
                    depth = !stepThrough || smartSteppingStepOut ? 3 : ((StepRequest)event.request()).depth();
                }
                if ((ss = stop.getStepSize()) != 0) {
                    doStepSize = ss;
                }
                StepRequest stepRequest = EventRequestManagerWrapper.createStepRequest(VirtualMachineWrapper.eventRequestManager(vm), tr, doStepSize, depth);
                StepUtils.markOriginalStepDepth(stepRequest, tr);
                if (logger.isLoggable(Level.FINE)) {
                    try {
                        logger.fine("Can not stop at " + ThreadReferenceWrapper.frame(tr, 0) + ", smart-stepping. Submitting step = " + stepRequest + "; depth = " + depth);
                    }
                    catch (InternalExceptionWrapper ex) {
                        logger.throwing(this.getClass().getName(), "shouldNotStopHere", ex);
                    }
                    catch (VMDisconnectedExceptionWrapper ex) {
                        logger.throwing(this.getClass().getName(), "shouldNotStopHere", ex);
                    }
                    catch (ObjectCollectedExceptionWrapper ex) {
                        logger.throwing(this.getClass().getName(), "shouldNotStopHere", ex);
                    }
                    catch (IllegalThreadStateExceptionWrapper ex) {
                        logger.throwing(this.getClass().getName(), "shouldNotStopHere", ex);
                    }
                    catch (IncompatibleThreadStateException ex) {
                        logger.throwing(this.getClass().getName(), "shouldNotStopHere", ex);
                    }
                }
                String[] exclusionPatterns = this.applyExclusionPatterns(stepRequest);
                this.stepPatternDepth = new StepPatternDepth(t.getStackDepth(), exclusionPatterns, stepThrough);
                logger.fine("Set stepPatternDepth to " + this.stepPatternDepth);
                debuggerImpl.getOperator().register(stepRequest, this);
                EventRequestWrapper.setSuspendPolicy(stepRequest, this.debugger.getSuspend());
                try {
                    EventRequestWrapper.enable(stepRequest);
                    this.requestsToCancel.add(stepRequest);
                    return true;
                }
                catch (IllegalThreadStateException itsex) {
                    debuggerImpl.getOperator().unregister(stepRequest);
                    return true;
                }
                catch (ObjectCollectedExceptionWrapper ocex) {
                    debuggerImpl.getOperator().unregister(stepRequest);
                    return true;
                }
                catch (InvalidRequestStateExceptionWrapper irse) {
                    Exceptions.printStackTrace((Throwable)irse);
                    return true;
                }
            }
            finally {
                t.accessLock.readLock().unlock();
            }
        }
        catch (InternalExceptionWrapper e) {
            return false;
        }
        catch (VMDisconnectedExceptionWrapper e) {
            return false;
        }
    }

    private static boolean match(String name, String pattern) {
        if (pattern.startsWith("*")) {
            return name.endsWith(pattern.substring(1));
        }
        if (pattern.endsWith("*")) {
            return name.startsWith(pattern.substring(0, pattern.length() - 1));
        }
        return name.equals(pattern);
    }

    public void cancel() {
        JPDADebuggerImpl debuggerImpl = (JPDADebuggerImpl)this.debugger;
        VirtualMachine vm = debuggerImpl.getVirtualMachine();
        if (vm == null) {
            return;
        }
        try {
            EventRequestManager erm = VirtualMachineWrapper.eventRequestManager(vm);
            for (EventRequest er : this.requestsToCancel) {
                try {
                    EventRequestManagerWrapper.deleteEventRequest(erm, er);
                }
                catch (InvalidRequestStateExceptionWrapper invalidRequestStateExceptionWrapper) {
                    // empty catch block
                }
                debuggerImpl.getOperator().unregister(er);
            }
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            // empty catch block
        }
    }

    public static int isSyntheticMethod(Method m, Location loc) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        String name = TypeComponentWrapper.name(m);
        if (name.startsWith("lambda$")) {
            int lineNumber = LocationWrapper.lineNumber(loc);
            if (lineNumber == 1) {
                return 2;
            }
            return 0;
        }
        ReferenceType declaringType = LocationWrapper.declaringType(loc);
        try {
            String className = ReferenceTypeWrapper.name(declaringType);
            if (className.contains("$$Lambda$")) {
                return -1;
            }
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            // empty catch block
        }
        return TypeComponentWrapper.isSynthetic(m) ? -1 : 0;
    }

    private static CallStackFrame getTopFrame(JPDAThread thread) {
        CallStackFrame topFrame = null;
        try {
            CallStackFrame[] topFrameArr = thread.getCallStack(0, 1);
            if (topFrameArr.length > 0) {
                topFrame = topFrameArr[0];
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        return topFrame;
    }

    private SmartSteppingFilterImpl getSmartSteppingFilterImpl() {
        if (this.smartSteppingFilter == null) {
            this.smartSteppingFilter = (SmartSteppingFilterImpl)this.session.lookupFirst(null, SmartSteppingFilter.class);
        }
        return this.smartSteppingFilter;
    }

    private CompoundSmartSteppingListener getCompoundSmartSteppingListener() {
        if (this.compoundSmartSteppingListener == null) {
            this.compoundSmartSteppingListener = (CompoundSmartSteppingListener)((Object)this.session.lookupFirst(null, CompoundSmartSteppingListener.class));
        }
        return this.compoundSmartSteppingListener;
    }

    public void setIgnoreStepFilters(boolean ignoreStepFilters) {
        this.ignoreStepFilters = ignoreStepFilters;
    }

    public void setStopHereCheck(StopHereCheck stopHereCheck) {
        this.stopHereCheck = stopHereCheck;
    }

    private boolean checkBoxingUnboxingMethods(Location loc, Method m) {
        try {
            String methodName;
            String typeName;
            switch (typeName = ReferenceTypeWrapper.name(LocationWrapper.declaringType(loc))) {
                case "java.lang.Boolean": 
                case "java.lang.Byte": 
                case "java.lang.Character": 
                case "java.lang.Short": 
                case "java.lang.Integer": 
                case "java.lang.Long": 
                case "java.lang.Float": 
                case "java.lang.Double": {
                    break;
                }
                default: {
                    return false;
                }
            }
            switch (methodName = TypeComponentWrapper.name(m)) {
                case "booleanValue": 
                case "byteValue": 
                case "charValue": 
                case "shortValue": 
                case "intValue": 
                case "longValue": 
                case "floatValue": 
                case "doubleValue": 
                case "valueOf": {
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        catch (InternalExceptionWrapper | ObjectCollectedExceptionWrapper | VMDisconnectedExceptionWrapper ex) {
            return false;
        }
    }

    private static final class StepPatternDepth {
        final String[] exclusionPatterns;
        final int stackDepth;
        final boolean isStepThrough;

        StepPatternDepth(int stackDepth, String[] exclusionPatterns, boolean isStepThrough) {
            this.stackDepth = stackDepth;
            this.exclusionPatterns = exclusionPatterns;
            this.isStepThrough = isStepThrough;
        }

        private boolean isFiltered(String className) {
            for (int i = 0; i < this.exclusionPatterns.length; ++i) {
                String p = this.exclusionPatterns[i];
                if (p.startsWith("*") && className.endsWith(p.substring(1))) {
                    return true;
                }
                if (p.endsWith("*") && className.startsWith(p.substring(0, p.length() - 1))) {
                    return true;
                }
                if (!className.equals(p)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return "StepPatternDepth: " + Arrays.asList(this.exclusionPatterns) + ", stackDepth = " + this.stackDepth;
        }

        static /* synthetic */ boolean access$000(StepPatternDepth x0, String x1) {
            return x0.isFiltered(x1);
        }
    }

    public static final class MethodExitBreakpointListener
    implements JPDABreakpointListener {
        private final MethodBreakpoint mb;
        private Variable returnValue;

        public MethodExitBreakpointListener(MethodBreakpoint mb) {
            this.mb = mb;
        }

        public void breakpointReached(JPDABreakpointEvent event) {
            this.returnValue = event.getVariable();
        }

        public Variable getReturnValue() {
            return this.returnValue;
        }

        public void destroy() {
            this.mb.removeJPDABreakpointListener((JPDABreakpointListener)this);
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this.mb);
        }
    }

    public static interface StopHereCheck {
        public boolean stopHere(boolean var1);
    }
}

