/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.terminal.support;

import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.netbeans.lib.terminalemulator.Term;
import org.netbeans.modules.terminal.nb.TerminalPinnedTabOptions;

public class TerminalPinSupport {
    private final AtomicLong maxId = new AtomicLong(0L);
    private static final TerminalPinSupport INSTANCE = new TerminalPinSupport();
    private final TerminalPinnedTabOptions pinOptions = TerminalPinnedTabOptions.getDefault();
    private final Map<TerminalCreationDetails, TerminalPinningDetails> cache = new ConcurrentHashMap<TerminalCreationDetails, TerminalPinningDetails>();
    private final List<DetailsStateListener> listeners = new CopyOnWriteArrayList<DetailsStateListener>();

    public static TerminalPinSupport getDefault() {
        return INSTANCE;
    }

    private TerminalPinSupport() {
    }

    public List<TerminalDetails> readStoredDetails() {
        List<TerminalDetails> storedDetails = this.pinOptions.readStoredDetails();
        for (TerminalDetails details : storedDetails) {
            this.setIfGreater(this.maxId, details.getCreationDetails().getId());
            this.cache.put(details.getCreationDetails(), details.getPinningDetails());
        }
        return storedDetails;
    }

    public void clear() {
        this.cache.clear();
        this.pinOptions.clear();
    }

    public long createPinDetails(TerminalCreationDetails creationDetails) {
        if (creationDetails.getId() != 0L) {
            TerminalCreationDetails oldCreationDetails = this.findCreationDetails(creationDetails.getId());
            TerminalPinningDetails pinningDetails = this.cache.get(oldCreationDetails);
            this.cache.remove(oldCreationDetails);
            this.cache.put(creationDetails, pinningDetails);
            this.detailsAdded(creationDetails.getTerm());
            return creationDetails.getId();
        }
        long id = this.maxId.incrementAndGet();
        this.cache.put(TerminalCreationDetails.create(creationDetails.getTerm(), id, creationDetails.getExecEnv(), creationDetails.isPwdFlag()), TerminalPinningDetails.DUMMY);
        return id;
    }

    public void addDetailsStateListener(DetailsStateListener listener) {
        this.listeners.add(listener);
    }

    public void removeDetailsStateListener(DetailsStateListener listener) {
        this.listeners.remove(listener);
    }

    private void detailsAdded(Term term) {
        for (DetailsStateListener listener : this.listeners) {
            listener.detailsAdded(term);
        }
    }

    public void tabWasPinned(Term term, TerminalPinningDetails pinningDetails) {
        TerminalCreationDetails creationDetails = this.findCreationDetails(term);
        if (this.cache.containsKey(creationDetails)) {
            this.cache.put(creationDetails, pinningDetails);
            this.pinOptions.persist(new TerminalDetails(creationDetails, pinningDetails));
        }
    }

    public void tabWasUnpinned(Term term) {
        this.pinOptions.forget(this.findCreationDetails(term).getId());
    }

    public void close(Term term) {
        this.cache.remove(this.findCreationDetails(term));
    }

    private boolean setIfGreater(AtomicLong al, long setTo) {
        long current;
        while (setTo > (current = al.get())) {
            if (!al.compareAndSet(current, setTo)) continue;
            return true;
        }
        return false;
    }

    public TerminalPinningDetails findPinningDetails(Term term) {
        for (TerminalCreationDetails creationDetails : this.cache.keySet()) {
            Term key = creationDetails.getTerm();
            if (key == null || !key.equals(term)) continue;
            TerminalPinningDetails get = this.cache.get(creationDetails);
            if (get == TerminalPinningDetails.DUMMY) {
                return null;
            }
            return get;
        }
        return null;
    }

    public TerminalCreationDetails findCreationDetails(Term term) {
        for (TerminalCreationDetails creationDetails : this.cache.keySet()) {
            Term key = creationDetails.getTerm();
            if (key == null || !key.equals(term)) continue;
            return creationDetails;
        }
        return null;
    }

    public TerminalCreationDetails findCreationDetails(long id) {
        for (TerminalCreationDetails creationDetails : this.cache.keySet()) {
            long key = creationDetails.getId();
            if (key != id) continue;
            return creationDetails;
        }
        return null;
    }

    public static final class TerminalDetails {
        private final TerminalCreationDetails creationDetails;
        private final TerminalPinningDetails pinningDetails;

        public TerminalDetails(TerminalCreationDetails creationDetails, TerminalPinningDetails pinningDetails) {
            this.creationDetails = creationDetails;
            this.pinningDetails = pinningDetails;
        }

        public TerminalCreationDetails getCreationDetails() {
            return this.creationDetails;
        }

        public TerminalPinningDetails getPinningDetails() {
            return this.pinningDetails;
        }
    }

    public static final class TerminalCreationDetails {
        private final long id;
        private final Term term;
        private final String execEnv;
        private final boolean pwdFlag;

        public static TerminalCreationDetails create(Term term, String execEnv, boolean pwdFlag) {
            return new TerminalCreationDetails(term, 0L, execEnv, pwdFlag);
        }

        public static TerminalCreationDetails create(Term term, long id, String execEnv, boolean pwdFlag) {
            return new TerminalCreationDetails(term, id, execEnv, pwdFlag);
        }

        public static TerminalCreationDetails create(long id, String execEnv, boolean pwdFlag) {
            return new TerminalCreationDetails(null, id, execEnv, pwdFlag);
        }

        private TerminalCreationDetails(Term term, long id, String execEnv, boolean pwdFlag) {
            this.id = id;
            this.term = term;
            this.execEnv = execEnv;
            this.pwdFlag = pwdFlag;
        }

        public long getId() {
            return this.id;
        }

        public Term getTerm() {
            return this.term;
        }

        public String getExecEnv() {
            return this.execEnv;
        }

        public boolean isPwdFlag() {
            return this.pwdFlag;
        }
    }

    public static final class TerminalPinningDetails {
        static final TerminalPinningDetails DUMMY = new TerminalPinningDetails(false, null, null, false);
        private final boolean customTitle;
        private final String title;
        private final String cwd;
        private boolean pinned;

        public static TerminalPinningDetails create(boolean customTitle, String title, String cwd, boolean pinned) {
            return new TerminalPinningDetails(customTitle, title, cwd, pinned);
        }

        private TerminalPinningDetails(boolean customTitle, String title, String cwd, boolean pinned) {
            this.customTitle = customTitle;
            this.title = title;
            this.cwd = cwd;
            this.pinned = pinned;
        }

        public boolean isCustomTitle() {
            return this.customTitle;
        }

        public String getTitle() {
            return this.title;
        }

        public String getCwd() {
            return this.cwd;
        }

        public boolean isPinned() {
            return this.pinned;
        }

        public void setPinned(boolean pinned) {
            this.pinned = pinned;
        }
    }

    public static interface DetailsStateListener
    extends EventListener {
        public void detailsAdded(Term var1);
    }
}

