/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.queries;

import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class GenericProjectSources
implements Sources {
    private final Project project;

    public GenericProjectSources(Project project) {
        this.project = project;
    }

    public SourceGroup[] getSourceGroups(String type) {
        SourceGroup[] sourceGroupArray;
        if ("generic".equals(type)) {
            SourceGroup[] sourceGroupArray2 = new SourceGroup[1];
            sourceGroupArray = sourceGroupArray2;
            sourceGroupArray2[0] = new ProjectSourceGroup();
        } else {
            sourceGroupArray = new SourceGroup[]{};
        }
        return sourceGroupArray;
    }

    public void addChangeListener(ChangeListener listener) {
    }

    public void removeChangeListener(ChangeListener listener) {
    }

    private final class ProjectSourceGroup
    implements SourceGroup {
        public FileObject getRootFolder() {
            return GenericProjectSources.this.project.getProjectDirectory();
        }

        public String getName() {
            return ProjectUtils.getInformation((Project)GenericProjectSources.this.project).getName();
        }

        public String getDisplayName() {
            return ProjectUtils.getInformation((Project)GenericProjectSources.this.project).getDisplayName();
        }

        public Icon getIcon(boolean opened) {
            return null;
        }

        public boolean contains(FileObject file) {
            FileObject rootFolder = this.getRootFolder();
            if (file != rootFolder && !FileUtil.isParentOf((FileObject)rootFolder, (FileObject)file)) {
                return false;
            }
            if (file.isFolder() && file != rootFolder && ProjectManager.getDefault().isProject(file)) {
                return false;
            }
            return FileOwnerQuery.getOwner((FileObject)file) == GenericProjectSources.this.project;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }

        public String toString() {
            return "ProjectSourceGroup: " + this.getDisplayName();
        }
    }
}

