/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.debugger.ni;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.base.ExplicitProcessParameters;
import org.netbeans.modules.cpplite.debugger.CPPFrame;
import org.netbeans.modules.cpplite.debugger.CPPLiteDebugger;
import org.netbeans.modules.cpplite.debugger.CPPLiteDebuggerConfig;
import org.netbeans.modules.cpplite.debugger.CPPThread;
import org.netbeans.modules.cpplite.debugger.ni.NIBreakpoints;
import org.netbeans.modules.nativeimage.api.Location;
import org.netbeans.modules.nativeimage.api.SourceInfo;
import org.netbeans.modules.nativeimage.api.Symbol;
import org.netbeans.modules.nativeimage.api.debug.EvaluateException;
import org.netbeans.modules.nativeimage.api.debug.NIFrame;
import org.netbeans.modules.nativeimage.api.debug.NILineBreakpointDescriptor;
import org.netbeans.modules.nativeimage.api.debug.NIVariable;
import org.netbeans.modules.nativeimage.api.debug.StartDebugParameters;
import org.netbeans.modules.nativeimage.spi.debug.NIDebuggerProvider;
import org.netbeans.modules.nativeimage.spi.debug.filters.FrameDisplayer;
import org.netbeans.modules.nativeimage.spi.debug.filters.VariableDisplayer;
import org.openide.LifecycleManager;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class NIDebuggerProviderImpl
implements NIDebuggerProvider {
    private final NIBreakpoints breakpointsHandler = new NIBreakpoints();
    private volatile CPPLiteDebugger debugger;
    private volatile FrameDisplayer frameDisplayer;
    private volatile VariableDisplayer variablesDisplayer;
    private final RequestProcessor varDisplayerRP = new RequestProcessor(NIDebuggerProvider.class);

    public Breakpoint addLineBreakpoint(Object id, NILineBreakpointDescriptor breakpointDescriptor) {
        return this.breakpointsHandler.addLineBreakpoint(id, breakpointDescriptor);
    }

    public void removeBreakpoint(Object id) {
        this.breakpointsHandler.removeBreakpoint(id);
    }

    public void setFrameDisplayer(FrameDisplayer frameDisplayer) {
        this.frameDisplayer = frameDisplayer;
    }

    public void setVariablesDisplayer(VariableDisplayer variablesDisplayer) {
        this.variablesDisplayer = variablesDisplayer;
    }

    public CompletableFuture<Void> start(StartDebugParameters debugParameters, Consumer<DebuggerEngine> startedEngine) {
        ExplicitProcessParameters explicitParameters;
        if (this.debugger != null) {
            throw new IllegalStateException("Debugger has started already.");
        }
        List command = debugParameters.getCommand();
        String miDebugger = debugParameters.getDebugger();
        String displayName = debugParameters.getDisplayName();
        ExecutionDescriptor executionDescriptor = debugParameters.getExecutionDescriptor();
        Lookup contextLookup = debugParameters.getContextLookup();
        ExplicitProcessParameters explicitProcessParameters = explicitParameters = contextLookup != null ? ExplicitProcessParameters.buildExplicitParameters((Lookup)contextLookup) : null;
        if (explicitParameters == null) {
            explicitParameters = ExplicitProcessParameters.builder().workingDirectory(debugParameters.getWorkingDirectory()).build();
        }
        ExplicitProcessParameters processParameters = explicitParameters;
        if (executionDescriptor == null) {
            executionDescriptor = new ExecutionDescriptor().showProgress(true).showSuspended(true).frontWindowOnError(true).controllable(true);
        }
        final CompletableFuture<Void> completed = new CompletableFuture<Void>();
        Semaphore started = new Semaphore(0);
        ExecutionService.newService(() -> {
            Process engineProcess;
            CPPLiteDebugger[] debugger = new CPPLiteDebugger[]{null};
            try {
                LifecycleManager.getDefault().saveAll();
                engineProcess = CPPLiteDebugger.startDebugging(new CPPLiteDebuggerConfig(command, processParameters, null, miDebugger), engine -> {
                    debugger[0] = (CPPLiteDebugger)engine.lookupFirst(null, CPPLiteDebugger.class);
                    this.debugger = debugger[0];
                    if (startedEngine != null) {
                        startedEngine.accept((DebuggerEngine)engine);
                    }
                    debugger[0].addStateListener(new CPPLiteDebugger.StateListener(){

                        @Override
                        public void currentThread(CPPThread thread) {
                        }

                        @Override
                        public void currentFrame(CPPFrame frame) {
                        }

                        @Override
                        public void suspended(boolean suspended) {
                        }

                        @Override
                        public void finished() {
                            NIDebuggerProviderImpl.this.breakpointsHandler.dispose();
                            completed.complete(null);
                        }
                    });
                }, this.frameDisplayer, this.variablesDisplayer);
            }
            finally {
                started.release();
            }
            debugger[0].execRun();
            return engineProcess;
        }, (ExecutionDescriptor)executionDescriptor, (String)displayName).run();
        started.acquireUninterruptibly();
        return completed;
    }

    public CompletableFuture<Void> attach(String executablePath, long processId, String miDebugger, Consumer<DebuggerEngine> startedEngine) {
        if (this.debugger != null) {
            throw new IllegalStateException("Debugger has started already.");
        }
        ExplicitProcessParameters processParameters = ExplicitProcessParameters.builder().workingDirectory(new File(System.getProperty("user.dir", ""))).build();
        final CompletableFuture<Void> completed = new CompletableFuture<Void>();
        try {
            CPPLiteDebugger.startDebugging(new CPPLiteDebuggerConfig(Collections.singletonList(executablePath), processParameters, processId, miDebugger), engine -> {
                CPPLiteDebugger debugger;
                this.debugger = debugger = (CPPLiteDebugger)engine.lookupFirst(null, CPPLiteDebugger.class);
                if (startedEngine != null) {
                    startedEngine.accept((DebuggerEngine)engine);
                }
                debugger.addStateListener(new CPPLiteDebugger.StateListener(){

                    @Override
                    public void currentThread(CPPThread thread) {
                    }

                    @Override
                    public void currentFrame(CPPFrame frame) {
                    }

                    @Override
                    public void suspended(boolean suspended) {
                    }

                    @Override
                    public void finished() {
                        NIDebuggerProviderImpl.this.breakpointsHandler.dispose();
                        completed.complete(null);
                    }
                });
            }, this.frameDisplayer, this.variablesDisplayer);
        }
        catch (IOException ex) {
            completed.completeExceptionally(ex);
            return completed;
        }
        return completed;
    }

    public CompletableFuture<NIVariable> evaluateAsync(String expression, String resultName, NIFrame frame) {
        CPPFrame cframe;
        CompletableFuture<NIVariable> result = new CompletableFuture<NIVariable>();
        if (frame != null) {
            CPPThread thread = this.debugger.getThreads().get(frame.getThreadId());
            if (thread == null) {
                result.completeExceptionally((Throwable)new EvaluateException("No thread " + frame.getThreadId()));
                return result;
            }
            try {
                cframe = (CPPFrame)thread.getFrames().get(frame.getLevel());
            }
            catch (IndexOutOfBoundsException ioobex) {
                result.completeExceptionally((Throwable)new EvaluateException(ioobex.getLocalizedMessage()));
                return result;
            }
        } else {
            cframe = this.debugger.getCurrentFrame();
        }
        ((CompletableFuture)cframe.evaluateAsync(expression, resultName).thenAccept(rawResult -> this.varDisplayerRP.post(() -> {
            NIVariable[] variables = this.variablesDisplayer.displayed(new NIVariable[]{rawResult});
            NIVariable variable = variables.length > 0 ? variables[0] : rawResult;
            result.complete(variable);
        }))).exceptionally(exception -> {
            result.completeExceptionally((Throwable)exception);
            return null;
        });
        return result;
    }

    public String readMemory(String address, long offset, int length) {
        return this.debugger.readMemory(address, offset, length);
    }

    public String getVersion() {
        return this.debugger.getVersion();
    }

    public List<Location> listLocations(String filePath) {
        return this.debugger.listLocations(filePath);
    }

    public Map<SourceInfo, List<Symbol>> listFunctions(String name, boolean includeNondebug, int maxResults) {
        return this.debugger.listFunctions(name, includeNondebug, maxResults);
    }

    public Map<SourceInfo, List<Symbol>> listVariables(String name, boolean includeNondebug, int maxResults) {
        return this.debugger.listVariables(name, includeNondebug, maxResults);
    }
}

