/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.xml;

import java.io.IOException;
import nu.validator.xml.CombineContentHandler;
import nu.validator.xml.CombineLexicalHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class WiretapXMLReaderWrapper
implements XMLReader {
    private final XMLReader wrappedReader;
    private ContentHandler contentHandler;
    private ContentHandler wiretapContentHander;
    private LexicalHandler lexicalHandler;
    private LexicalHandler wiretapLexicalHandler;

    public WiretapXMLReaderWrapper(XMLReader wrappedReader) {
        this.wrappedReader = wrappedReader;
        this.contentHandler = wrappedReader.getContentHandler();
        try {
            this.lexicalHandler = (LexicalHandler)wrappedReader.getProperty("http://xml.org/sax/properties/lexical-handler");
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
            // empty catch block
        }
    }

    public void setWiretapContentHander(ContentHandler wiretapContentHander) {
        this.wiretapContentHander = wiretapContentHander;
        this.updateWiretap();
    }

    public void setWiretapLexicalHandler(LexicalHandler wiretapLexicalHandler) {
        this.wiretapLexicalHandler = wiretapLexicalHandler;
        this.updateWiretap();
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.wrappedReader.getDTDHandler();
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.wrappedReader.getEntityResolver();
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.wrappedReader.getErrorHandler();
    }

    @Override
    public boolean getFeature(String arg0) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.wrappedReader.getFeature(arg0);
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
            return this.lexicalHandler;
        }
        return this.wrappedReader.getProperty(name);
    }

    @Override
    public void parse(InputSource arg0) throws IOException, SAXException {
        this.wrappedReader.parse(arg0);
    }

    @Override
    public void parse(String arg0) throws IOException, SAXException {
        this.wrappedReader.parse(arg0);
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
        this.updateWiretap();
    }

    @Override
    public void setDTDHandler(DTDHandler arg0) {
        this.wrappedReader.setDTDHandler(arg0);
    }

    @Override
    public void setEntityResolver(EntityResolver arg0) {
        this.wrappedReader.setEntityResolver(arg0);
    }

    @Override
    public void setErrorHandler(ErrorHandler arg0) {
        this.wrappedReader.setErrorHandler(arg0);
    }

    @Override
    public void setFeature(String arg0, boolean arg1) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.wrappedReader.setFeature(arg0, arg1);
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
            this.lexicalHandler = (LexicalHandler)value;
            this.updateWiretap();
        } else {
            this.wrappedReader.setProperty(name, value);
        }
    }

    private void updateWiretap() {
        if (this.contentHandler != null) {
            if (this.wiretapContentHander != null) {
                this.wrappedReader.setContentHandler(new CombineContentHandler(this.wiretapContentHander, this.contentHandler));
            } else {
                this.wrappedReader.setContentHandler(this.contentHandler);
            }
        } else {
            this.wrappedReader.setContentHandler(this.wiretapContentHander);
        }
        try {
            if (this.lexicalHandler != null) {
                if (this.wiretapLexicalHandler != null) {
                    this.wrappedReader.setProperty("http://xml.org/sax/properties/lexical-handler", new CombineLexicalHandler(this.wiretapLexicalHandler, this.lexicalHandler));
                } else {
                    this.wrappedReader.setProperty("http://xml.org/sax/properties/lexical-handler", this.lexicalHandler);
                }
            } else {
                this.wrappedReader.setProperty("http://xml.org/sax/properties/lexical-handler", this.wiretapLexicalHandler);
            }
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
            // empty catch block
        }
    }
}

