/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.newproject;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.templates.CreateDescriptor;
import org.netbeans.modules.maven.api.archetype.ProjectInfo;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.POMModelFactory;
import org.netbeans.modules.maven.model.pom.Properties;
import org.netbeans.modules.maven.newproject.Bundle;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.netbeans.spi.project.ActionProgress;
import org.netbeans.spi.project.ActionProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class TemplateUtils {
    public static final String PARAM_ARCHETYPE = "archetype";
    public static final String PARAM_ARTIFACT_ID = "artifactId";
    public static final String PARAM_GROUP_ID = "groupId";
    public static final String PARAM_PACKAGING = "packaging";
    public static final String PARAM_VERSION = "version";
    public static final String PARAM_PACKAGE = "package";
    public static final String PARAM_VERSION_DEFAULT = "1.0-SNAPSHOT";
    public static final String PARAM_TO_OPEN = "openFiles";
    public static final String PARAM_INITIAL_BUILD = "buildAfterCreate";
    public static final String PARAM_INITIAL_PRIME = "primedAfterCreate";
    public static final String PARAM_MAIN_CLASS_NAME = "mainClassName";
    public static final String PARAM_PROJDIR = "projdir";

    private TemplateUtils() {
    }

    public static List<FileObject> afterTemplateCreation(Map<Object, Object> additionalProperties, CreateDescriptor desc, List<FileObject> fos, FileObject fo) throws IOException {
        ArrayList<FileObject> pomDirs = new ArrayList<FileObject>();
        TemplateUtils.collectPomDirs(fo, pomDirs);
        if (fos != null) {
            pomDirs.addAll(fos);
        }
        TemplateUtils.setMainClass(additionalProperties, fo);
        if (fos != null) {
            String toOpen = Objects.toString(additionalProperties.get("archetypeOpen"), null);
            if (toOpen == null) {
                toOpen = (String)desc.getValue(PARAM_TO_OPEN);
            }
            if (toOpen != null) {
                TemplateUtils.collectFiles(fo, fos, toOpen.split(","));
            }
        }
        final boolean enableBuild = Boolean.valueOf(Objects.toString(additionalProperties.getOrDefault("archetypeBuild", desc.getValue(PARAM_INITIAL_BUILD)), null));
        boolean enablePrime = Boolean.valueOf((String)desc.getValue(PARAM_INITIAL_PRIME));
        if (enableBuild || enablePrime) {
            ActionProvider ap;
            Project prj = ProjectManager.getDefault().findProject(fo);
            ActionProvider actionProvider = ap = prj == null ? null : (ActionProvider)prj.getLookup().lookup(ActionProvider.class);
            if (ap != null) {
                String command;
                Lookup actionLookup = desc.getLookup();
                if (actionLookup == null || actionLookup == Lookup.EMPTY) {
                    actionLookup = prj.getLookup();
                }
                String string = enableBuild ? "build" : (command = enablePrime ? "prime" : null);
                if (command != null) {
                    ProgressHandle h;
                    ActionProgress prg = (ActionProgress)actionLookup.lookup(ActionProgress.class);
                    if (prg == null && (h = (ProgressHandle)actionLookup.lookup(ProgressHandle.class)) != null) {
                        String pn;
                        ProjectInformation info = (ProjectInformation)prj.getLookup().lookup(ProjectInformation.class);
                        String string2 = pn = info != null ? info.getDisplayName() : info.getName();
                        if (pn == null && desc.getName() == null) {
                            pn = desc.getProposedName();
                        }
                        final String fpn = pn;
                        prg = new ActionProgress(){

                            protected void started() {
                                h.progress(enableBuild ? Bundle.ProgressTitleBuild(fpn) : Bundle.ProgressTitlePrime(fpn));
                            }

                            public void finished(boolean success) {
                                if (success) {
                                    return;
                                }
                                h.progress(enableBuild ? Bundle.ProgressTitleBuildFailed(fpn) : Bundle.ProgressTitlePrimeFailed(fpn));
                            }
                        };
                        actionLookup = new ProxyLookup(new Lookup[]{actionLookup, Lookups.fixed((Object[])new Object[]{prg})});
                    }
                    ap.invokeAction(command, actionLookup);
                }
            }
        }
        return pomDirs;
    }

    private static void collectPomDirs(FileObject dir, Collection<? super FileObject> found) {
        if (dir == null || !dir.isFolder()) {
            return;
        }
        if (dir.getFileObject("pom.xml") == null) {
            return;
        }
        found.add((FileObject)dir);
        for (FileObject f : dir.getChildren()) {
            TemplateUtils.collectPomDirs(f, found);
        }
    }

    static void collectFiles(FileObject root, Collection<? super FileObject> found, String ... includes) {
        Pattern[] check = new Pattern[includes.length];
        for (int i = 0; i < check.length; ++i) {
            check[i] = Pattern.compile(includes[i]);
        }
        Enumeration en = root.getChildren(true);
        block1: while (en.hasMoreElements()) {
            FileObject fo = (FileObject)en.nextElement();
            String relPath = FileUtil.getRelativePath((FileObject)root, (FileObject)fo);
            if (relPath == null) continue;
            for (Pattern p : check) {
                if (!p.matcher(relPath).matches()) continue;
                found.add((FileObject)fo);
                continue block1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setMainClass(Map<Object, Object> properties, FileObject fo) {
        FileObject pom = fo.getFileObject("pom.xml");
        if (pom != null) {
            ModelSource modelSource = Utilities.createModelSource((FileObject)pom);
            POMModel model = POMModelFactory.getDefault().getModel(modelSource);
            org.netbeans.modules.maven.model.pom.Project root = model.getProject();
            if (root != null && model.startTransaction()) {
                try {
                    Properties props = root.getProperties();
                    if (props == null) {
                        props = model.getFactory().createProperties();
                        root.setProperties(props);
                    }
                    String packageName = (String)properties.get(PARAM_PACKAGE);
                    String mainClass = (String)properties.get(PARAM_MAIN_CLASS_NAME);
                    if (mainClass == null || mainClass.isEmpty()) {
                        mainClass = "App";
                    }
                    if (packageName != null && !packageName.isEmpty()) {
                        mainClass = packageName + '.' + mainClass;
                    }
                    props.setProperty("exec.mainClass", mainClass);
                }
                finally {
                    model.endTransaction();
                    try {
                        Utilities.saveChanges((AbstractDocumentModel)model);
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static ProjectInfo createProjectInfo(String name, Map<String, Object> vals) throws IOException {
        String artifact = (String)vals.getOrDefault(PARAM_ARTIFACT_ID, name);
        String group = (String)vals.get(PARAM_GROUP_ID);
        String version = (String)vals.getOrDefault(PARAM_VERSION, PARAM_VERSION_DEFAULT);
        String pkg = (String)vals.get(PARAM_PACKAGE);
        if (artifact == null) {
            throw new IOException(Bundle.MSG_NoArtifactId());
        }
        if (group == null) {
            group = TemplateUtils.findGroupId(pkg, artifact);
        }
        if (group == null) {
            throw new IOException(Bundle.MSG_NoGroupId());
        }
        return new ProjectInfo(group, artifact, version, pkg);
    }

    private static String findGroupId(String pkg, String name) {
        if (pkg != null && pkg.endsWith("." + name)) {
            return pkg.substring(0, pkg.length() - 1 - name.length());
        }
        return pkg;
    }
}

