/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupportFactory;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.classpath.ProjectSourcesClassPathProvider;
import org.netbeans.modules.maven.api.execute.ActiveJ2SEPlatformProvider;
import org.netbeans.modules.maven.classpath.AnnotationProcClassPathImpl;
import org.netbeans.modules.maven.classpath.BootClassPathImpl;
import org.netbeans.modules.maven.classpath.CompileClassPathImpl;
import org.netbeans.modules.maven.classpath.EndorsedClassPathImpl;
import org.netbeans.modules.maven.classpath.PlatformModulesPathImpl;
import org.netbeans.modules.maven.classpath.RuntimeClassPathImpl;
import org.netbeans.modules.maven.classpath.SourceClassPathImpl;
import org.netbeans.modules.maven.classpath.TestCompileClassPathImpl;
import org.netbeans.modules.maven.classpath.TestRuntimeClassPathImpl;
import org.netbeans.modules.maven.classpath.TestSourceClassPathImpl;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public final class ClassPathProviderImpl
implements ClassPathProvider,
ActiveJ2SEPlatformProvider,
ProjectSourcesClassPathProvider {
    private static final Logger LOGGER = Logger.getLogger(ClassPathProviderImpl.class.getName());
    public static final String MODULE_INFO_JAVA = "module-info.java";
    private static final int TYPE_SRC = 0;
    private static final int TYPE_TESTSRC = 1;
    private static final int TYPE_WEB = 5;
    private static final int TYPE_UNKNOWN = -1;
    @NonNull
    private final Project proj;
    private static final int SOURCE_PATH = 0;
    private static final int COMPILE_TIME_PATH = 2;
    private static final int RUNTIME_PATH = 4;
    private static final int BOOT_PATH = 6;
    private static final int ENDORSED_PATH = 8;
    private static final int MODULE_BOOT_PATH = 9;
    private static final int MODULE_COMPILE_PATH = 10;
    private static final int MODULE_LEGACY_PATH = 12;
    private static final int MODULE_EXECUTE_PATH = 14;
    private static final int MODULE_EXECUTE_CLASS_PATH = 16;
    private static final int JAVA8_COMPILE_PATH = 18;
    private static final int JAVA8_TEST_COMPILE_PATH = 19;
    private static final int JAVA8_TEST_SCOPED_COMPILE_PATH = 20;
    private static final int JAVA8_RUNTIME_PATH = 21;
    private static final int JAVA8_TEST_SCOPED_RUNTIME_PATH = 23;
    private static final int ANNOTATION_PROC_PATH = 24;
    private final ClassPath[] cache = new ClassPath[26];
    private BootClassPathImpl bcpImpl;
    private EndorsedClassPathImpl ecpImpl;

    public ClassPathProviderImpl(@NonNull Project proj) {
        this.proj = proj;
    }

    @Override
    public ClassPath[] getProjectClassPaths(String type) {
        return (ClassPath[])ProjectManager.mutex().readAccess(() -> {
            if ("classpath/boot".equals(type)) {
                return new ClassPath[]{this.getBootClassPath(0), this.getBootClassPath(1)};
            }
            if ("classpath/endorsed".equals(type)) {
                return new ClassPath[]{this.getEndorsedClassPath()};
            }
            if ("classpath/compile".equals(type)) {
                ArrayList<ClassPath> l = new ArrayList<ClassPath>(2);
                l.add(this.getCompileTimeClasspath(0));
                l.add(this.getCompileTimeClasspath(1));
                return l.toArray(new ClassPath[l.size()]);
            }
            if ("classpath/execute".equals(type)) {
                ArrayList<ClassPath> l = new ArrayList<ClassPath>(2);
                l.add(this.getRuntimeClasspath(0));
                l.add(this.getRuntimeClasspath(1));
                return l.toArray(new ClassPath[l.size()]);
            }
            if ("classpath/source".equals(type)) {
                ArrayList<ClassPath> l = new ArrayList<ClassPath>(2);
                l.add(this.getSourcepath(0));
                l.add(this.getSourcepath(1));
                return l.toArray(new ClassPath[l.size()]);
            }
            if ("modules/boot".equals(type)) {
                return new ClassPath[]{this.getModuleBootPath()};
            }
            if ("modules/compile".equals(type)) {
                ClassPath[] l = new ClassPath[]{this.getModuleCompilePath(0), this.getModuleCompilePath(1)};
                return l;
            }
            if ("modules/classpath".equals(type)) {
                ClassPath[] l = new ClassPath[]{this.getModuleLegacyClassPath(0), this.getModuleLegacyClassPath(1)};
                return l;
            }
            return new ClassPath[0];
        });
    }

    @Override
    public ClassPath getProjectSourcesClassPath(String type) {
        if ("classpath/boot".equals(type)) {
            return this.getBootClassPath(0);
        }
        if ("classpath/endorsed".equals(type)) {
            return this.getEndorsedClassPath();
        }
        if ("classpath/compile".equals(type)) {
            return this.getCompileTimeClasspath(0);
        }
        if ("classpath/source".equals(type)) {
            return this.getSourcepath(0);
        }
        if ("classpath/execute".equals(type)) {
            return this.getRuntimeClasspath(0);
        }
        if (type.equals("modules/boot")) {
            return this.getModuleBootPath();
        }
        if (type.equals("modules/compile")) {
            return this.getModuleCompilePath(0);
        }
        if (type.equals("modules/classpath")) {
            return this.getModuleLegacyClassPath(0);
        }
        if ("modules/execute".equals(type)) {
            return this.getModuleExecutePath(0);
        }
        if ("modules/execute-classpath".equals(type)) {
            return this.getModuleLegacyRuntimeClassPath(0);
        }
        assert (false);
        return null;
    }

    public ClassPath findClassPath(FileObject file, String type) {
        assert (file != null);
        if (file == null) {
            LOGGER.log(Level.WARNING, " passed null fileobject fo ClassPathProviderImpl.findClassPath.");
            return null;
        }
        int fileType = this.getType(file);
        if (fileType != 0 && fileType != 1 && fileType != 5) {
            LOGGER.log(Level.FINEST, " bad type={0} for {1}", new Object[]{type, file});
            return null;
        }
        if (type.equals("classpath/compile")) {
            return this.getCompileTimeClasspath(fileType);
        }
        if (type.equals("classpath/execute")) {
            return this.getRuntimeClasspath(fileType);
        }
        if ("classpath/source".equals(type)) {
            return this.getSourcepath(fileType);
        }
        if (type.equals("classpath/boot")) {
            return this.getBootClassPath(fileType);
        }
        if (type.equals("classpath/endorsed")) {
            return this.getEndorsedClassPath();
        }
        if (type.equals("classpath/processor")) {
            return this.getAnnotationProcClassPath(fileType);
        }
        if (type.equals("modules/boot")) {
            return this.getModuleBootPath();
        }
        if (type.equals("modules/compile")) {
            return this.getModuleCompilePath(fileType);
        }
        if (type.equals("modules/classpath")) {
            return this.getModuleLegacyClassPath(fileType);
        }
        if (type.equals("modules/execute")) {
            return this.getModuleExecutePath(fileType);
        }
        if (type.equals("modules/execute-classpath")) {
            return this.getModuleLegacyRuntimeClassPath(fileType);
        }
        return null;
    }

    @Override
    @NonNull
    public JavaPlatform getJavaPlatform() {
        return this.getBootClassPathImpl().findActivePlatform();
    }

    private boolean isChildOf(FileObject child, URI[] uris) {
        for (int i = 0; i < uris.length; ++i) {
            FileObject fo = FileUtilities.convertURItoFileObject(uris[i]);
            if (fo == null || !fo.isFolder() || !fo.equals(child) && !FileUtil.isParentOf((FileObject)fo, (FileObject)child)) continue;
            return true;
        }
        return false;
    }

    public static FileObject[] convertStringsToFileObjects(List<String> strings) {
        FileObject[] fos = new FileObject[strings.size()];
        int index = 0;
        for (String str : strings) {
            fos[index] = FileUtilities.convertStringToFileObject(str);
            ++index;
        }
        return fos;
    }

    private int getType(FileObject file) {
        if (file == null) {
            return -1;
        }
        NbMavenProjectImpl project = this.getNBMavenProject();
        if (this.isChildOf(file, project.getSourceRoots(false)) || this.isChildOf(file, project.getGeneratedSourceRoots(false))) {
            return 0;
        }
        if (this.isChildOf(file, project.getSourceRoots(true)) || this.isChildOf(file, project.getGeneratedSourceRoots(true))) {
            return 1;
        }
        URI web = project.getWebAppDirectory();
        FileObject fo = FileUtil.toFileObject((File)Utilities.toFile((URI)web));
        if (fo != null && (fo.equals(file) || FileUtil.isParentOf((FileObject)fo, (FileObject)file))) {
            return 5;
        }
        if (this.isChildOf(file, project.getResources(false))) {
            return 0;
        }
        if (this.isChildOf(file, project.getResources(true))) {
            return 1;
        }
        return -1;
    }

    private ClassPath getSourcepath(int type) {
        int ftype = type == 5 ? 0 : type;
        return this.computeIfAbsent(0 + ftype, () -> ClassPathFactory.createClassPath((ClassPathImplementation)(ftype == 0 ? new SourceClassPathImpl(this.getNBMavenProject()) : new TestSourceClassPathImpl(this.getNBMavenProject()))));
    }

    private ClassPath getAnnotationProcClassPath(int type) {
        int ftype;
        switch (type) {
            default: {
                ftype = 0;
                break;
            }
            case 0: 
            case 1: {
                ftype = type;
            }
        }
        int index = 24 + ftype;
        return this.computeIfAbsent(index, () -> {
            ClassPath anno = ClassPathFactory.createClassPath((ClassPathImplementation)new AnnotationProcClassPathImpl(this.getNBMavenProject(), ftype == 0));
            return this.createMultiplexClassPath(new AnnotationPathSelector(this.getNBMavenProject(), anno, () -> this.getCompileTimeClasspath(type)));
        });
    }

    private ClassPath getCompileTimeClasspath(int type) {
        int ftype = type == 5 ? 0 : type;
        return this.computeIfAbsent(2 + ftype, () -> this.createModuleInfoSelector(() -> this.createModuleInfoBasedPath(this.getModuleCompilePath(ftype), this.getSourcepath(ftype), this.getModuleBootPath(), this.getModuleCompilePath(ftype), ftype == 0 ? this.getJava8CompileClasspath() : this.createTestClassPathSelector(() -> this.getJava8TestCompileClasspath(), () -> this.getTestScopedCompileClasspath(), "TestsCompileTimeLegacyClasspath"), null), () -> ftype == 0 ? this.getJava8CompileClasspath() : this.getJava8TestCompileClasspath(), "CompileTimeClasspath"));
    }

    private ClassPath getRuntimeClasspath(int type) {
        int ftype = type == 5 ? 0 : type;
        return this.computeIfAbsent(4 + ftype, () -> this.createModuleInfoSelector(() -> this.createModuleInfoBasedPath(this.getJava8RunTimeClassPath(ftype), this.getSourcepath(ftype), this.getModuleBootPath(), this.getJava8RunTimeClassPath(ftype), ftype == 0 ? this.getJava8RunTimeClassPath(0) : this.createTestClassPathSelector(() -> this.getJava8RunTimeClassPath(1), () -> this.getTestScopedRuntimeClasspath(), "TestsRuntimeLegacyClasspath"), null), () -> this.getJava8RunTimeClassPath(ftype), "RuntimeClasspath"));
    }

    private ClassPath getJava8RunTimeClassPath(int type) {
        int ftype = type == 5 ? 0 : type;
        return this.computeIfAbsent(21 + ftype, () -> ClassPathFactory.createClassPath((ClassPathImplementation)(ftype == 0 ? new RuntimeClassPathImpl(this.getNBMavenProject()) : new TestRuntimeClassPathImpl(this.getNBMavenProject(), false))));
    }

    private ClassPath getTestScopedRuntimeClasspath() {
        return this.computeIfAbsent(23, () -> ClassPathFactory.createClassPath((ClassPathImplementation)new TestRuntimeClassPathImpl(this.getNBMavenProject(), true)));
    }

    private ClassPath getBootClassPath(int type) {
        int ftype = type == 5 ? 0 : type;
        return this.computeIfAbsent(6 + ftype, () -> this.createModuleInfoSelector(() -> this.createModuleInfoBasedPath(this.getModuleBootPath(), this.getSourcepath(ftype), this.getModuleBootPath(), this.getModuleCompilePath(ftype), null, null), () -> ClassPathFactory.createClassPath((ClassPathImplementation)this.getBootClassPathImpl()), "BootClasspath"));
    }

    private BootClassPathImpl getBootClassPathImpl() {
        if (this.bcpImpl == null) {
            this.bcpImpl = new BootClassPathImpl(this.getNBMavenProject(), this.getEndorsedClassPathImpl());
        }
        return this.bcpImpl;
    }

    private ClassPath getJava8CompileClasspath() {
        return this.computeIfAbsent(18, () -> ClassPathFactory.createClassPath((ClassPathImplementation)new CompileClassPathImpl(this.getNBMavenProject(), true)));
    }

    private ClassPath getJava8TestCompileClasspath() {
        return this.computeIfAbsent(19, () -> ClassPathFactory.createClassPath((ClassPathImplementation)new TestCompileClassPathImpl(this.getNBMavenProject(), true)));
    }

    private ClassPath getTestScopedCompileClasspath() {
        return this.computeIfAbsent(20, () -> ClassPathFactory.createClassPath((ClassPathImplementation)new TestCompileClassPathImpl(this.getNBMavenProject(), true, true)));
    }

    private EndorsedClassPathImpl getEndorsedClassPathImpl() {
        if (this.ecpImpl == null) {
            this.ecpImpl = new EndorsedClassPathImpl(this.getNBMavenProject());
        }
        return this.ecpImpl;
    }

    private ClassPath getEndorsedClassPath() {
        return this.computeIfAbsent(8, () -> {
            this.getBootClassPathImpl();
            return ClassPathFactory.createClassPath((ClassPathImplementation)this.getEndorsedClassPathImpl());
        });
    }

    private ClassPath getModuleBootPath() {
        return this.computeIfAbsent(9, () -> this.createModuleInfoSelector(() -> this.createPlatformModulesPath(), () -> this.createPlatformModulesPath(), "ModuleBootPath"));
    }

    private ClassPath getModuleCompilePath(int type) {
        int ftype = type == 5 ? 0 : type;
        return this.computeIfAbsent(10 + ftype, () -> ftype == 0 ? this.createModuleInfoSelector(() -> this.getJava8CompileClasspath(), () -> ClassPath.EMPTY, "ModuleCompilePath") : this.createTestModulePathSelector(() -> this.getJava8CompileClasspath(), () -> this.getJava8TestCompileClasspath(), "TestModuleCompilePath"));
    }

    private ClassPath getModuleExecutePath(int type) {
        int ftype = type == 5 ? 0 : type;
        return this.computeIfAbsent(14 + ftype, () -> ftype == 0 ? this.createModuleInfoSelector(() -> this.getJava8RunTimeClassPath(0), () -> ClassPath.EMPTY, "ModuleExecutePath") : this.createTestModulePathSelector(() -> this.getJava8RunTimeClassPath(0), () -> this.getJava8RunTimeClassPath(1), "TestModuleExecutePath"));
    }

    @NonNull
    private ClassPath getModuleLegacyClassPath(int type) {
        int ftype;
        int n = ftype = type == 5 ? 0 : type;
        assert (ftype >= 0 && ftype <= 1);
        return this.computeIfAbsent(12 + ftype, () -> ftype == 0 ? this.createModuleInfoSelector(() -> ClassPath.EMPTY, () -> this.getJava8CompileClasspath(), "ModuleLegacyClassPath") : this.createModuleInfoSelector(() -> this.getTestScopedCompileClasspath(), () -> this.getJava8TestCompileClasspath(), "TestModuleLegacyClassPath"));
    }

    @NonNull
    private ClassPath getModuleLegacyRuntimeClassPath(int type) {
        int ftype;
        int n = ftype = type == 5 ? 0 : type;
        assert (ftype >= 0 && ftype <= 1);
        return this.computeIfAbsent(16 + ftype, () -> ftype == 0 ? this.createModuleInfoSelector(() -> ClassPath.EMPTY, () -> this.getJava8RunTimeClassPath(0), "ModuleLegacyRuntimeClassPath") : this.createModuleInfoSelector(() -> this.getTestScopedRuntimeClasspath(), () -> this.getJava8RunTimeClassPath(1), "TestModuleLegacyRuntimeClassPath"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPath computeIfAbsent(int cacheIndex, Supplier<ClassPath> provider) {
        ClassPathProviderImpl classPathProviderImpl = this;
        synchronized (classPathProviderImpl) {
            ClassPath cp = this.cache[cacheIndex];
            if (cp != null) {
                return cp;
            }
        }
        return (ClassPath)ProjectManager.mutex().readAccess(() -> {
            ClassPathProviderImpl classPathProviderImpl = this;
            synchronized (classPathProviderImpl) {
                ClassPath cp = this.cache[cacheIndex];
                if (cp == null) {
                    this.cache[cacheIndex] = cp = (ClassPath)provider.get();
                }
                return cp;
            }
        });
    }

    private ClassPath createPlatformModulesPath() {
        return ClassPathFactory.createClassPath((ClassPathImplementation)new PlatformModulesPathImpl(this.getNBMavenProject()));
    }

    private ClassPath createModuleInfoBasedPath(ClassPath base, ClassPath sourceRoots, ClassPath systemModules, ClassPath userModules, ClassPath legacyClassPath, Function<URL, Boolean> filter) {
        return ClassPathFactory.createClassPath((ClassPathImplementation)ClassPathSupportFactory.createModuleInfoBasedPath((ClassPath)base, (ClassPath)sourceRoots, (ClassPath)systemModules, (ClassPath)userModules, (ClassPath)legacyClassPath, filter));
    }

    private ClassPath createModuleInfoSelector(Supplier<ClassPath> hasModuleInfoClassPath, Supplier<ClassPath> noModuleInfoClassPath, String logDesc) {
        return this.createMultiplexClassPath(new ModuleInfoSelector(this.getNBMavenProject(), hasModuleInfoClassPath, noModuleInfoClassPath, logDesc));
    }

    private ClassPath createTestClassPathSelector(Supplier<ClassPath> testPath, Supplier<ClassPath> testScopedPath, String logDesc) {
        return this.createMultiplexClassPath(new TestClassPathSelector(this.getNBMavenProject(), testPath, testScopedPath, logDesc));
    }

    private ClassPath createTestModulePathSelector(Supplier<ClassPath> path, Supplier<ClassPath> testPath, String logDesc) {
        return this.createMultiplexClassPath(new TestModulePathSelector(this.getNBMavenProject(), path, testPath, logDesc));
    }

    private ClassPath createMultiplexClassPath(ClassPathSelector selector) {
        return ClassPathSupport.createMultiplexClassPath((ClassPathSupport.Selector)selector);
    }

    private NbMavenProjectImpl getNBMavenProject() {
        return (NbMavenProjectImpl)this.proj.getLookup().lookup(NbMavenProjectImpl.class);
    }

    private static abstract class ClassPathSelector
    implements ClassPathSupport.Selector {
        protected final PropertyChangeSupport support = new PropertyChangeSupport(this);
        protected final NbMavenProjectImpl proj;
        protected ClassPath active = null;

        public ClassPathSelector(NbMavenProjectImpl proj) {
            this.proj = proj;
            NbMavenProject.addPropertyChangeListener(proj, evt -> {
                if (this.isReset(evt)) {
                    this.active = null;
                    this.support.firePropertyChange("activeClassPath", null, null);
                }
            });
        }

        protected abstract boolean isReset(PropertyChangeEvent var1);

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.support.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.support.removePropertyChangeListener(listener);
        }
    }

    private static class AnnotationPathSelector
    extends ClassPathSelector {
        private final ClassPath annotationCP;
        private final Supplier<ClassPath> compileClassPath;

        public AnnotationPathSelector(NbMavenProjectImpl proj, ClassPath anno, Supplier<ClassPath> compile) {
            super(proj);
            this.annotationCP = anno;
            this.compileClassPath = compile;
            anno.addPropertyChangeListener(WeakListeners.propertyChange(e -> {
                this.active = null;
                this.support.firePropertyChange("activeClassPath", null, null);
            }, (String)"roots", (Object)anno));
        }

        @Override
        protected boolean isReset(PropertyChangeEvent evt) {
            return "MavenProject".equals(evt.getPropertyName());
        }

        public ClassPath getActiveClassPath() {
            if (this.active != null) {
                return this.active;
            }
            if (this.annotationCP.getFlags().contains(ClassPath.Flag.INCOMPLETE) || !this.annotationCP.entries().isEmpty()) {
                this.active = this.annotationCP;
                return this.active;
            }
            this.active = this.compileClassPath.get();
            return this.active;
        }
    }

    private static abstract class TestPathSelector
    extends ClassPathSelector {
        private final String logDesc;

        TestPathSelector(NbMavenProjectImpl proj, String logDesc) {
            super(proj);
            this.logDesc = logDesc;
        }

        public ClassPath getActiveClassPath() {
            ClassPath ret = this.active;
            if (ret == null) {
                boolean hasTestModuleDescriptor;
                MavenProject mp = this.proj.getOriginalMavenProject();
                boolean hasMainModuleDescriptor = mp.getCompileSourceRoots().stream().anyMatch(sourceRoot -> new File((String)sourceRoot, ClassPathProviderImpl.MODULE_INFO_JAVA).exists());
                if (hasMainModuleDescriptor) {
                    LOGGER.log(Level.FINER, "TestPathSelector {0} for project {1}: has main module-info.java", new Object[]{this.logDesc, this.proj.getProjectDirectory().getPath()});
                }
                if (hasTestModuleDescriptor = mp.getTestCompileSourceRoots().stream().anyMatch(testSourceRoot -> new File((String)testSourceRoot, ClassPathProviderImpl.MODULE_INFO_JAVA).exists())) {
                    LOGGER.log(Level.FINER, "TestPathSelector {0} for project {1}: has test module-info.java", new Object[]{this.logDesc, this.proj.getProjectDirectory().getPath()});
                }
                this.active = ret = this.getActiveClassPath(hasTestModuleDescriptor, hasMainModuleDescriptor);
            }
            LOGGER.log(Level.FINE, "TestPathSelector {0} for project {1} active class path: {2}", new Object[]{this.logDesc, this.proj.getProjectDirectory().getPath(), ret});
            return ret;
        }

        protected abstract ClassPath getActiveClassPath(boolean var1, boolean var2);

        @Override
        protected boolean isReset(PropertyChangeEvent evt) {
            boolean reset = false;
            if ("RESOURCES".equals(evt.getPropertyName()) && evt.getNewValue() instanceof URI) {
                File file = Utilities.toFile((URI)((URI)evt.getNewValue()));
                MavenProject mp = this.proj.getOriginalMavenProject();
                boolean bl = reset = mp.getCompileSourceRoots().stream().anyMatch(sourceRoot -> file.equals(new File((String)sourceRoot, ClassPathProviderImpl.MODULE_INFO_JAVA))) || mp.getTestCompileSourceRoots().stream().anyMatch(sourceRoot -> file.equals(new File((String)sourceRoot, ClassPathProviderImpl.MODULE_INFO_JAVA)));
                if (reset) {
                    LOGGER.log(Level.FINER, "TestPathSelector {0} for project {1} resource changed: {2}", new Object[]{this.logDesc, this.proj.getProjectDirectory().getPath(), evt});
                }
            }
            return reset;
        }
    }

    private static class TestClassPathSelector
    extends TestPathSelector {
        private final Supplier<ClassPath> testPath;
        private final Supplier<ClassPath> testScopedPath;

        TestClassPathSelector(NbMavenProjectImpl proj, Supplier<ClassPath> testPath, Supplier<ClassPath> testScopedPath, String logDesc) {
            super(proj, logDesc);
            this.testPath = testPath;
            this.testScopedPath = testScopedPath;
        }

        @Override
        protected ClassPath getActiveClassPath(boolean hasTestModuleDescriptor, boolean hasMainModuleDescriptor) {
            if (hasTestModuleDescriptor) {
                return ClassPath.EMPTY;
            }
            if (hasMainModuleDescriptor) {
                return this.testScopedPath.get();
            }
            return this.testPath.get();
        }
    }

    private static class TestModulePathSelector
    extends TestPathSelector {
        protected final Supplier<ClassPath> path;
        protected final Supplier<ClassPath> testPath;

        TestModulePathSelector(NbMavenProjectImpl proj, Supplier<ClassPath> path, Supplier<ClassPath> testPath, String logDesc) {
            super(proj, logDesc);
            this.path = path;
            this.testPath = testPath;
        }

        @Override
        protected ClassPath getActiveClassPath(boolean hasTestModuleDescriptor, boolean hasMainModuleDescriptor) {
            if (hasTestModuleDescriptor) {
                return this.testPath.get();
            }
            if (hasMainModuleDescriptor) {
                return this.path.get();
            }
            return ClassPath.EMPTY;
        }
    }

    private static class ModuleInfoSelector
    extends ClassPathSelector {
        private final Supplier<ClassPath> noModuleInfoCP;
        private final Supplier<ClassPath> hasModuleInfoCP;
        private final String logDesc;

        public ModuleInfoSelector(NbMavenProjectImpl proj, Supplier<ClassPath> hasModuleInfoClassPath, Supplier<ClassPath> noModuleInfoClassPath, String logDesc) {
            super(proj);
            this.hasModuleInfoCP = hasModuleInfoClassPath;
            this.noModuleInfoCP = noModuleInfoClassPath;
            this.logDesc = logDesc;
        }

        public ClassPath getActiveClassPath() {
            ClassPath ret = this.active;
            if (ret == null) {
                for (String sourceRoot : this.proj.getOriginalMavenProject().getCompileSourceRoots()) {
                    File moduleInfoFile = new File(sourceRoot, ClassPathProviderImpl.MODULE_INFO_JAVA);
                    if (!moduleInfoFile.exists()) continue;
                    FileObject moduleInfo = FileUtil.toFileObject((File)moduleInfoFile);
                    String sourceLevel = SourceLevelQuery.getSourceLevel2((FileObject)moduleInfo).getSourceLevel();
                    String ide_jdkvers = System.getProperty("java.version");
                    if (!sourceLevel.startsWith("1.") && !ide_jdkvers.startsWith("1.")) {
                        ret = this.hasModuleInfoCP.get();
                    }
                    ClassPath retObject = ret;
                    LOGGER.log(Level.FINER, () -> String.format("ModuleInfoSelector %s for project %s: has module-info.java %s", this.logDesc, this.proj.getProjectDirectory().getPath(), retObject == null ? "IGNORED" : ""));
                    break;
                }
                if (ret == null) {
                    ret = this.noModuleInfoCP.get();
                }
                this.active = ret;
            }
            LOGGER.log(Level.FINE, "ModuleInfoSelector {0} for project {1} active class path: {2}", new Object[]{this.logDesc, this.proj.getProjectDirectory().getPath(), ret});
            return ret;
        }

        @Override
        protected boolean isReset(PropertyChangeEvent evt) {
            boolean reset = false;
            if ("RESOURCES".equals(evt.getPropertyName()) && evt.getNewValue() instanceof URI) {
                File file = Utilities.toFile((URI)((URI)evt.getNewValue()));
                for (String sourceRoot : this.proj.getOriginalMavenProject().getCompileSourceRoots()) {
                    if (!file.equals(new File(sourceRoot, ClassPathProviderImpl.MODULE_INFO_JAVA))) continue;
                    reset = true;
                    break;
                }
                if (reset) {
                    LOGGER.log(Level.FINER, "ModuleInfoSelector {0} for project {1} resource changed: {2}", new Object[]{this.logDesc, this.proj.getProjectDirectory().getPath(), evt});
                }
            }
            return reset;
        }
    }
}

