/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.osgi.util;

import org.netbeans.modules.maven.osgi.util.PackageDefinitionVisitor;

public class PackageDefinitionUtil {
    public static String omitDirectives(String definition) {
        final StringBuilder sb = new StringBuilder();
        PackageDefinitionUtil.visitPackageDefinition(definition, new PackageDefinitionVisitor(){
            private boolean quoted = false;
            private boolean directive = false;

            @Override
            public void startPattern() {
            }

            @Override
            public void endPattern() {
                sb.append(",");
            }

            @Override
            public void startDirective() {
                this.directive = true;
            }

            @Override
            public void endDirective() {
                this.directive = false;
            }

            @Override
            public void startQuotedString() {
                this.quoted = true;
            }

            @Override
            public void endQuotedString() {
                this.quoted = false;
            }

            @Override
            public void onCharacter(char c) {
                if (!this.quoted && !this.directive) {
                    sb.append(c);
                }
            }
        });
        int length = sb.length();
        return sb.substring(0, length > 0 ? length - 1 : length);
    }

    public static void visitPackageDefinition(String definition, PackageDefinitionVisitor visitor) {
        boolean pattern = false;
        boolean quotedString = false;
        boolean directive = false;
        for (char c : definition.toCharArray()) {
            if (c == '\"') {
                boolean bl = quotedString = !quotedString;
                if (quotedString) {
                    visitor.startQuotedString();
                    continue;
                }
                visitor.endQuotedString();
                continue;
            }
            if (!quotedString) {
                if (c == ';') {
                    if (directive) {
                        visitor.endDirective();
                    }
                    visitor.startDirective();
                    directive = true;
                    continue;
                }
                if (c == ',') {
                    if (directive) {
                        visitor.endDirective();
                    }
                    if (pattern) {
                        visitor.endPattern();
                    }
                    directive = false;
                    visitor.startPattern();
                    pattern = true;
                    continue;
                }
            }
            if (!pattern) {
                visitor.startPattern();
                pattern = true;
            }
            visitor.onCharacter(c);
        }
        if (quotedString) {
            visitor.endQuotedString();
        }
        if (directive) {
            visitor.endDirective();
        }
        if (pattern) {
            visitor.endPattern();
        }
    }
}

