/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.ant;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.AntTargetExecutor;
import org.apache.tools.ant.module.api.support.AntScriptUtils;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.extexecution.startup.StartupExtender;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.queries.BinaryForSourceQuery;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.usages.BuildArtifactMapperImpl;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.project.runner.JavaRunnerImplementation;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.modules.Places;
import org.openide.modules.SpecificationVersion;
import org.openide.util.BaseUtilities;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.Union2;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.InputOutput;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public class ProjectRunnerImpl
implements JavaRunnerImplementation {
    private static final Logger LOG = Logger.getLogger(ProjectRunnerImpl.class.getName());
    private static final SpecificationVersion JDK9 = new SpecificationVersion("9");
    private static final Runnable NOP = () -> {};
    private static final RequestProcessor RP = new RequestProcessor(ProjectRunnerImpl.class);

    public boolean isSupported(String command, Map<String, ?> properties) {
        return ProjectRunnerImpl.locateScript(command) != null;
    }

    public ExecutorTask execute(String command, Map<String, ?> properties) throws IOException {
        if ("clean".equals(command)) {
            return ProjectRunnerImpl.clean(properties);
        }
        Work work = new Work(command, properties);
        WrapperTask res = new WrapperTask(work);
        work.setCallback((Runnable)((Object)res));
        RP.execute((Runnable)work);
        return res;
    }

    static Map<String, String> computeProperties(String command, Map<String, ?> properties, String[] projectNameOut) {
        Charset charset;
        String encoding;
        FileObject d;
        Project project;
        properties = new HashMap(properties);
        FileObject toRun = ProjectRunnerImpl.getValue(properties, "execute.file", FileObject.class);
        String workDir = ProjectRunnerImpl.getValue(properties, "work.dir", String.class);
        String className = ProjectRunnerImpl.getValue(properties, "classname", String.class);
        ClassPath boot = ProjectRunnerImpl.getValue(properties, "boot.classpath", ClassPath.class);
        ClassPath exec = ProjectRunnerImpl.getValue(properties, "execute.classpath", ClassPath.class);
        ClassPath execModule = ProjectRunnerImpl.getValue(properties, "execute.modulepath", ClassPath.class);
        String javaTool = ProjectRunnerImpl.getValue(properties, "platform.java", String.class);
        String projectName = ProjectRunnerImpl.getValue(properties, "project.name", String.class);
        List<String> args = ProjectRunnerImpl.getMultiValue(properties, "application.args", String.class);
        String tmpDir = ProjectRunnerImpl.getValue(properties, "tmp.dir", String.class);
        Boolean javaFailOnError = ProjectRunnerImpl.getValue(properties, "java.failonerror", Boolean.class);
        if (workDir == null) {
            Parameters.notNull((CharSequence)"execute.file or work.dir", (Object)toRun);
            Project project2 = FileOwnerQuery.getOwner((FileObject)toRun);
            if (project2 != null) {
                FileObject projDirectory = project2.getProjectDirectory();
                assert (projDirectory != null);
                File file = FileUtil.toFile((FileObject)projDirectory);
                if (file != null) {
                    workDir = file.getAbsolutePath();
                }
            }
        } else if (!new File(workDir).isDirectory()) {
            IllegalArgumentException iae = new IllegalArgumentException("The work dir is not a folder.");
            Exceptions.attachLocalizedMessage((Throwable)iae, (String)NbBundle.getMessage(ProjectRunnerImpl.class, (String)"ERR_NoWorkDir"));
            throw iae;
        }
        if (className == null) {
            Parameters.notNull((CharSequence)"execute.file or classname", (Object)toRun);
            ClassPath source = ClassPath.getClassPath((FileObject)toRun, (String)"classpath/source");
            if (source == null) {
                throw new IllegalArgumentException("The source classpath for specified toRun parameter has is null. Report against caller module. [toRun = " + toRun + "]");
            }
            className = source.getResourceName(toRun, '.', false);
        }
        if (exec == null) {
            Parameters.notNull((CharSequence)"execute.file or execute.classpath", (Object)toRun);
            String sl = SourceLevelQuery.getSourceLevel((FileObject)toRun);
            if (sl != null && JDK9.compareTo((Object)new SpecificationVersion(sl)) <= 0) {
                exec = ClassPath.getClassPath((FileObject)toRun, (String)"modules/execute-classpath");
                if (execModule == null) {
                    execModule = ClassPath.getClassPath((FileObject)toRun, (String)"modules/execute");
                }
            } else {
                exec = ClassPath.getClassPath((FileObject)toRun, (String)"classpath/execute");
                execModule = ClassPath.EMPTY;
            }
        } else if (execModule == null) {
            execModule = ClassPath.EMPTY;
        }
        JavaPlatform p = ProjectRunnerImpl.getValue(properties, "platform", JavaPlatform.class);
        if (p == null) {
            p = JavaPlatform.getDefault();
        }
        if (javaTool == null) {
            FileObject javaToolFO = p.findTool("java");
            if (javaToolFO == null) {
                IllegalArgumentException iae = new IllegalArgumentException("Cannot find java");
                Exceptions.attachLocalizedMessage((Throwable)iae, (String)NbBundle.getMessage(ProjectRunnerImpl.class, (String)"ERR_CannotFindJava"));
                throw iae;
            }
            javaTool = FileUtil.toFile((FileObject)javaToolFO).getAbsolutePath();
        }
        if (boot == null) {
            boot = p.getBootstrapLibraries();
        }
        if ((project = ProjectRunnerImpl.getValue(properties, "project", Project.class)) == null && toRun != null) {
            project = FileOwnerQuery.getOwner((FileObject)toRun);
        }
        if (project == null && workDir != null && (d = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(workDir)))) != null) {
            try {
                project = ProjectManager.getDefault().findProject(d);
            }
            catch (IOException x) {
                Exceptions.printStackTrace((Throwable)x);
            }
        }
        if (projectName == null) {
            projectName = project != null ? ProjectUtils.getInformation((Project)project).getDisplayName() : "";
        }
        ArrayList<String> runJVMArgs = new ArrayList<String>(ProjectRunnerImpl.getMultiValue(properties, "run.jvmargs", String.class));
        Object mode = command.equals("run") ? StartupExtender.StartMode.NORMAL : (command.equals("debug") ? StartupExtender.StartMode.DEBUG : (command.equals("junit") ? StartupExtender.StartMode.TEST_NORMAL : (command.equals("junit-debug") ? StartupExtender.StartMode.TEST_DEBUG : null)));
        if (mode != null) {
            InstanceContent ic = new InstanceContent();
            if (project != null) {
                ic.add((Object)project);
            }
            if (p != null) {
                ic.add((Object)p);
            }
            AbstractLookup l = new AbstractLookup((AbstractLookup.Content)ic);
            for (StartupExtender group : StartupExtender.getExtenders((Lookup)l, (StartupExtender.StartMode)mode)) {
                runJVMArgs.addAll(group.getArguments());
            }
        }
        LOG.log(Level.FINE, "execute classpath={0}", exec);
        TreeMap<String, String> antProps = new TreeMap<String, String>();
        ProjectRunnerImpl.setProperty(antProps, "platform.bootcp", boot.toString(ClassPath.PathConversionMode.FAIL, ClassPath.PathEmbeddingMode.INCLUDE));
        ProjectRunnerImpl.setProperty(antProps, "classpath", ProjectRunnerImpl.pathToString(exec));
        ProjectRunnerImpl.setProperty(antProps, "classname", className);
        ProjectRunnerImpl.setProperty(antProps, "platform.java", javaTool);
        ProjectRunnerImpl.setProperty(antProps, "work.dir", workDir);
        ProjectRunnerImpl.setProperty(antProps, "run.jvmargs", ProjectRunnerImpl.toOneLine(runJVMArgs));
        ProjectRunnerImpl.setProperty(antProps, "run.jvmargs.ide", (String)properties.get("run.jvmargs.ide"));
        if (tmpDir != null) {
            ProjectRunnerImpl.setProperty(antProps, "tmp.dir", tmpDir);
        }
        if (toRun == null) {
            ProjectRunnerImpl.setProperty(antProps, "application.args", ProjectRunnerImpl.toOneLine(args));
        }
        if (javaFailOnError != null) {
            ProjectRunnerImpl.setProperty(antProps, "java.failonerror", javaFailOnError.toString());
        }
        String string = encoding = (charset = ProjectRunnerImpl.getValue(properties, "runtime.encoding", Charset.class)) != null && Charset.isSupported(charset.name()) ? charset.name() : null;
        if (encoding == null) {
            Charset sourceEncoding;
            FileObject source = toRun;
            if (source == null) {
                source = ProjectRunnerImpl.findSource(className, exec, execModule);
            }
            if (source != null && Charset.isSupported((sourceEncoding = FileEncodingQuery.getEncoding((FileObject)source)).name())) {
                encoding = sourceEncoding.name();
            }
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        ProjectRunnerImpl.setProperty(antProps, "encoding", encoding);
        boolean modulesSupported = false;
        String classNameFin = className;
        ClassPath execFin = exec;
        ClassPath execModuleFin = execModule;
        Pair binSrcRoots = Optional.ofNullable(toRun).map(src -> {
            ClassPath scp = ClassPath.getClassPath((FileObject)src, (String)"classpath/source");
            return scp != null ? scp.findOwnerRoot(src) : null;
        }).map(srcRoot -> {
            URL[] brts = ProjectRunnerImpl.removeArchives(BinaryForSourceQuery.findBinaryRoots((URL)srcRoot.toURL()).getRoots());
            switch (brts.length) {
                case 0: {
                    return null;
                }
                case 1: {
                    return Pair.of((Object)brts[0], (Object)new FileObject[]{srcRoot});
                }
            }
            ClassPath bcp = ClassPathSupport.createClassPath((URL[])brts);
            FileObject bcpOwner = ProjectRunnerImpl.findOwnerRoot(classNameFin, new String[]{"class"}, bcp);
            return bcpOwner != null ? Pair.of((Object)bcpOwner.toURL(), (Object)new FileObject[]{srcRoot}) : null;
        }).orElseGet(() -> {
            HashMap<URL, Pair<URL, FileObject[]>> dictionary = new HashMap<URL, Pair<URL, FileObject[]>>();
            ClassPath translatedExec = ProjectRunnerImpl.translate(execFin, dictionary);
            ClassPath translatedExecModule = ProjectRunnerImpl.translate(execModuleFin, dictionary);
            FileObject bcpOwner = ProjectRunnerImpl.findOwnerRoot(classNameFin, new String[]{"sig", "class"}, translatedExec, translatedExecModule);
            if (bcpOwner == null) {
                return null;
            }
            return (Pair)dictionary.get(bcpOwner.toURL());
        });
        if (binSrcRoots != null) {
            String sl;
            Object slFo;
            if (toRun != null) {
                slFo = toRun;
            } else if (((FileObject[])binSrcRoots.second()).length > 0) {
                slFo = ((FileObject[])binSrcRoots.second())[0];
            } else {
                slFo = URLMapper.findFileObject((URL)((URL)binSrcRoots.first()));
                if (slFo == null) {
                    slFo = project != null ? project.getProjectDirectory() : null;
                }
            }
            String string2 = sl = slFo != null ? SourceLevelQuery.getSourceLevel((FileObject)slFo) : null;
            if (sl != null && JDK9.compareTo((Object)new SpecificationVersion(sl)) <= 0) {
                URL[] mainRootUrls;
                modulesSupported = true;
                URL mainBinRoot = null;
                if (((FileObject[])binSrcRoots.second()).length > 0 && (mainRootUrls = UnitTestForSourceQuery.findSources((FileObject)((FileObject[])binSrcRoots.second())[0])).length > 0) {
                    URL[] mainBinRoots = ProjectRunnerImpl.removeArchives(BinaryForSourceQuery.findBinaryRoots((URL)mainRootUrls[0]).getRoots());
                    switch (mainBinRoots.length) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            mainBinRoot = mainBinRoots[0];
                            break;
                        }
                        default: {
                            FileObject[] brs;
                            ClassPath bcp = ClassPathSupport.createClassPath((URL[])mainBinRoots);
                            FileObject bcpOwner = ProjectRunnerImpl.findOwnerRoot("module-info", new String[]{"class"}, bcp);
                            mainBinRoot = bcpOwner != null ? bcpOwner.toURL() : ((brs = bcp.getRoots()).length == 0 ? null : brs[0].toURL());
                        }
                    }
                }
                ProjectRunnerImpl.setProperty(antProps, "modules.supported.internal", "true");
                try {
                    ProjectRunnerImpl.setProperty(antProps, "module.root", BaseUtilities.toFile((URI)((URL)binSrcRoots.first()).toURI()).getAbsolutePath());
                }
                catch (URISyntaxException e) {
                    LOG.log(Level.WARNING, "Non local target folder:{0}", binSrcRoots.first());
                }
                String moduleName = ProjectRunnerImpl.getModuleName((URL)binSrcRoots.first(), (FileObject[])binSrcRoots.second());
                String mainModuleName = ProjectRunnerImpl.getModuleName(mainBinRoot);
                if (moduleName != null) {
                    ProjectRunnerImpl.setProperty(antProps, "module.name", moduleName);
                    ProjectRunnerImpl.setProperty(antProps, "named.module.internal", "true");
                } else {
                    ProjectRunnerImpl.setProperty(antProps, "unnamed.module.internal", "true");
                }
                if (mainBinRoot != null && mainModuleName != null) {
                    ProjectRunnerImpl.setProperty(antProps, "related.module.name", mainModuleName);
                }
            }
        }
        if (modulesSupported || !execModule.entries().isEmpty()) {
            ProjectRunnerImpl.setProperty(antProps, "modulepath", ProjectRunnerImpl.pathToString(execModule));
        }
        for (Map.Entry<String, ?> e : properties.entrySet()) {
            if (!(e.getValue() instanceof String)) continue;
            antProps.put(e.getKey(), (String)e.getValue());
        }
        projectNameOut[0] = projectName;
        return antProps;
    }

    @NonNull
    private static String pathToString(@NonNull ClassPath path) {
        StringBuilder cpBuilder = new StringBuilder();
        for (ClassPath.Entry entry : path.entries()) {
            URL u = entry.getURL();
            boolean folder = "file".equals(u.getProtocol());
            File f = FileUtil.archiveOrDirForURL((URL)u);
            if (f == null) continue;
            if (cpBuilder.length() > 0) {
                cpBuilder.append(File.pathSeparatorChar);
            }
            cpBuilder.append(f.getAbsolutePath());
            if (!folder) continue;
            cpBuilder.append(File.separatorChar);
        }
        return cpBuilder.toString();
    }

    @CheckForNull
    private static FileObject findSource(@NonNull String className, ClassPath ... binCps) {
        FileObject[] srcRoots = Optional.ofNullable(ProjectRunnerImpl.findOwnerRoot(className, new String[]{"class"}, binCps)).map(root -> SourceForBinaryQuery.findSourceRoots((URL)root.toURL()).getRoots()).orElse(new FileObject[0]);
        String sourceResource = className.replace('.', '/') + ".java";
        for (FileObject srcRoot : srcRoots) {
            FileObject srcFile = srcRoot.getFileObject(sourceResource);
            if (srcFile == null) continue;
            return srcFile;
        }
        return null;
    }

    @NonNull
    private static ClassPath translate(@NonNull ClassPath cp, @NonNull Map<URL, Pair<URL, FileObject[]>> dictionary) {
        ArrayList<URL> roots = new ArrayList<URL>(cp.entries().size());
        for (ClassPath.Entry e : cp.entries()) {
            URL orig = e.getURL();
            SourceForBinaryQuery.Result2 res = SourceForBinaryQuery.findSourceRoots2((URL)orig);
            if (res.preferSources()) {
                FileObject[] srcs;
                for (FileObject src : srcs = res.getRoots()) {
                    try {
                        URL cacheURL = BaseUtilities.toURI((File)JavaIndex.getClassFolder((URL)src.toURL())).toURL();
                        dictionary.put(cacheURL, (Pair<URL, FileObject[]>)Pair.of((Object)orig, (Object)res.getRoots()));
                        roots.add(cacheURL);
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                }
                continue;
            }
            dictionary.put(orig, (Pair<URL, FileObject[]>)Pair.of((Object)orig, (Object)res.getRoots()));
            roots.add(orig);
        }
        return ClassPathSupport.createClassPath((URL[])roots.toArray(new URL[roots.size()]));
    }

    @CheckForNull
    private static FileObject findOwnerRoot(@NonNull String className, @NonNull String[] extensions, ClassPath ... binCps) {
        String binaryResource = FileObjects.convertPackage2Folder((String)className);
        ClassPath merged = ClassPathSupport.createProxyClassPath((ClassPath[])binCps);
        for (String ext : extensions) {
            FileObject res = merged.findResource(String.format("%s.%s", binaryResource, ext));
            if (res == null) continue;
            return merged.findOwnerRoot(res);
        }
        return null;
    }

    @CheckForNull
    private static String getModuleName(@NullAllowed URL binRoot) {
        return binRoot == null ? null : ProjectRunnerImpl.getModuleName(binRoot, SourceForBinaryQuery.findSourceRoots((URL)binRoot).getRoots());
    }

    @CheckForNull
    private static String getModuleName(@NonNull URL binRoot, @NonNull FileObject[] srcRoots) {
        if (Arrays.stream(srcRoots).anyMatch(fo -> fo.getFileObject("module-info.java") != null)) {
            return SourceUtils.getModuleName((URL)binRoot);
        }
        return null;
    }

    private static URL[] removeArchives(URL ... orig) {
        ArrayList<URL> res = new ArrayList<URL>(orig.length);
        for (URL url : orig) {
            if (FileUtil.isArchiveArtifact((URL)url)) continue;
            res.add(url);
        }
        return res.isEmpty() ? orig : res.toArray(new URL[res.size()]);
    }

    private static ExecutorTask clean(Map<String, ?> properties) {
        properties = new HashMap(properties);
        String projectName = ProjectRunnerImpl.getValue(properties, "project.name", String.class);
        FileObject toRun = ProjectRunnerImpl.getValue(properties, "execute.file", FileObject.class);
        ClassPath exec = ProjectRunnerImpl.getValue(properties, "execute.classpath", ClassPath.class);
        if (exec == null) {
            Parameters.notNull((CharSequence)"toRun", (Object)toRun);
            exec = ClassPath.getClassPath((FileObject)toRun, (String)"classpath/execute");
        }
        if (projectName == null) {
            Project project = ProjectRunnerImpl.getValue(properties, "project", Project.class);
            if (project != null) {
                projectName = ProjectUtils.getInformation((Project)project).getDisplayName();
            }
            if (projectName == null && toRun != null && (project = FileOwnerQuery.getOwner((FileObject)toRun)) != null) {
                projectName = ProjectUtils.getInformation((Project)project).getDisplayName();
            }
            if (projectName == null) {
                projectName = "";
            }
        }
        LOG.log(Level.FINE, "execute classpath={0}", exec);
        final ClassPath execFin = exec;
        return ExecutionEngine.getDefault().execute(projectName, new Runnable(){

            @Override
            public void run() {
                try {
                    ProjectRunnerImpl.doClean(execFin);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }, InputOutput.NULL);
    }

    private static void setProperty(Map<String, String> antProps, String property, String value) {
        if (value != null) {
            antProps.put(property, value);
        }
    }

    private static <T> T getValue(Map<String, ?> properties, String name, Class<T> type) {
        Object v = properties.remove(name);
        if (v instanceof FileObject && type == String.class) {
            FileObject f = (FileObject)v;
            File file = FileUtil.toFile((FileObject)f);
            if (file == null) {
                return null;
            }
            v = file.getAbsolutePath();
        }
        if (v instanceof File && type == String.class) {
            v = ((File)v).getAbsolutePath();
        }
        return type.cast(v);
    }

    private static <T> List<T> getMultiValue(Map<String, ?> properties, String name, Class<T> type) {
        Iterable v = (Iterable)properties.remove(name);
        LinkedList<T> result = new LinkedList<T>();
        if (v == null) {
            return Collections.emptyList();
        }
        for (Object o : v) {
            result.add(type.cast(o));
        }
        return result;
    }

    private static String toOneLine(Iterable<String> it) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String s : it) {
            if (!first) {
                result.append(' ');
            }
            first = false;
            result.append(s);
        }
        return result.toString();
    }

    private static URL locateScript(String actionName) {
        return ProjectRunnerImpl.class.getResource("/org/netbeans/modules/java/source/ant/resources/" + actionName + "-snippet.xml");
    }

    private static FileObject buildScript(String actionName, boolean forceCopy) throws IOException {
        URL script = ProjectRunnerImpl.locateScript(actionName);
        if (script == null) {
            return null;
        }
        URL thisClassSource = ProjectRunnerImpl.class.getProtectionDomain().getCodeSource().getLocation();
        File jarFile = FileUtil.archiveOrDirForURL((URL)thisClassSource);
        File scriptFile = Places.getCacheSubfile((String)("executor-snippets/" + actionName + ".xml"));
        if (forceCopy || !scriptFile.canRead() || jarFile != null && jarFile.lastModified() > scriptFile.lastModified()) {
            try {
                URLConnection connection = script.openConnection();
                FileObject target = FileUtil.createData((File)scriptFile);
                ProjectRunnerImpl.copyFile(connection, target);
                return target;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }
        return FileUtil.toFileObject((File)scriptFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(URLConnection source, FileObject target) throws IOException {
        InputStream ins = null;
        OutputStream out = null;
        try {
            ins = source.getInputStream();
            out = target.getOutputStream();
            FileUtil.copy((InputStream)ins, (OutputStream)out);
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private static void doClean(ClassPath exec) throws IOException {
        for (ClassPath.Entry entry : exec.entries()) {
            SourceForBinaryQuery.Result2 r = SourceForBinaryQuery.findSourceRoots2((URL)entry.getURL());
            if (!r.preferSources() || r.getRoots().length <= 0) continue;
            for (FileObject source : r.getRoots()) {
                File sourceFile = FileUtil.toFile((FileObject)source);
                if (sourceFile == null) {
                    LOG.log(Level.WARNING, "Source URL: {0} cannot be translated to file, skipped", source.toURL().toExternalForm());
                    continue;
                }
                BuildArtifactMapperImpl.clean((URL)Utilities.toURI((File)sourceFile).toURL());
            }
        }
    }

    private final class WrapperTask
    extends ExecutorTask {
        private final Work work;

        WrapperTask(Work work) {
            super(NOP);
            this.work = work;
        }

        public void stop() {
            this.work.stop();
        }

        public int result() {
            Union2 result = this.work.getResult();
            return result == null || result.hasSecond() ? -1 : ((ExecutorTask)result.first()).result();
        }

        public InputOutput getInputOutput() {
            Union2 result = this.work.getResult();
            return result == null || result.hasSecond() ? InputOutput.NULL : ((ExecutorTask)result.first()).getInputOutput();
        }
    }

    private final class Work
    implements Runnable {
        private final String command;
        private final Map<String, ?> properties;
        private final AtomicReference<Runnable> callBack;
        private Union2<ExecutorTask, Throwable> result;
        private boolean stopped;

        Work(String command, Map<String, ?> properties) {
            this.command = command;
            this.properties = properties;
            this.callBack = new AtomicReference<Runnable>(NOP);
        }

        void setCallback(Runnable callBack) {
            if (!this.callBack.compareAndSet(NOP, callBack)) {
                throw new IllegalStateException("Already set");
            }
        }

        @Override
        public void run() {
            block3: {
                try {
                    String[] projectName = new String[1];
                    Map<String, String> antProps = ProjectRunnerImpl.computeProperties(this.command, this.properties, projectName);
                    FileObject script = ProjectRunnerImpl.buildScript(this.command, false);
                    FakeAntProjectCookie apc = new FakeAntProjectCookie(AntScriptUtils.antProjectCookieFor((FileObject)script), this.command, projectName[0]);
                    AntTargetExecutor.Env execenv = new AntTargetExecutor.Env();
                    Properties props = execenv.getProperties();
                    props.putAll(antProps);
                    props.put("nb.wait.for.caches", "true");
                    if (this.properties.containsKey("maven.disableSources")) {
                        props.put("maven.disableSources", String.valueOf(this.properties.get("maven.disableSources")));
                    }
                    execenv.setProperties(props);
                    this.setResult((Union2<ExecutorTask, Throwable>)Union2.createFirst((Object)AntTargetExecutor.createTargetExecutor((AntTargetExecutor.Env)execenv).execute((AntProjectCookie)apc, null)));
                }
                catch (Throwable t) {
                    this.setResult((Union2<ExecutorTask, Throwable>)Union2.createSecond((Object)t));
                    if (!(t instanceof ThreadDeath)) break block3;
                    throw (ThreadDeath)t;
                }
            }
        }

        private synchronized void setResult(Union2<ExecutorTask, Throwable> result) {
            this.result = result;
            if (result.hasFirst()) {
                ((ExecutorTask)result.first()).addTaskListener(new TaskListener(){

                    public void taskFinished(Task task) {
                        ((Runnable)Work.this.callBack.get()).run();
                    }
                });
                if (this.stopped) {
                    ((ExecutorTask)result.first()).stop();
                }
            } else {
                this.callBack.get().run();
            }
            this.notifyAll();
        }

        private synchronized Union2<ExecutorTask, Throwable> getResult() {
            while (this.result == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    return null;
                }
            }
            return this.result;
        }

        private synchronized void stop() {
            if (this.result != null && this.result.hasFirst()) {
                ((ExecutorTask)this.result.first()).stop();
            } else {
                this.stopped = true;
            }
        }
    }

    private static final class FakeElement
    implements Element {
        private final Element delegate;
        private final String projectName;

        public FakeElement(Element delegate, String projectName) {
            Parameters.notNull((CharSequence)"delegate", (Object)delegate);
            this.delegate = delegate;
            this.projectName = projectName;
        }

        @Override
        public Object setUserData(String key, Object data, UserDataHandler handler) {
            return this.delegate.setUserData(key, data, handler);
        }

        @Override
        public void setTextContent(String textContent) throws DOMException {
            this.delegate.setTextContent(textContent);
        }

        @Override
        public void setPrefix(String prefix) throws DOMException {
            this.delegate.setPrefix(prefix);
        }

        @Override
        public void setNodeValue(String nodeValue) throws DOMException {
            this.delegate.setNodeValue(nodeValue);
        }

        @Override
        public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
            return this.delegate.replaceChild(newChild, oldChild);
        }

        @Override
        public Node removeChild(Node oldChild) throws DOMException {
            return this.delegate.removeChild(oldChild);
        }

        @Override
        public void normalize() {
            this.delegate.normalize();
        }

        @Override
        public String lookupPrefix(String namespaceURI) {
            return this.delegate.lookupPrefix(namespaceURI);
        }

        @Override
        public String lookupNamespaceURI(String prefix) {
            return this.delegate.lookupNamespaceURI(prefix);
        }

        @Override
        public boolean isSupported(String feature, String version) {
            return this.delegate.isSupported(feature, version);
        }

        @Override
        public boolean isSameNode(Node other) {
            return this.delegate.isSameNode(other);
        }

        @Override
        public boolean isEqualNode(Node arg) {
            return this.delegate.isEqualNode(arg);
        }

        @Override
        public boolean isDefaultNamespace(String namespaceURI) {
            return this.delegate.isDefaultNamespace(namespaceURI);
        }

        @Override
        public Node insertBefore(Node newChild, Node refChild) throws DOMException {
            return this.delegate.insertBefore(newChild, refChild);
        }

        @Override
        public boolean hasChildNodes() {
            return this.delegate.hasChildNodes();
        }

        @Override
        public boolean hasAttributes() {
            return this.delegate.hasAttributes();
        }

        @Override
        public Object getUserData(String key) {
            return this.delegate.getUserData(key);
        }

        @Override
        public String getTextContent() throws DOMException {
            return this.delegate.getTextContent();
        }

        @Override
        public Node getPreviousSibling() {
            return this.delegate.getPreviousSibling();
        }

        @Override
        public String getPrefix() {
            return this.delegate.getPrefix();
        }

        @Override
        public Node getParentNode() {
            return this.delegate.getParentNode();
        }

        @Override
        public Document getOwnerDocument() {
            return this.delegate.getOwnerDocument();
        }

        @Override
        public String getNodeValue() throws DOMException {
            return this.delegate.getNodeValue();
        }

        @Override
        public short getNodeType() {
            return this.delegate.getNodeType();
        }

        @Override
        public String getNodeName() {
            return this.delegate.getNodeName();
        }

        @Override
        public Node getNextSibling() {
            return this.delegate.getNextSibling();
        }

        @Override
        public String getNamespaceURI() {
            return this.delegate.getNamespaceURI();
        }

        @Override
        public String getLocalName() {
            return this.delegate.getLocalName();
        }

        @Override
        public Node getLastChild() {
            return this.delegate.getLastChild();
        }

        @Override
        public Node getFirstChild() {
            return this.delegate.getFirstChild();
        }

        @Override
        public Object getFeature(String feature, String version) {
            return this.delegate.getFeature(feature, version);
        }

        @Override
        public NodeList getChildNodes() {
            return this.delegate.getChildNodes();
        }

        @Override
        public String getBaseURI() {
            return this.delegate.getBaseURI();
        }

        @Override
        public NamedNodeMap getAttributes() {
            return this.delegate.getAttributes();
        }

        @Override
        public short compareDocumentPosition(Node other) throws DOMException {
            return this.delegate.compareDocumentPosition(other);
        }

        @Override
        public Node cloneNode(boolean deep) {
            return this.delegate.cloneNode(deep);
        }

        @Override
        public Node appendChild(Node newChild) throws DOMException {
            return this.delegate.appendChild(newChild);
        }

        @Override
        public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
            this.delegate.setIdAttributeNode(idAttr, isId);
        }

        @Override
        public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
            this.delegate.setIdAttributeNS(namespaceURI, localName, isId);
        }

        @Override
        public void setIdAttribute(String name, boolean isId) throws DOMException {
            this.delegate.setIdAttribute(name, isId);
        }

        @Override
        public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
            return this.delegate.setAttributeNodeNS(newAttr);
        }

        @Override
        public Attr setAttributeNode(Attr newAttr) throws DOMException {
            return this.delegate.setAttributeNode(newAttr);
        }

        @Override
        public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
            this.delegate.setAttributeNS(namespaceURI, qualifiedName, value);
        }

        @Override
        public void setAttribute(String name, String value) throws DOMException {
            this.delegate.setAttribute(name, value);
        }

        @Override
        public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
            return this.delegate.removeAttributeNode(oldAttr);
        }

        @Override
        public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
            this.delegate.removeAttributeNS(namespaceURI, localName);
        }

        @Override
        public void removeAttribute(String name) throws DOMException {
            this.delegate.removeAttribute(name);
        }

        @Override
        public boolean hasAttributeNS(String namespaceURI, String localName) throws DOMException {
            return this.delegate.hasAttributeNS(namespaceURI, localName);
        }

        @Override
        public boolean hasAttribute(String name) {
            return this.delegate.hasAttribute(name);
        }

        @Override
        public String getTagName() {
            return this.delegate.getTagName();
        }

        @Override
        public TypeInfo getSchemaTypeInfo() {
            return this.delegate.getSchemaTypeInfo();
        }

        @Override
        public NodeList getElementsByTagNameNS(String namespaceURI, String localName) throws DOMException {
            return this.delegate.getElementsByTagNameNS(namespaceURI, localName);
        }

        @Override
        public NodeList getElementsByTagName(String name) {
            return this.delegate.getElementsByTagName(name);
        }

        @Override
        public Attr getAttributeNodeNS(String namespaceURI, String localName) throws DOMException {
            return this.delegate.getAttributeNodeNS(namespaceURI, localName);
        }

        @Override
        public Attr getAttributeNode(String name) {
            return this.delegate.getAttributeNode(name);
        }

        @Override
        public String getAttributeNS(String namespaceURI, String localName) throws DOMException {
            return this.delegate.getAttributeNS(namespaceURI, localName);
        }

        @Override
        public String getAttribute(String name) {
            if ("name".equals(name)) {
                String pattern = this.delegate.getAttribute(name);
                return MessageFormat.format(pattern, this.projectName);
            }
            return this.delegate.getAttribute(name);
        }
    }

    private static final class FakeAntProjectCookie
    implements AntProjectCookie,
    ChangeListener {
        private final AntProjectCookie apc;
        private final String command;
        private final String projectName;
        private final ChangeSupport cs = new ChangeSupport((Object)this);

        public FakeAntProjectCookie(AntProjectCookie apc, String command, String projectName) {
            this.apc = apc;
            this.apc.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)this.apc));
            this.command = command;
            this.projectName = projectName;
        }

        public File getFile() {
            return this.apc.getFile();
        }

        public FileObject getFileObject() {
            return this.apc.getFileObject();
        }

        public Document getDocument() {
            return this.apc.getDocument();
        }

        public Element getProjectElement() {
            Element element = this.apc.getProjectElement();
            if (element == null || this.apc.getParseException() != null) {
                File fo = this.apc.getFile();
                LOG.log(Level.FINE, String.format("Cannot parse: %s exists: %b readable: %b", fo == null ? null : fo.getAbsolutePath(), fo == null ? false : fo.exists(), fo == null ? false : fo.canRead()));
                try {
                    DataObject od = DataObject.find((FileObject)ProjectRunnerImpl.buildScript(this.command, true));
                    if (od instanceof PropertyChangeListener) {
                        ((PropertyChangeListener)od).propertyChange(new PropertyChangeEvent(od, null, null, null));
                    }
                }
                catch (IOException ex) {
                    throw new IllegalStateException(ex);
                }
                element = this.apc.getProjectElement();
                if (element == null) {
                    return null;
                }
            }
            return new FakeElement(element, this.projectName);
        }

        public Throwable getParseException() {
            return this.apc.getParseException();
        }

        public void addChangeListener(ChangeListener l) {
            this.cs.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.cs.removeChangeListener(l);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.cs.fireChange();
        }
    }
}

